/*
 * Decompiled with CFR 0.152.
 */
package com.squoshi.irons_spells_js.item;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.squoshi.irons_spells_js.util.ISSKJSUtils;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.typings.Info;
import io.redspace.ironsspellbooks.api.registry.SpellDataRegistryHolder;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.item.UniqueSpellBook;
import io.redspace.ironsspellbooks.item.spell_books.SimpleAttributeSpellBook;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class SpellBookBuilderJS
extends BuilderBase<SpellBook> {
    public transient SpellDataRegistryHolder[] spellDataRegistryHolder = SpellDataRegistryHolder.of((SpellDataRegistryHolder[])new SpellDataRegistryHolder[0]);
    public transient List<SpellHolder> spellHolders = new ArrayList<SpellHolder>();
    public transient int maxSpellSlots = 1;
    public transient List<AttributeHolder> defaultModifiers = new ArrayList<AttributeHolder>();

    public SpellBookBuilderJS(ResourceLocation i) {
        super(i);
        this.tag(new ResourceLocation("curios:spellbook"));
    }

    public RegistryInfo<Item> getRegistryType() {
        return RegistryInfo.ITEM;
    }

    @Info(value="        Adds a default attribute to the item. Can be used multiple times. It takes an attribute ID (or just an attribute object), the modifier name, the modifier amount, and the modifier operation.\n        The modifier operation can be either `ADDITION`, `MULTIPLY_TOTAL` or `MULTIPLY_BASE`.\n")
    public SpellBookBuilderJS addDefaultAttribute(ISSKJSUtils.AttributeHolder attribute, String modifierName, double modifierAmount, AttributeModifier.Operation modifierOperation) {
        this.defaultModifiers.add(new AttributeHolder(attribute.getLocation(), new AttributeModifier(modifierName, modifierAmount, modifierOperation)));
        return this;
    }

    @Info(value="        Sets the maximum amount of spell slots the spell book can have.\n")
    public SpellBookBuilderJS setMaxSpellSlots(int maxSpellSlots) {
        this.maxSpellSlots = maxSpellSlots;
        return this;
    }

    @Info(value="        Adds a default spell to the item. Can be used multiple times. It takes a spell ID (or a spell object) and the spell level.\n")
    public SpellBookBuilderJS addDefaultSpell(ISSKJSUtils.SpellHolder spell, int spellLevel) {
        this.spellHolders.add(new SpellHolder(spell.getLocation(), spellLevel));
        return this;
    }

    public SpellBook createObject() {
        ArrayListMultimap map = ArrayListMultimap.create();
        for (AttributeHolder holder : this.defaultModifiers) {
            Attribute attribute = Objects.requireNonNull((Attribute)ForgeRegistries.ATTRIBUTES.getValue(holder.attribute()));
            map.put((Object)attribute, (Object)holder.modifier());
        }
        SpellDataRegistryHolder[] spellDataHolders = new SpellDataRegistryHolder[this.spellHolders.size()];
        Iterator<SpellHolder> iterator = this.spellHolders.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            SpellHolder spells = iterator.next();
            spellDataHolders[i] = new SpellDataRegistryHolder(RegistryObject.create((ResourceLocation)spells.spell, (IForgeRegistry)((IForgeRegistry)SpellRegistry.REGISTRY.get())), spells.spellLevel);
            ++i;
        }
        if (spellDataHolders.length > 0) {
            return new UniqueSpellBook(SpellRarity.LEGENDARY, spellDataHolders, Math.max(0, this.maxSpellSlots - spellDataHolders.length), () -> SpellBookBuilderJS.lambda$createObject$0((Multimap)map));
        }
        if (!map.isEmpty()) {
            return new SimpleAttributeSpellBook(this.maxSpellSlots, SpellRarity.LEGENDARY, (Multimap)map);
        }
        return new SpellBook(this.maxSpellSlots, SpellRarity.LEGENDARY);
    }

    private static /* synthetic */ Multimap lambda$createObject$0(Multimap map) {
        return map;
    }

    public record AttributeHolder(ResourceLocation attribute, AttributeModifier modifier) {
    }

    public record SpellHolder(ResourceLocation spell, int spellLevel) {
    }
}

