/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.NotorEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class NotorScanGoal
extends Goal {
    private NotorEntity notor;
    private LivingEntity scanTarget;
    private int scanTime = 0;

    public NotorScanGoal(NotorEntity notor) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.notor = notor;
    }

    private int getMaxScanTime() {
        return this.notor.m_9236_().m_46791_() == Difficulty.PEACEFUL ? 40 : 100;
    }

    public boolean m_8036_() {
        long worldTime = this.notor.m_9236_().m_46467_() % 10L;
        if (this.notor.m_217043_().m_188503_(300) != 0 && worldTime != 0L || this.notor.getHologramUUID() != null || this.notor.stopScanningFor > 0) {
            return false;
        }
        AABB aabb = this.notor.m_20191_().m_82400_(25.0);
        List list = this.notor.m_9236_().m_6443_(LivingEntity.class, aabb, NotorEntity.SCAN_TARGET);
        if (!list.isEmpty()) {
            LivingEntity closest = null;
            for (LivingEntity mob : list) {
                if (mob instanceof NotorEntity || (closest != null && !(mob.m_20280_((Entity)this.notor) < closest.m_20280_((Entity)this.notor)) || !this.notor.m_142582_((Entity)mob)) && (closest instanceof Player || !(mob instanceof Player))) continue;
                closest = mob;
            }
            this.scanTarget = closest;
            return this.scanTarget != null;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.scanTarget != null && this.scanTarget.m_6084_() && this.notor.m_142582_((Entity)this.scanTarget) && this.scanTarget.m_20270_((Entity)this.notor) <= 40.0f && this.scanTime < this.getMaxScanTime() && this.notor.getHologramUUID() == null;
    }

    public void m_8056_() {
        this.notor.m_21573_().m_26573_();
        this.scanTime = 0;
        this.notor.setScanningId(-1);
    }

    public void m_8041_() {
        if (this.scanTime >= this.getMaxScanTime() && this.scanTarget != null && this.scanTarget.m_6084_()) {
            this.notor.setHologramUUID(this.scanTarget.m_20148_());
            this.notor.setShowingHologram(false);
            this.notor.stopScanningFor = this.notor.m_217043_().m_188503_(300) + 300;
        }
        this.notor.setScanningId(-1);
    }

    public void m_8037_() {
        double dist = this.scanTarget.m_20270_((Entity)this.notor);
        this.notor.m_7618_(EntityAnchorArgument.Anchor.EYES, this.scanTarget.m_146892_());
        if (dist > 8.0) {
            this.notor.m_21573_().m_26519_(this.scanTarget.m_20185_(), this.scanTarget.m_20227_(1.0) + 1.0, this.scanTarget.m_20189_(), (double)1.2f);
            if (dist > 15.0) {
                this.notor.setScanningId(-1);
            }
        } else {
            this.notor.m_21573_().m_26573_();
            this.notor.setScanningId(this.scanTarget.m_19879_());
            ++this.scanTime;
        }
    }
}

