/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.ACSoundTypes;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PewenBranchBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final Map<Integer, VoxelShape> SHAPES_BY_ROTATION = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(0, Block.m_49796_((double)6.0, (double)2.0, (double)0.0, (double)10.0, (double)6.0, (double)16.0));
        map.put(2, Block.m_49796_((double)0.0, (double)2.0, (double)6.0, (double)16.0, (double)6.0, (double)10.0));
        map.put(4, Block.m_49796_((double)6.0, (double)2.0, (double)0.0, (double)10.0, (double)6.0, (double)16.0));
        map.put(6, Block.m_49796_((double)0.0, (double)2.0, (double)6.0, (double)16.0, (double)6.0, (double)10.0));
        map.put(1, Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0));
        map.put(3, Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0));
        map.put(5, Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0));
        map.put(7, Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0));
    });
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty PINES = BooleanProperty.m_61465_((String)"pines");
    public static final IntegerProperty ROTATION = IntegerProperty.m_61631_((String)"rotation", (int)0, (int)7);

    public PewenBranchBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.GREEN).m_60978_(1.0f).m_60918_(ACSoundTypes.PEWEN_BRANCH).m_60977_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0))).m_61124_((Property)PINES, (Comparable)Boolean.valueOf(true)));
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return (Boolean)state.m_61143_((Property)PINES) != false ? SoundType.f_56740_ : super.getSoundType(state, level, pos, entity);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPES_BY_ROTATION.getOrDefault(state.m_61143_((Property)ROTATION), Shapes.m_83040_());
    }

    public void m_213898_(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource randomSource) {
        this.m_213897_(state, serverLevel, pos, randomSource);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelaccessor = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        int rot = Mth.m_14107_((double)((double)(context.m_7074_() * 8.0f / 360.0f) + 0.5)) & 7;
        BlockPos checkPos = blockpos.m_121955_(PewenBranchBlock.getOffsetConnectToPos(rot));
        for (int loops = 0; !this.isGoodBase(levelaccessor.m_8055_(checkPos), (LevelReader)levelaccessor, checkPos) && loops < 7; ++loops) {
            if (++rot > 7) {
                rot = 0;
            }
            checkPos = blockpos.m_121955_(PewenBranchBlock.getOffsetConnectToPos(rot));
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rot))).m_61124_((Property)PINES, (Comparable)Boolean.valueOf(this.hasPines(rot, (LevelReader)levelaccessor, blockpos)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rotation.m_55949_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), 8)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(mirror.m_54843_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), 8)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.m_121955_(PewenBranchBlock.getOffsetConnectToPos((Integer)state.m_61143_((Property)ROTATION)));
        BlockState state1 = level.m_8055_(blockpos);
        return this.isGoodBase(state1, level, blockpos);
    }

    public boolean isGoodBase(BlockState state, LevelReader level, BlockPos pos) {
        return state.m_60734_() == this || state.m_60838_((BlockGetter)level, pos);
    }

    public boolean hasPines(int rot, LevelReader levelReader, BlockPos pos) {
        BlockPos checkAt = pos.m_121996_(PewenBranchBlock.getOffsetConnectToPos(rot));
        return levelReader.m_8055_(checkAt).m_60734_() != this;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            for (BlockPos tick : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, 0, -1), (BlockPos)pos.m_7918_(1, 1, 1))) {
                level.m_186460_(tick, (Block)this, 1);
            }
            level.m_46961_(pos, true);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        boolean shouldHavePines;
        if (!state.m_60710_((LevelReader)levelAccessor, blockPos)) {
            levelAccessor.m_186460_(blockPos, (Block)this, 1);
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        if ((shouldHavePines = this.hasPines((Integer)state.m_61143_((Property)ROTATION), (LevelReader)levelAccessor, blockPos)) != (Boolean)state.m_61143_((Property)PINES)) {
            return (BlockState)state.m_61124_((Property)PINES, (Comparable)Boolean.valueOf(shouldHavePines));
        }
        return super.m_7417_(state, direction, state1, levelAccessor, blockPos, blockPos1);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ROTATION, WATERLOGGED, PINES});
    }

    public float m_142740_() {
        return 0.0f;
    }

    public float m_142627_() {
        return 0.75f;
    }

    public static Vec3i getOffsetConnectToPos(int rotationValue) {
        switch (rotationValue) {
            case 0: {
                return new Vec3i(0, 0, 1);
            }
            case 1: {
                return new Vec3i(-1, 0, 1);
            }
            case 2: {
                return new Vec3i(-1, 0, 0);
            }
            case 3: {
                return new Vec3i(-1, 0, -1);
            }
            case 4: {
                return new Vec3i(0, 0, -1);
            }
            case 5: {
                return new Vec3i(1, 0, -1);
            }
            case 6: {
                return new Vec3i(1, 0, 0);
            }
            case 7: {
                return new Vec3i(1, 0, 1);
            }
        }
        return Vec3i.f_123288_;
    }
}

