/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.blockentity;

import com.github.alexmodguy.alexscaves.client.model.NuclearFurnaceModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.server.block.NuclearFurnaceBlock;
import com.github.alexmodguy.alexscaves.server.block.blockentity.NuclearFurnaceBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class NuclearFurnaceBlockRenderer<T extends NuclearFurnaceBlockEntity>
implements BlockEntityRenderer<T> {
    private static final NuclearFurnaceModel MODEL = new NuclearFurnaceModel();
    private static final ResourceLocation OFF_TEXTURE = new ResourceLocation("alexscaves", "textures/entity/nuclear_furnace/nuclear_furnace_off.png");
    private static final ResourceLocation ON_TEXTURE = new ResourceLocation("alexscaves", "textures/entity/nuclear_furnace/nuclear_furnace_on.png");
    private static final ResourceLocation SUBCRITICAL_TEXTURE = new ResourceLocation("alexscaves", "textures/entity/nuclear_furnace/nuclear_furnace_subcritical.png");
    private static final ResourceLocation CRITICAL_TEXTURE = new ResourceLocation("alexscaves", "textures/entity/nuclear_furnace/nuclear_furnace_critical.png");
    private static final ResourceLocation SUPERCRITICAL_TEXTURE = new ResourceLocation("alexscaves", "textures/entity/nuclear_furnace/nuclear_furnace_supercritical.png");
    private static final ResourceLocation OFF_TEXTURE_GLOW = new ResourceLocation("alexscaves", "textures/entity/nuclear_furnace/nuclear_furnace_off_glow.png");
    private static final ResourceLocation ON_TEXTURE_GLOW = new ResourceLocation("alexscaves", "textures/entity/nuclear_furnace/nuclear_furnace_on_glow.png");
    private static final ResourceLocation SUBCRITICAL_TEXTURE_GLOW = new ResourceLocation("alexscaves", "textures/entity/nuclear_furnace/nuclear_furnace_subcritical_glow.png");
    private static final ResourceLocation CRITICAL_TEXTURE_GLOW = new ResourceLocation("alexscaves", "textures/entity/nuclear_furnace/nuclear_furnace_critical_glow.png");
    private static final ResourceLocation SUPERCRITICAL_TEXTURE_GLOW = new ResourceLocation("alexscaves", "textures/entity/nuclear_furnace/nuclear_furnace_supercritical_glow.png");

    public NuclearFurnaceBlockRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(T furnace, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        poseStack.m_85836_();
        BlockState state = furnace.m_58900_();
        Direction dir = (Direction)state.m_61143_((Property)NuclearFurnaceBlock.FACING);
        poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
        poseStack.m_252880_(0.0f, -1.5f, 0.0f);
        MODEL.m_6973_(null, dir.m_122435_() - 180.0f, ((NuclearFurnaceBlockEntity)((Object)furnace)).getCriticality(), (float)((NuclearFurnaceBlockEntity)((Object)furnace)).age + partialTicks, ((NuclearFurnaceBlockEntity)((Object)furnace)).getWasteScale(), 0.0f);
        MODEL.m_7695_(poseStack, bufferIn.m_6299_(this.getRenderTypeFor(furnace, false)), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        MODEL.m_7695_(poseStack, bufferIn.m_6299_(this.getRenderTypeFor(furnace, true)), 240, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    private RenderType getRenderTypeFor(T furnace, boolean glow) {
        if (!((NuclearFurnaceBlockEntity)((Object)furnace)).isUndergoingFission() && ((NuclearFurnaceBlockEntity)((Object)furnace)).getCriticality() <= 0) {
            return glow ? ACRenderTypes.getEyesAlphaEnabled(OFF_TEXTURE_GLOW) : RenderType.m_110458_((ResourceLocation)OFF_TEXTURE);
        }
        if (((NuclearFurnaceBlockEntity)((Object)furnace)).getCriticality() == 1) {
            return glow ? ACRenderTypes.getEyesAlphaEnabled(SUBCRITICAL_TEXTURE_GLOW) : RenderType.m_110458_((ResourceLocation)SUBCRITICAL_TEXTURE);
        }
        if (((NuclearFurnaceBlockEntity)((Object)furnace)).getCriticality() == 2) {
            return glow ? ACRenderTypes.getEyesAlphaEnabled(CRITICAL_TEXTURE_GLOW) : RenderType.m_110458_((ResourceLocation)CRITICAL_TEXTURE);
        }
        if (((NuclearFurnaceBlockEntity)((Object)furnace)).getCriticality() >= 3) {
            return glow ? ACRenderTypes.getEyesAlphaEnabled(SUPERCRITICAL_TEXTURE_GLOW) : RenderType.m_110458_((ResourceLocation)SUPERCRITICAL_TEXTURE);
        }
        return glow ? ACRenderTypes.getEyesAlphaEnabled(ON_TEXTURE_GLOW) : RenderType.m_110458_((ResourceLocation)ON_TEXTURE);
    }
}

