/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.data.forge;

import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.venturecraft.gliders.VCGliders;
import net.venturecraft.gliders.data.GliderData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="vc_gliders")
public class GliderDataImpl
implements ICapabilitySerializable<CompoundTag> {
    public static Capability<GliderData> PLAYER_DATA = CapabilityManager.get((CapabilityToken)new CapabilityToken<GliderData>(){});
    public final GliderData capability;
    public final LazyOptional<GliderData> lazyOptional;

    public GliderDataImpl(Player player) {
        this.capability = new GliderData(player);
        this.lazyOptional = LazyOptional.of(() -> this.capability);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent e) {
        e.register(GliderData.class);
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> e) {
        Object object = e.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            e.addCapability(VCGliders.id("player_data"), (ICapabilityProvider)new GliderDataImpl(player));
        }
    }

    public static Optional<GliderData> get(LivingEntity player) {
        return player.getCapability(PLAYER_DATA).resolve();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
        return capability == PLAYER_DATA ? this.lazyOptional.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.capability.serializeNBT();
    }

    public void deserializeNBT(CompoundTag arg) {
        this.capability.deserializeNBT(arg);
    }
}

