/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.recipe.component;

import com.almostreliable.summoningrituals.platform.Platform;
import com.almostreliable.summoningrituals.util.SerializeUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.AABB;

public class RecipeSacrifices {
    private static final Vec3i DEFAULT_ZONE = new Vec3i(3, 2, 3);
    private final NonNullList<Sacrifice> sacrifices;
    private Vec3i region;

    public RecipeSacrifices() {
        this.sacrifices = NonNullList.m_122779_();
        this.region = DEFAULT_ZONE;
    }

    private RecipeSacrifices(NonNullList<Sacrifice> sacrifices, Vec3i region) {
        this.sacrifices = sacrifices;
        this.region = region;
    }

    public static RecipeSacrifices fromJson(JsonObject json) {
        JsonArray mobs = json.getAsJsonArray("mobs");
        NonNullList sacrifices = NonNullList.m_122779_();
        for (JsonElement entity : mobs) {
            sacrifices.add((Object)Sacrifice.fromJson(entity.getAsJsonObject()));
        }
        Vec3i zone = json.has("region") ? SerializeUtils.vec3FromJson(json.getAsJsonObject("region")) : DEFAULT_ZONE;
        return new RecipeSacrifices((NonNullList<Sacrifice>)sacrifices, zone);
    }

    public static RecipeSacrifices fromNetwork(FriendlyByteBuf buffer) {
        int length = buffer.m_130242_();
        NonNullList sacrifices = NonNullList.m_122779_();
        for (int i = 0; i < length; ++i) {
            sacrifices.add((Object)Sacrifice.fromNetwork(buffer));
        }
        Vec3i zone = SerializeUtils.vec3FromNetwork(buffer);
        return new RecipeSacrifices((NonNullList<Sacrifice>)sacrifices, zone);
    }

    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        JsonArray mobs = new JsonArray();
        for (Sacrifice sacrifice : this.sacrifices) {
            mobs.add(sacrifice.toJson());
        }
        json.add("mobs", (JsonElement)mobs);
        json.add("region", (JsonElement)SerializeUtils.vec3ToJson(this.region));
        return json;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.sacrifices.size());
        for (Sacrifice sacrifice : this.sacrifices) {
            sacrifice.toNetwork(buffer);
        }
        SerializeUtils.vec3ToNetwork(buffer, this.region);
    }

    public void add(EntityType<?> mob, int count) {
        this.sacrifices.add((Object)new Sacrifice(mob, count));
    }

    public AABB getRegion(BlockPos pos) {
        return new AABB(pos.m_121955_(this.region.m_142393_(-1)), pos.m_121955_(this.region));
    }

    public boolean test(Predicate<? super Sacrifice> predicate) {
        return this.sacrifices.stream().allMatch(predicate);
    }

    public int size() {
        return this.sacrifices.size();
    }

    public Sacrifice get(int index) {
        return (Sacrifice)this.sacrifices.get(index);
    }

    public String getDisplayRegion() {
        return String.format("%dx%dx%d", this.region.m_123341_(), this.region.m_123342_(), this.region.m_123343_());
    }

    public boolean isEmpty() {
        return this.sacrifices.isEmpty();
    }

    public void setRegion(Vec3i region) {
        this.region = region;
    }

    public record Sacrifice(EntityType<?> mob, int count) implements Predicate<Entity>
    {
        private static Sacrifice fromJson(JsonObject json) {
            EntityType<?> mob = Platform.mobFromJson(json);
            int count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
            return new Sacrifice(mob, count);
        }

        private static Sacrifice fromNetwork(FriendlyByteBuf buffer) {
            EntityType<?> mob = SerializeUtils.mobFromNetwork(buffer);
            int count = buffer.m_130242_();
            return new Sacrifice(mob, count);
        }

        @Override
        public boolean test(Entity entity) {
            return this.mob.equals((Object)entity.m_6095_());
        }

        private JsonElement toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("mob", Platform.getId(this.mob).toString());
            if (this.count > 1) {
                json.addProperty("count", (Number)this.count);
            }
            return json;
        }

        private void toNetwork(FriendlyByteBuf buffer) {
            buffer.m_130070_(Platform.getId(this.mob).toString());
            buffer.m_130130_(this.count);
        }
    }
}

