/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals;

import com.almostreliable.summoningrituals.altar.AltarBlock;
import com.almostreliable.summoningrituals.altar.AltarBlockEntity;
import com.almostreliable.summoningrituals.recipe.AltarRecipe;
import com.almostreliable.summoningrituals.recipe.AltarRecipeSerializer;
import com.almostreliable.summoningrituals.util.TextUtils;
import com.almostreliable.summoningrituals.util.Utils;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

public final class Registration {
    private static final DeferredRegister<Block> BLOCKS = Registration.createRegistry(ForgeRegistries.BLOCKS);
    private static final DeferredRegister<Item> ITEMS = Registration.createRegistry(ForgeRegistries.ITEMS);
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = Registration.createRegistry(ForgeRegistries.BLOCK_ENTITY_TYPES);
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"summoningrituals");
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = Registration.createRegistry(ForgeRegistries.RECIPE_SERIALIZERS);
    public static final RegistryObject<AltarBlock> ALTAR_BLOCK = BLOCKS.register("altar", () -> new AltarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60978_(2.5f).m_60918_(SoundType.f_56742_)));
    public static final RegistryObject<AltarBlock> INDESTRUCTIBLE_ALTAR_BLOCK = BLOCKS.register("indestructible_altar", () -> new AltarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60913_(-1.0f, 3600000.0f).m_60918_(SoundType.f_56742_)));
    public static final RegistryObject<Item> ALTAR_ITEM = ITEMS.register("altar", () -> new BlockItem((Block)ALTAR_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Item> INDESTRUCTIBLE_ALTAR_ITEM = ITEMS.register("indestructible_altar", () -> new BlockItem((Block)INDESTRUCTIBLE_ALTAR_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<BlockEntityType<AltarBlockEntity>> ALTAR_ENTITY = BLOCK_ENTITIES.register("altar", () -> BlockEntityType.Builder.m_155273_(AltarBlockEntity::new, (Block[])new Block[]{(Block)ALTAR_BLOCK.get(), (Block)INDESTRUCTIBLE_ALTAR_BLOCK.get()}).m_58966_(null));
    public static final RecipeEntry<AltarRecipe> ALTAR_RECIPE = RecipeEntry.register("altar", AltarRecipeSerializer::new);

    private Registration() {
    }

    static void init(IEventBus modEventBus) {
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        RECIPE_TYPES.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
    }

    private static <T> DeferredRegister<T> createRegistry(IForgeRegistry<T> registry) {
        return DeferredRegister.create(registry, (String)"summoningrituals");
    }

    public record RecipeEntry<T extends Recipe<?>>(RegistryObject<RecipeType<T>> type, RegistryObject<? extends RecipeSerializer<T>> serializer) {
        private static <T extends Recipe<?>> RecipeEntry<T> register(final String id, Supplier<? extends RecipeSerializer<T>> serializer) {
            RegistryObject type = RECIPE_TYPES.register(id, () -> new RecipeType<T>(){

                public String toString() {
                    return id;
                }
            });
            return new RecipeEntry<T>(type, RECIPE_SERIALIZERS.register(id, serializer));
        }
    }

    static final class Tab {
        private static final ResourceKey<CreativeModeTab> TAB_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)Utils.getRL("tab"));
        private static final CreativeModeTab TAB = CreativeModeTab.builder().m_257941_((Component)TextUtils.translate("label", "itemGroup", new ChatFormatting[0])).m_257737_(() -> new ItemStack((ItemLike)ALTAR_BLOCK.get())).m_257794_().m_257652_();

        private Tab() {
        }

        static void initContents(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == TAB_KEY) {
                event.accept(ALTAR_BLOCK);
                event.accept(INDESTRUCTIBLE_ALTAR_BLOCK);
            }
        }

        static void registerTab(RegisterEvent event) {
            event.register(Registries.f_279569_, TAB_KEY.m_135782_(), () -> TAB);
        }
    }
}

