/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.shaderpack;

import dev.djefrey.colorwheel.engine.ClrwlBlendModeOverride;
import dev.djefrey.colorwheel.shaderpack.ClrwlProgramGroup;
import dev.engine_room.flywheel.api.material.Transparency;
import java.util.Optional;
import net.irisshaders.iris.shaderpack.loading.ProgramId;
import org.jetbrains.annotations.Nullable;

public enum ClrwlProgramId {
    GBUFFERS(ClrwlProgramGroup.GBUFFERS, "clrwl_gbuffers", ProgramId.Terrain, null, false, null),
    GBUFFERS_ADDITIVE(ClrwlProgramGroup.GBUFFERS, "clrwl_gbuffers_additive", null, GBUFFERS, false, null),
    GBUFFERS_GLINT(ClrwlProgramGroup.GBUFFERS, "clrwl_gbuffers_glint", ProgramId.ArmorGlint, GBUFFERS, false, null),
    GBUFFERS_LIGHTNING(ClrwlProgramGroup.GBUFFERS, "clrwl_gbuffers_lightning", null, GBUFFERS, false, null),
    GBUFFERS_TRANSLUCENT(ClrwlProgramGroup.GBUFFERS, "clrwl_gbuffers_translucent", ProgramId.Water, GBUFFERS, true, null),
    GBUFFERS_DAMAGEDBLOCK(ClrwlProgramGroup.GBUFFERS, "clrwl_gbuffers_damagedblock", ProgramId.DamagedBlock, GBUFFERS, false, null),
    SHADOW(ClrwlProgramGroup.SHADOW, "clrwl_shadow", ProgramId.Shadow, null, false, ClrwlBlendModeOverride.OFF),
    SHADOW_ADDITIVE(ClrwlProgramGroup.SHADOW, "clrwl_shadow_additive", null, SHADOW, false, ClrwlBlendModeOverride.OFF),
    SHADOW_GLINT(ClrwlProgramGroup.SHADOW, "clrwl_shadow_glint", null, SHADOW, false, ClrwlBlendModeOverride.OFF),
    SHADOW_LIGHTNING(ClrwlProgramGroup.SHADOW, "clrwl_shadow_lightning", null, null, false, ClrwlBlendModeOverride.OFF),
    SHADOW_TRANSLUCENT(ClrwlProgramGroup.SHADOW, "clrwl_shadow_translucent", null, SHADOW, true, ClrwlBlendModeOverride.OFF);

    private final ClrwlProgramGroup group;
    private final String name;
    @Nullable
    private final ProgramId fallbackProgram;
    @Nullable
    private final ClrwlProgramId base;
    private final boolean afterTranslucent;
    @Nullable
    private final ClrwlBlendModeOverride defaultBlendOverride;

    private ClrwlProgramId(@Nullable ClrwlProgramGroup group, @Nullable String name, ProgramId fallbackProgram, @Nullable ClrwlProgramId base, boolean afterTranslucent, ClrwlBlendModeOverride defaultBlendOverride) {
        this.group = group;
        this.name = name;
        this.fallbackProgram = fallbackProgram;
        this.base = base;
        this.afterTranslucent = afterTranslucent;
        this.defaultBlendOverride = defaultBlendOverride;
    }

    public ClrwlProgramGroup group() {
        return this.group;
    }

    public String programName() {
        return this.name;
    }

    @Nullable
    public ProgramId fallbackProgram() {
        return this.fallbackProgram;
    }

    @Nullable
    public ClrwlProgramId base() {
        return this.base;
    }

    public boolean afterTranslucent() {
        return this.afterTranslucent;
    }

    public Optional<ClrwlBlendModeOverride> defaultBlendOverride() {
        return Optional.ofNullable(this.defaultBlendOverride);
    }

    public static ClrwlProgramId[] gbuffers() {
        return new ClrwlProgramId[]{GBUFFERS, GBUFFERS_ADDITIVE, GBUFFERS_GLINT, GBUFFERS_LIGHTNING, GBUFFERS_TRANSLUCENT, GBUFFERS_DAMAGEDBLOCK};
    }

    public static ClrwlProgramId[] shadow() {
        return new ClrwlProgramId[]{SHADOW, SHADOW_ADDITIVE, SHADOW_GLINT, SHADOW_LIGHTNING, SHADOW_TRANSLUCENT};
    }

    public static Optional<ClrwlProgramId> fromName(String name) {
        for (ClrwlProgramId program : ClrwlProgramId.values()) {
            if (!program.name.equals(name)) continue;
            return Optional.of(program);
        }
        return Optional.empty();
    }

    public static ClrwlProgramId fromTransparency(Transparency transparency, boolean isShadow) {
        if (!isShadow) {
            switch (transparency) {
                case OPAQUE: {
                    return GBUFFERS;
                }
                case ADDITIVE: {
                    return GBUFFERS_ADDITIVE;
                }
                case LIGHTNING: {
                    return GBUFFERS_LIGHTNING;
                }
                case GLINT: {
                    return GBUFFERS_GLINT;
                }
                case CRUMBLING: {
                    return GBUFFERS_DAMAGEDBLOCK;
                }
                case TRANSLUCENT: 
                case ORDER_INDEPENDENT: {
                    return GBUFFERS_TRANSLUCENT;
                }
            }
        } else {
            switch (transparency) {
                case OPAQUE: {
                    return SHADOW;
                }
                case ADDITIVE: {
                    return SHADOW_ADDITIVE;
                }
                case LIGHTNING: {
                    return SHADOW_LIGHTNING;
                }
                case GLINT: {
                    return SHADOW_GLINT;
                }
                case TRANSLUCENT: 
                case ORDER_INDEPENDENT: {
                    return SHADOW_TRANSLUCENT;
                }
                case CRUMBLING: {
                    return SHADOW;
                }
            }
        }
        throw new RuntimeException("Unknown transparency: " + transparency);
    }
}

