/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.engine.uniform;

import dev.djefrey.colorwheel.engine.uniform.UniformWriter;
import dev.engine_room.flywheel.api.backend.RenderContext;
import dev.engine_room.flywheel.backend.engine.uniform.UniformBuffer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class ClrwlLevelUniforms
extends UniformWriter {
    private static final int SIZE = 112;
    static final UniformBuffer BUFFER = new UniformBuffer(1, 112);
    public static final Vector3f LIGHT0_DIRECTION = new Vector3f();
    public static final Vector3f LIGHT1_DIRECTION = new Vector3f();

    private ClrwlLevelUniforms() {
    }

    public static void update(RenderContext context) {
        long ptr = BUFFER.ptr();
        ClientLevel level = context.level();
        float partialTick = context.partialTick();
        Vec3 skyColor = level.m_171660_(context.camera().m_90583_(), partialTick);
        Vec3 cloudColor = level.m_104808_(partialTick);
        ptr = ClrwlLevelUniforms.writeVec4(ptr, (float)skyColor.f_82479_, (float)skyColor.f_82480_, (float)skyColor.f_82481_, 1.0f);
        ptr = ClrwlLevelUniforms.writeVec4(ptr, (float)cloudColor.f_82479_, (float)cloudColor.f_82480_, (float)cloudColor.f_82481_, 1.0f);
        ptr = ClrwlLevelUniforms.writeVec3(ptr, (Vector3fc)LIGHT0_DIRECTION);
        ptr = ClrwlLevelUniforms.writeVec3(ptr, (Vector3fc)LIGHT1_DIRECTION);
        long dayTime = level.m_46468_();
        long levelDay = dayTime / 24000L;
        float timeOfDay = (float)(dayTime - levelDay * 24000L) / 24000.0f;
        ptr = ClrwlLevelUniforms.writeInt(ptr, (int)(levelDay % Integer.MAX_VALUE));
        ptr = ClrwlLevelUniforms.writeFloat(ptr, timeOfDay);
        ptr = ClrwlLevelUniforms.writeInt(ptr, level.m_6042_().f_223549_() ? 1 : 0);
        ptr = ClrwlLevelUniforms.writeFloat(ptr, level.m_46490_(partialTick));
        ptr = ClrwlLevelUniforms.writeFloat(ptr, level.m_46940_());
        ptr = ClrwlLevelUniforms.writeInt(ptr, level.m_46941_());
        ptr = ClrwlLevelUniforms.writeInt(ptr, level.m_46471_() ? 1 : 0);
        ptr = ClrwlLevelUniforms.writeFloat(ptr, level.m_46722_(partialTick));
        ptr = ClrwlLevelUniforms.writeInt(ptr, level.m_46470_() ? 1 : 0);
        ptr = ClrwlLevelUniforms.writeFloat(ptr, level.m_46661_(partialTick));
        ptr = ClrwlLevelUniforms.writeFloat(ptr, level.m_104805_(partialTick));
        ptr = ClrwlLevelUniforms.writeInt(ptr, level.m_104583_().m_108885_() ? 1 : 0);
        ResourceKey dimension = level.m_46472_();
        int dimensionId = Level.f_46428_.equals(dimension) ? 0 : (Level.f_46429_.equals(dimension) ? 1 : (Level.f_46430_.equals(dimension) ? 2 : -1));
        ptr = ClrwlLevelUniforms.writeInt(ptr, dimensionId);
        BUFFER.markDirty();
    }
}

