/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel;

import dev.djefrey.colorwheel.ClrwlBackend;
import dev.djefrey.colorwheel.ClrwlConfig;
import dev.djefrey.colorwheel.ClrwlSafeFlw;
import dev.djefrey.colorwheel.ClrwlSafeFlwNoop;
import dev.djefrey.colorwheel.ClrwlXplat;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Colorwheel {
    public static final String MOD_ID = "colorwheel";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"colorwheel");
    public static ClrwlConfig CONFIG = null;
    public static String FORMATTED_VERSION = ClrwlXplat.INSTANCE.getFormattedVersion();
    private static ClrwlSafeFlw SAFE_FLW_INSTANCE = null;

    public static void init(boolean hasFlywheel) {
        if (hasFlywheel) {
            ClrwlBackend.init();
        } else {
            LOGGER.warn("Flywheel is not installed, Colorwheel will be disabled");
        }
    }

    public static ClrwlSafeFlw getSafeFlw() {
        if (SAFE_FLW_INSTANCE == null) {
            try {
                SAFE_FLW_INSTANCE = ClrwlXplat.INSTANCE.doesHaveFlywheel() ? (ClrwlSafeFlw)Class.forName("dev.djefrey.colorwheel.ClrwlSafeFlwImpl").getConstructor(new Class[0]).newInstance(new Object[0]) : new ClrwlSafeFlwNoop();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Could not load ClrwlSafeFlwImpl", (Throwable)e);
                throw new RuntimeException("Error while loading Colorweel", e);
            }
        }
        return SAFE_FLW_INSTANCE;
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static void sendWarnMessage(MutableComponent component, boolean prefix) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        MutableComponent comp = prefix ? Component.m_237113_((String)"[Colorwheel] ") : Component.m_237119_();
        comp.m_7220_((Component)component);
        comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.YELLOW)));
        player.m_213846_((Component)comp);
    }

    public static void sendErrorMessage(Component component, boolean prefix) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        MutableComponent comp = prefix ? Component.m_237113_((String)"[Colorwheel] ") : Component.m_237119_();
        comp.m_7220_(component);
        comp.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)));
        player.m_213846_((Component)comp);
    }

    public static void sendEmptyMessage() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        player.m_213846_((Component)Component.m_237119_());
    }
}

