/*
 * Decompiled with CFR 0.152.
 */
package com.morearrows.specialarrowentities.slime;

import com.morearrows.lists.ArrowItems;
import com.morearrows.lists.Registry;
import com.morearrows.lists.backend.ArrowsAPI;
import com.morearrows.lists.backend.configurations.ArrowServerConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class GoldenSlimeArrowEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> TIMES_BOUNCED = SynchedEntityData.m_135353_(GoldenSlimeArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public GoldenSlimeArrowEntity(EntityType<? extends GoldenSlimeArrowEntity> entType, Level level) {
        super(entType, level);
    }

    public GoldenSlimeArrowEntity(Level level, LivingEntity liveEntity) {
        super((EntityType)Registry.golden_slime_arrow.get(), liveEntity, level);
    }

    public GoldenSlimeArrowEntity(Level level, double x, double y, double z) {
        super((EntityType)Registry.golden_slime_arrow.get(), x, y, z, level);
    }

    public void m_36740_(@NotNull SoundEvent p_36741_) {
        this.f_36700_ = SoundEvents.f_12384_;
    }

    @NotNull
    public SoundEvent m_36784_() {
        return SoundEvents.f_12391_;
    }

    public void m_5790_(@NotNull EntityHitResult entityRes) {
        ArrowsAPI.goldenOnHitEntity(entityRes, this);
        super.m_5790_(entityRes);
    }

    public boolean m_36798_() {
        int fallOffWallsConfiguredMax = (Integer)ArrowServerConfig.slimeArrowsBounceAmount.get();
        double fallOffWallsConfiguredMultiplier = (Double)ArrowServerConfig.slimeArrowsBounceMultiplier.get();
        if ((Integer)this.m_20088_().m_135370_(TIMES_BOUNCED) < fallOffWallsConfiguredMax && this.f_36703_) {
            this.m_20088_().m_135381_(TIMES_BOUNCED, (Object)((Integer)this.m_20088_().m_135370_(TIMES_BOUNCED) + 1));
            Vec3 forward = this.m_20156_();
            this.m_5997_(-1.0 * (forward.f_82479_ * -fallOffWallsConfiguredMultiplier), -1.0 * (forward.f_82480_ * -fallOffWallsConfiguredMultiplier), -1.0 * (forward.f_82481_ * fallOffWallsConfiguredMultiplier));
            this.m_146922_(this.m_146908_() * -1.0f);
            this.f_19859_ += this.m_146908_() * -1.0f;
            this.f_19791_ *= -1.0;
            return true;
        }
        return super.m_36798_();
    }

    @NotNull
    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ArrowItems.golden_slime_arrow);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TIMES_BOUNCED, (Object)0);
    }

    public void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("xtraarrows_bounces", ((Integer)this.f_19804_.m_135370_(TIMES_BOUNCED)).intValue());
    }

    public void m_7378_(@NotNull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.f_19804_.m_135381_(TIMES_BOUNCED, (Object)compoundTag.m_128451_("xtraarrows_bounces"));
    }
}

