/*
 * Decompiled with CFR 0.152.
 */
package com.morearrows.specialarrowentities.magnetic;

import com.morearrows.lists.ArrowItems;
import com.morearrows.lists.Registry;
import com.morearrows.lists.backend.ArrowsAPI;
import com.morearrows.lists.backend.statuseffects.EffectsRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class IronMagneticArrowEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Boolean> HAS_LANDED = SynchedEntityData.m_135353_(IronMagneticArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BEEN_USED = SynchedEntityData.m_135353_(IronMagneticArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public IronMagneticArrowEntity(EntityType<? extends IronMagneticArrowEntity> entType, Level level) {
        super(entType, level);
        this.m_36781_(this.m_36789_() + 2.0);
    }

    public IronMagneticArrowEntity(Level level, LivingEntity liveEntity) {
        super((EntityType)Registry.iron_magnetic_arrow.get(), liveEntity, level);
        this.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        this.m_36781_(this.m_36789_() + 2.0);
    }

    public IronMagneticArrowEntity(Level level, double x, double y, double z) {
        super((EntityType)Registry.iron_magnetic_arrow.get(), x, y, z, level);
        this.m_36781_(this.m_36789_() + 2.0);
    }

    @NotNull
    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ArrowItems.iron_magnetic_arrow);
    }

    protected void m_5790_(@NotNull EntityHitResult entityRes) {
        super.m_5790_(entityRes);
        ArrowsAPI.goldenOnHitEntity(entityRes, this);
    }

    protected void m_7761_(@NotNull LivingEntity livingEntity) {
        super.m_7761_(livingEntity);
        MobEffectInstance mobEffectInstance = new MobEffectInstance((MobEffect)EffectsRegistry.magnetizedReg.get(), 600);
        livingEntity.m_147207_(mobEffectInstance, this.m_150173_());
    }

    public void m_8119_() {
        ArrowsAPI.magneticTick(this, HAS_LANDED, BEEN_USED);
        super.m_8119_();
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        ArrowsAPI.magneticOnHitBlock(this, HAS_LANDED);
        super.m_8060_(blockHitResult);
    }

    @NotNull
    protected SoundEvent m_36784_() {
        return SoundEvents.f_12064_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_LANDED, (Object)false);
        this.f_19804_.m_135372_(BEEN_USED, (Object)false);
    }

    public void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("xtraarrows_haslanded", ((Boolean)this.f_19804_.m_135370_(HAS_LANDED)).booleanValue());
        compoundTag.m_128379_("xtraarrows_beenused", ((Boolean)this.f_19804_.m_135370_(BEEN_USED)).booleanValue());
    }

    public void m_7378_(@NotNull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.f_19804_.m_135381_(HAS_LANDED, (Object)compoundTag.m_128471_("xtraarrows_haslanded"));
        this.f_19804_.m_135381_(BEEN_USED, (Object)compoundTag.m_128471_("xtraarrows_beenused"));
    }
}

