/*
 * Decompiled with CFR 0.152.
 */
package com.morearrows.specialarrowentities.headless;

import com.morearrows.lists.ArrowItems;
import com.morearrows.lists.Registry;
import com.morearrows.lists.backend.ArrowsAPI;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class ExtinguishingArrowEntity
extends AbstractArrow {
    public ExtinguishingArrowEntity(EntityType<? extends ExtinguishingArrowEntity> entType, Level level) {
        super(entType, level);
        this.m_36781_(0.5);
    }

    public ExtinguishingArrowEntity(Level level, LivingEntity liveEntity) {
        super((EntityType)Registry.extinguishing_arrow.get(), liveEntity, level);
        this.m_36781_(0.5);
        if (liveEntity instanceof Player && ((Player)liveEntity).m_150110_().f_35937_) {
            this.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
    }

    public ExtinguishingArrowEntity(Level level, double x, double y, double z) {
        super((EntityType)Registry.extinguishing_arrow.get(), x, y, z, level);
        this.m_36781_(0.5);
    }

    protected void m_5790_(@NotNull EntityHitResult entityRes) {
        super.m_5790_(entityRes);
        this.m_5496_(SoundEvents.f_11983_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        this.applyExtinguishingEffectToSurrounding();
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        this.m_5496_(SoundEvents.f_11983_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        this.applyExtinguishingEffectToSurrounding();
        ArrowsAPI.transformIntoHeadlessArrow(this);
    }

    public void applyExtinguishingEffectToSurrounding() {
        if (!this.f_19853_.f_46443_) {
            AABB aABB = this.m_20191_().m_82377_(4.0, 2.0, 4.0);
            Iterator blockPosIterator = BlockPos.m_121921_((AABB)aABB).iterator();
            List entityList = this.f_19853_.m_45976_(Entity.class, aABB);
            for (Entity entity : entityList) {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    ArrowsAPI.hurtWaterSensitiveEntity(this, (Entity)livingEntity);
                }
                if (!entity.m_6060_()) continue;
                entity.m_20095_();
                this.m_5496_(SoundEvents.f_11937_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            }
            ArrowsAPI.spawnParticlesInCircle(this.f_19853_, this.m_20182_(), ParticleTypes.f_123804_, 4.0, 120.0);
            while (blockPosIterator.hasNext()) {
                int random;
                Player player;
                Entity entity;
                BlockPos blockPos = (BlockPos)blockPosIterator.next();
                BlockState blockState = this.f_19853_.m_8055_(blockPos);
                FluidState fluidState = this.f_19853_.m_6425_(blockPos);
                if (blockState.m_204336_(BlockTags.f_13076_)) {
                    this.f_19853_.m_7471_(blockPos, false);
                    this.m_5496_(SoundEvents.f_11937_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
                }
                if (AbstractCandleBlock.m_151933_((BlockState)blockState)) {
                    entity = this.m_19749_();
                    if (entity instanceof Player) {
                        player = (Player)entity;
                        AbstractCandleBlock.m_151899_((Player)player, (BlockState)blockState, (LevelAccessor)this.f_19853_, (BlockPos)blockPos);
                    } else {
                        AbstractCandleBlock.m_151899_(null, (BlockState)blockState, (LevelAccessor)this.f_19853_, (BlockPos)blockPos);
                    }
                    this.m_5496_(SoundEvents.f_11937_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
                }
                if (CampfireBlock.m_51319_((BlockState)blockState)) {
                    entity = this.m_19749_();
                    if (entity instanceof Player) {
                        player = (Player)entity;
                        this.f_19853_.m_5898_(player, 1009, blockPos, 0);
                    } else {
                        this.f_19853_.m_5898_(null, 1009, blockPos, 0);
                    }
                    CampfireBlock.m_152749_((Entity)this.m_19749_(), (LevelAccessor)this.f_19853_, (BlockPos)blockPos, (BlockState)blockState);
                    this.f_19853_.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)));
                    this.m_5496_(SoundEvents.f_11937_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
                }
                if (!ArrowsAPI.isValidForLiquidBlockReplacement(blockPos, this.f_19853_, blockState, fluidState, Blocks.f_50080_, Blocks.f_49991_) || (random = (int)(Math.random() * 4.0) + 1) != 1) continue;
                this.f_19853_.m_46597_(blockPos, Blocks.f_50080_.m_49966_());
                this.m_5496_(SoundEvents.f_11937_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            }
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ArrowItems.extinguishing_arrow);
    }
}

