/*
 * Decompiled with CFR 0.152.
 */
package com.morearrows.lists.backend;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class MobDropsGlobalLootModifiers
extends LootModifier {
    public static final Supplier<Codec<MobDropsGlobalLootModifiers>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> MobDropsGlobalLootModifiers.codecStart((RecordCodecBuilder.Instance)instance).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(g -> g.item)).and((App)Codec.INT.fieldOf("amount").forGetter(h -> h.amount)).apply((Applicative)instance, MobDropsGlobalLootModifiers::new)));
    private final Item item;
    private final int amount;
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"xtraarrows");
    public static final RegistryObject<Codec<? extends IGlobalLootModifier>> ADD_DROP = LOOT_MODIFIERS.register("add_drop", CODEC);

    protected MobDropsGlobalLootModifiers(LootItemCondition[] conditionsIn, Item item, int amount) {
        super(conditionsIn);
        this.item = item;
        this.amount = amount;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> objectArrayList, LootContext arg) {
        objectArrayList.add((Object)new ItemStack((ItemLike)this.item, this.amount));
        return objectArrayList;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    public static void registerModifiers() {
        LOOT_MODIFIERS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }
}

