/*
 * Decompiled with CFR 0.152.
 */
package com.morearrows.lists.backend;

import com.morearrows.lists.backend.configurations.ArrowCommonConfig;
import com.morearrows.lists.backend.configurations.ArrowServerConfig;
import com.morearrows.specialarrowentities.headless.HeadlessArrowEntity;
import com.morearrows.specialarrowentities.padded.PaddedArrowEntity;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.NotNull;

public class ArrowsAPI {
    public static int incendiaryArrowTimeOnFireConfiguration = 3;

    public static void torchArrowOnBlockHit(BlockHitResult hitRes, Level minecraftLevel, AbstractArrow abstractArrow) {
        if (!minecraftLevel.f_46443_) {
            BlockPos hitBlockPos = hitRes.m_82425_();
            BlockPlaceContext blockPlaceContext = new BlockPlaceContext(minecraftLevel, null, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42000_), hitRes);
            Entity entity = abstractArrow.m_19749_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                blockPlaceContext = new BlockPlaceContext(minecraftLevel, player, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42000_), hitRes);
            }
            if (blockPlaceContext.m_7059_()) {
                if (hitRes.m_82434_().m_122434_().equals((Object)Direction.Axis.Z) && ((BlockItem)Items.f_42000_).m_40610_(blockPlaceContext, (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)hitRes.m_82434_()))) {
                    minecraftLevel.m_46597_(hitBlockPos.m_121945_(hitRes.m_82434_()), (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)hitRes.m_82434_()));
                    abstractArrow.m_146870_();
                } else if (hitRes.m_82434_().m_122434_().equals((Object)Direction.Axis.X) && ((BlockItem)Items.f_42000_).m_40610_(blockPlaceContext, (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)hitRes.m_82434_()))) {
                    minecraftLevel.m_46597_(hitBlockPos.m_121945_(hitRes.m_82434_()), (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)hitRes.m_82434_()));
                    abstractArrow.m_146870_();
                } else if (hitRes.m_82434_().equals((Object)Direction.UP) && ((BlockItem)Items.f_42000_).m_40610_(blockPlaceContext, Blocks.f_50081_.m_49966_())) {
                    minecraftLevel.m_46597_(hitBlockPos.m_121945_(Direction.UP), Blocks.f_50081_.m_49966_());
                    abstractArrow.m_146870_();
                }
            }
        }
    }

    public static void lightningArrowOnHit(AbstractArrow abstractArrow, HitResult hitResult, LivingEntity attacker) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method onHitEntity = ObfuscationReflectionHelper.findMethod(AbstractArrow.class, (String)"m_5790_", (Class[])new Class[]{EntityHitResult.class});
        onHitEntity.setAccessible(true);
        if (((Boolean)ArrowServerConfig.enableLightningArrows.get()).booleanValue() && !abstractArrow.f_19853_.f_46443_) {
            EntityHitResult eResult;
            Vec3 location = hitResult.m_82450_();
            boolean visOnly = (Boolean)ArrowServerConfig.lightningArrowsVisualOnly.get();
            double damageConfig = (Double)ArrowServerConfig.lightningArrowsDamageAmount.get();
            float damage = (float)damageConfig;
            if (hitResult.m_6662_().equals((Object)HitResult.Type.ENTITY) && !(eResult = (EntityHitResult)hitResult).m_82443_().m_6673_(abstractArrow.m_269291_().m_269418_(abstractArrow, eResult.m_82443_()))) {
                onHitEntity.invoke((Object)abstractArrow, eResult);
            }
            LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, abstractArrow.f_19853_){
                final boolean shouldCauseFire = (Boolean)ArrowServerConfig.lightningArrowsCauseFire.get();

                @NotNull
                public SoundSource m_5720_() {
                    return SoundSource.HOSTILE;
                }

                public void m_20870_(int p_20871_) {
                    if (!this.shouldCauseFire) {
                        return;
                    }
                    super.m_20870_(p_20871_);
                }
            };
            lightningBolt.m_146884_(location);
            lightningBolt.m_20874_(visOnly);
            lightningBolt.setDamage(damage);
            if (attacker instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)attacker;
                lightningBolt.m_20879_(sPlayer);
            }
            abstractArrow.f_19853_.m_7967_((Entity)lightningBolt);
            abstractArrow.m_146870_();
        }
    }

    public static void soulTorchArrowOnBlockHit(BlockHitResult hitRes, Level minecraftLevel, AbstractArrow abstractArrow) {
        if (!minecraftLevel.f_46443_) {
            BlockPos hitBlockPos = hitRes.m_82425_();
            BlockPlaceContext blockPlaceContext = new BlockPlaceContext(minecraftLevel, null, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42053_), hitRes);
            Entity entity = abstractArrow.m_19749_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                blockPlaceContext = new BlockPlaceContext(minecraftLevel, player, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42053_), hitRes);
            }
            if (blockPlaceContext.m_7059_()) {
                if (hitRes.m_82434_().m_122434_().equals((Object)Direction.Axis.Z) && ((BlockItem)Items.f_42053_).m_40610_(blockPlaceContext, (BlockState)Blocks.f_50140_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)hitRes.m_82434_()))) {
                    minecraftLevel.m_46597_(hitBlockPos.m_121945_(hitRes.m_82434_()), (BlockState)Blocks.f_50140_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)hitRes.m_82434_()));
                    abstractArrow.m_146870_();
                } else if (hitRes.m_82434_().m_122434_().equals((Object)Direction.Axis.X) && ((BlockItem)Items.f_42053_).m_40610_(blockPlaceContext, (BlockState)Blocks.f_50140_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)hitRes.m_82434_()))) {
                    minecraftLevel.m_46597_(hitBlockPos.m_121945_(hitRes.m_82434_()), (BlockState)Blocks.f_50140_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)hitRes.m_82434_()));
                    abstractArrow.m_146870_();
                } else if (hitRes.m_82434_().equals((Object)Direction.UP) && ((BlockItem)Items.f_42053_).m_40610_(blockPlaceContext, Blocks.f_50139_.m_49966_())) {
                    minecraftLevel.m_46597_(hitBlockPos.m_121945_(Direction.UP), Blocks.f_50139_.m_49966_());
                    abstractArrow.m_146870_();
                }
            }
        }
    }

    public static void redstoneTorchArrowOnBlockHit(BlockHitResult hitRes, Level minecraftLevel, AbstractArrow abstractArrow) {
        if (!minecraftLevel.f_46443_) {
            BlockPos hitBlockPos = hitRes.m_82425_();
            BlockPlaceContext blockPlaceContext = new BlockPlaceContext(minecraftLevel, null, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_41978_), hitRes);
            Entity entity = abstractArrow.m_19749_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                blockPlaceContext = new BlockPlaceContext(minecraftLevel, player, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_41978_), hitRes);
            }
            if (blockPlaceContext.m_7059_()) {
                if (hitRes.m_82434_().m_122434_().equals((Object)Direction.Axis.Z) && ((BlockItem)Items.f_41978_).m_40610_(blockPlaceContext, (BlockState)Blocks.f_50123_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)hitRes.m_82434_()))) {
                    minecraftLevel.m_46597_(hitBlockPos.m_121945_(hitRes.m_82434_()), (BlockState)Blocks.f_50123_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)hitRes.m_82434_()));
                    abstractArrow.m_146870_();
                } else if (hitRes.m_82434_().m_122434_().equals((Object)Direction.Axis.X) && ((BlockItem)Items.f_41978_).m_40610_(blockPlaceContext, (BlockState)Blocks.f_50123_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)hitRes.m_82434_()))) {
                    minecraftLevel.m_46597_(hitBlockPos.m_121945_(hitRes.m_82434_()), (BlockState)Blocks.f_50123_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)hitRes.m_82434_()));
                    abstractArrow.m_146870_();
                } else if (hitRes.m_82434_().equals((Object)Direction.UP) && ((BlockItem)Items.f_41978_).m_40610_(blockPlaceContext, Blocks.f_50174_.m_49966_())) {
                    minecraftLevel.m_46597_(hitBlockPos.m_121945_(Direction.UP), Blocks.f_50174_.m_49966_());
                    abstractArrow.m_146870_();
                }
            }
        }
    }

    public static void lanternArrowOnBlockHit(BlockHitResult hitRes, Level minecraftLevel, AbstractArrow abstractArrow) {
        if (!minecraftLevel.f_46443_) {
            BlockPos hitBlockPos = hitRes.m_82425_();
            BlockPlaceContext blockPlaceContext = new BlockPlaceContext(minecraftLevel, null, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42778_), hitRes);
            Entity entity = abstractArrow.m_19749_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                blockPlaceContext = new BlockPlaceContext(minecraftLevel, player, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42778_), hitRes);
            }
            if (blockPlaceContext.m_7059_()) {
                if (hitRes.m_82434_().equals((Object)Direction.UP) && ((BlockItem)Items.f_42778_).m_40610_(blockPlaceContext, Blocks.f_50681_.m_49966_())) {
                    if (minecraftLevel.m_6425_(hitBlockPos.m_121945_(Direction.UP)).equals(Fluids.f_76193_.m_76145_().m_61124_((Property)BlockStateProperties.f_61434_, (Comparable)Boolean.valueOf(false)))) {
                        minecraftLevel.m_46597_(hitBlockPos.m_121945_(Direction.UP), (BlockState)Blocks.f_50681_.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)));
                    } else {
                        minecraftLevel.m_46597_(hitBlockPos.m_121945_(Direction.UP), Blocks.f_50681_.m_49966_());
                    }
                    abstractArrow.m_146870_();
                } else if (hitRes.m_82434_().equals((Object)Direction.DOWN) && ((BlockItem)Items.f_42778_).m_40610_(blockPlaceContext, (BlockState)Blocks.f_50681_.m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.valueOf(true)))) {
                    if (minecraftLevel.m_6425_(hitBlockPos.m_121945_(Direction.DOWN)).equals(Fluids.f_76193_.m_76145_().m_61124_((Property)BlockStateProperties.f_61434_, (Comparable)Boolean.valueOf(false)))) {
                        minecraftLevel.m_46597_(hitBlockPos.m_121945_(Direction.DOWN), (BlockState)((BlockState)Blocks.f_50681_.m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)));
                    } else {
                        minecraftLevel.m_46597_(hitBlockPos.m_121945_(Direction.DOWN), (BlockState)Blocks.f_50681_.m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.valueOf(true)));
                    }
                    abstractArrow.m_146870_();
                }
            }
        }
    }

    public static void soulLanternArrowOnBlockHit(BlockHitResult hitRes, Level minecraftLevel, AbstractArrow abstractArrow) {
        if (!minecraftLevel.f_46443_) {
            BlockPos hitBlockPos = hitRes.m_82425_();
            BlockPlaceContext blockPlaceContext = new BlockPlaceContext(minecraftLevel, null, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42779_), hitRes);
            Entity entity = abstractArrow.m_19749_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                blockPlaceContext = new BlockPlaceContext(minecraftLevel, player, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42779_), hitRes);
            }
            if (blockPlaceContext.m_7059_()) {
                if (hitRes.m_82434_().equals((Object)Direction.UP) && ((BlockItem)Items.f_42779_).m_40610_(blockPlaceContext, Blocks.f_50682_.m_49966_())) {
                    if (minecraftLevel.m_6425_(hitBlockPos.m_121945_(Direction.UP)).equals(Fluids.f_76193_.m_76145_().m_61124_((Property)BlockStateProperties.f_61434_, (Comparable)Boolean.valueOf(false)))) {
                        minecraftLevel.m_46597_(hitBlockPos.m_121945_(Direction.UP), (BlockState)Blocks.f_50682_.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)));
                    } else {
                        minecraftLevel.m_46597_(hitBlockPos.m_121945_(Direction.UP), Blocks.f_50682_.m_49966_());
                    }
                    abstractArrow.m_146870_();
                } else if (hitRes.m_82434_().equals((Object)Direction.DOWN) && ((BlockItem)Items.f_42779_).m_40610_(blockPlaceContext, (BlockState)Blocks.f_50682_.m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.valueOf(true)))) {
                    if (minecraftLevel.m_6425_(hitBlockPos.m_121945_(Direction.DOWN)).equals(Fluids.f_76193_.m_76145_().m_61124_((Property)BlockStateProperties.f_61434_, (Comparable)Boolean.valueOf(false)))) {
                        minecraftLevel.m_46597_(hitBlockPos.m_121945_(Direction.DOWN), (BlockState)((BlockState)Blocks.f_50682_.m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)));
                    } else {
                        minecraftLevel.m_46597_(hitBlockPos.m_121945_(Direction.DOWN), (BlockState)Blocks.f_50682_.m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.valueOf(true)));
                    }
                    abstractArrow.m_146870_();
                }
            }
        }
    }

    public static void setTorchArrowEntityFire(Entity entity) {
        if (!entity.m_5825_() && entity.m_20094_() < 40) {
            entity.m_20254_(1);
        }
    }

    public static void enderOnHit(AbstractArrow abstractArrow, HitResult hitResult) {
        if (hitResult.m_6662_() == HitResult.Type.ENTITY || hitResult.m_6662_() == HitResult.Type.BLOCK) {
            for (int i = 0; i < 32; ++i) {
                abstractArrow.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, abstractArrow.m_20185_(), abstractArrow.m_20186_() + abstractArrow.f_19796_.m_188500_() * 2.0, abstractArrow.m_20189_(), abstractArrow.f_19796_.m_188583_(), 0.0, abstractArrow.f_19796_.m_188583_());
            }
            if (!abstractArrow.f_19853_.f_46443_ && !abstractArrow.m_213877_()) {
                Entity entity = abstractArrow.m_19749_();
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    if (serverPlayer.f_8906_.m_6198_() && serverPlayer.f_19853_ == abstractArrow.f_19853_ && !serverPlayer.m_5803_()) {
                        Endermite endermite;
                        if (abstractArrow.f_19796_.m_188501_() < 0.05f && abstractArrow.f_19853_.m_46469_().m_46207_(GameRules.f_46134_) && (endermite = (Endermite)EntityType.f_20567_.m_20615_(abstractArrow.f_19853_)) != null) {
                            endermite.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_146908_(), entity.m_146909_());
                            abstractArrow.f_19853_.m_7967_((Entity)endermite);
                        }
                        if (entity.m_20159_()) {
                            serverPlayer.m_142098_(abstractArrow.m_20185_(), abstractArrow.m_20186_(), abstractArrow.m_20189_());
                        } else {
                            entity.m_6021_(abstractArrow.m_20185_(), abstractArrow.m_20186_(), abstractArrow.m_20189_());
                        }
                        entity.m_183634_();
                        entity.m_6469_(abstractArrow.m_269291_().m_268989_(), 2.0f);
                    }
                } else if (entity != null) {
                    entity.m_6021_(abstractArrow.m_20185_(), abstractArrow.m_20186_(), abstractArrow.m_20189_());
                    entity.m_183634_();
                }
                abstractArrow.m_146870_();
            }
        }
    }

    public static void explosiveArrowOnHit(AbstractArrow abstractArrow, HitResult hitResult, LivingEntity attacker) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method onHitEntity = ObfuscationReflectionHelper.findMethod(AbstractArrow.class, (String)"m_5790_", (Class[])new Class[]{EntityHitResult.class});
        onHitEntity.setAccessible(true);
        if (((Boolean)ArrowServerConfig.enableExplosiveArrows.get()).booleanValue()) {
            EntityHitResult eResult;
            double configRadius = (Double)ArrowServerConfig.explosiveArrowsRadius.get();
            float radius = (float)configRadius;
            boolean hasFire = false;
            Vec3 location = hitResult.m_82450_();
            if (abstractArrow.m_6060_()) {
                hasFire = true;
            }
            if (!abstractArrow.m_6060_()) {
                hasFire = false;
            }
            if (hitResult.m_6662_().equals((Object)HitResult.Type.ENTITY) && !(eResult = (EntityHitResult)hitResult).m_82443_().m_6673_(abstractArrow.m_269291_().m_269418_(abstractArrow, eResult.m_82443_()))) {
                onHitEntity.invoke((Object)abstractArrow, eResult);
            }
            ExplosionDamageCalculator explosionDamageCalculator = new ExplosionDamageCalculator(){

                public boolean m_6714_(@NotNull Explosion p_46094_, @NotNull BlockGetter p_46095_, @NotNull BlockPos p_46096_, @NotNull BlockState p_46097_, float p_46098_) {
                    return (Boolean)ArrowServerConfig.explosiveArrowsDamageBlocks.get();
                }
            };
            Level level = abstractArrow.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel sLevel = (ServerLevel)level;
                sLevel.m_254877_(null, abstractArrow.m_269291_().m_269036_((Entity)attacker, null), explosionDamageCalculator, location.f_82479_, location.f_82480_, location.f_82481_, radius, hasFire, Level.ExplosionInteraction.BLOCK);
            }
            abstractArrow.m_146870_();
        }
    }

    public static void vexTick(AbstractArrow abstractArrow, EntityDataAccessor<Integer> IN_AND_OUT, EntityDataAccessor<Boolean> HAS_BEEN_IN) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Vec3 vec32;
        VoxelShape voxelShape;
        BlockPos blockPos;
        BlockState blockState;
        Method onHit = ObfuscationReflectionHelper.findMethod(Projectile.class, (String)"m_6532_", (Class[])new Class[]{HitResult.class});
        onHit.setAccessible(true);
        Method findHitEntity = ObfuscationReflectionHelper.findMethod(AbstractArrow.class, (String)"m_6351_", (Class[])new Class[]{Vec3.class, Vec3.class});
        findHitEntity.setAccessible(true);
        Method getWaterInertia = ObfuscationReflectionHelper.findMethod(AbstractArrow.class, (String)"m_6882_", (Class[])new Class[0]);
        getWaterInertia.setAccessible(true);
        if (!abstractArrow.f_150164_) {
            abstractArrow.m_146852_(GameEvent.f_157778_, abstractArrow.m_19749_());
            abstractArrow.f_150164_ = true;
        }
        if (!abstractArrow.f_37246_) {
            abstractArrow.f_37246_ = abstractArrow.m_37276_();
        }
        abstractArrow.f_19853_.m_46473_().m_6180_("entityBaseTick");
        abstractArrow.f_185934_ = null;
        if (abstractArrow.m_20159_() && abstractArrow.m_20202_() != null && abstractArrow.m_20202_().m_213877_()) {
            abstractArrow.m_8127_();
        }
        if (abstractArrow.f_19851_ > 0) {
            --abstractArrow.f_19851_;
        }
        abstractArrow.f_19867_ = abstractArrow.f_19787_;
        abstractArrow.f_19860_ = abstractArrow.m_146909_();
        abstractArrow.f_19859_ = abstractArrow.m_146908_();
        abstractArrow.m_20157_();
        if (abstractArrow.m_5843_()) {
            abstractArrow.m_20076_();
        }
        abstractArrow.f_146809_ = abstractArrow.f_146808_;
        abstractArrow.f_146808_ = false;
        abstractArrow.m_20073_();
        abstractArrow.m_20323_();
        abstractArrow.m_5844_();
        if (abstractArrow.f_19853_.f_46443_) {
            abstractArrow.m_20095_();
        } else if (abstractArrow.m_20094_() > 0) {
            if (abstractArrow.m_5825_()) {
                abstractArrow.m_7311_(abstractArrow.m_20094_() - 4);
                if (abstractArrow.m_20094_() < 0) {
                    abstractArrow.m_20095_();
                }
            } else {
                if (abstractArrow.m_20094_() % 20 == 0 && !abstractArrow.m_20077_()) {
                    abstractArrow.m_6469_(abstractArrow.m_269291_().m_269549_(), 1.0f);
                }
                abstractArrow.m_7311_(abstractArrow.m_20094_() - 1);
            }
            if (abstractArrow.m_146888_() > 0) {
                abstractArrow.m_146917_(0);
                abstractArrow.f_19853_.m_5898_(null, 1009, abstractArrow.f_19826_, 1);
            }
        }
        if (abstractArrow.m_20077_()) {
            abstractArrow.m_20093_();
            abstractArrow.f_19789_ *= abstractArrow.getFluidFallDistanceModifier((FluidType)ForgeMod.LAVA_TYPE.get());
        }
        abstractArrow.m_146871_();
        if (!abstractArrow.f_19853_.f_46443_) {
            abstractArrow.m_146868_(abstractArrow.m_20094_() > 0);
        }
        abstractArrow.f_19803_ = false;
        abstractArrow.f_19853_.m_46473_().m_7238_();
        boolean bl = abstractArrow.m_36797_();
        Vec3 vec3 = abstractArrow.m_20184_();
        if (abstractArrow.f_19860_ == 0.0f && abstractArrow.f_19859_ == 0.0f) {
            double d = vec3.m_165924_();
            abstractArrow.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
            abstractArrow.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d) * 57.2957763671875));
            abstractArrow.f_19859_ = abstractArrow.m_146908_();
            abstractArrow.f_19860_ = abstractArrow.m_146909_();
        }
        if ((blockState = abstractArrow.f_19853_.m_8055_(blockPos = abstractArrow.m_20183_())).m_60795_() && ((Boolean)abstractArrow.m_20088_().m_135370_(HAS_BEEN_IN)).booleanValue()) {
            abstractArrow.m_20088_().m_135381_(HAS_BEEN_IN, (Object)false);
            abstractArrow.m_20088_().m_135381_(IN_AND_OUT, (Object)((Integer)abstractArrow.m_20088_().m_135370_(IN_AND_OUT) + 1));
        }
        if (!(blockState.m_247087_() || blockState.m_60812_((BlockGetter)abstractArrow.f_19853_, blockPos).m_83281_() || blockState.m_60795_() || ((Boolean)abstractArrow.m_20088_().m_135370_(HAS_BEEN_IN)).booleanValue())) {
            abstractArrow.m_20088_().m_135381_(HAS_BEEN_IN, (Object)true);
        }
        if (!(blockState.m_60795_() || bl || (voxelShape = blockState.m_60812_((BlockGetter)abstractArrow.f_19853_, blockPos)).m_83281_())) {
            AABB aABB;
            vec32 = abstractArrow.m_20182_();
            Iterator iterator = voxelShape.m_83299_().iterator();
            while (iterator.hasNext() && !(aABB = (AABB)iterator.next()).m_82338_(blockPos).m_82390_(vec32)) {
            }
        }
        if (abstractArrow.f_36706_ > 0) {
            --abstractArrow.f_36706_;
        }
        if (abstractArrow.m_20070_() || blockState.m_60713_(Blocks.f_152499_)) {
            abstractArrow.m_20095_();
        }
        if (abstractArrow.f_36703_ && !bl && (Integer)abstractArrow.m_20088_().m_135370_(IN_AND_OUT) >= (Integer)ArrowServerConfig.vexingPhaseAmount.get()) {
            if (abstractArrow.f_36696_ != blockState && abstractArrow.m_36798_()) {
                abstractArrow.m_36799_();
            } else if (!abstractArrow.f_19853_.f_46443_) {
                abstractArrow.m_6901_();
            }
            ++abstractArrow.f_36704_;
        } else {
            abstractArrow.f_36704_ = 0;
            Vec3 vec33 = abstractArrow.m_20182_();
            BlockHitResult hitResult = abstractArrow.f_19853_.m_45547_(new ClipContext(vec33, vec32 = vec33.m_82549_(vec3), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)abstractArrow));
            if (hitResult.m_6662_() != HitResult.Type.MISS) {
                vec32 = hitResult.m_82450_();
            }
            while (!abstractArrow.m_213877_()) {
                EntityHitResult entityHitResult = (EntityHitResult)findHitEntity.invoke((Object)abstractArrow, vec33, vec32);
                if (entityHitResult != null) {
                    hitResult = entityHitResult;
                }
                if (hitResult instanceof EntityHitResult) {
                    Entity entity = ((EntityHitResult)hitResult).m_82443_();
                    Entity entity2 = abstractArrow.m_19749_();
                    if (entity instanceof Player && entity2 instanceof Player && !((Player)entity2).m_7099_((Player)entity)) {
                        hitResult = null;
                        entityHitResult = null;
                    }
                }
                if (hitResult != null && !bl && ((Integer)abstractArrow.m_20088_().m_135370_(IN_AND_OUT) >= (Integer)ArrowServerConfig.vexingPhaseAmount.get() || hitResult.m_6662_().equals((Object)HitResult.Type.ENTITY))) {
                    onHit.invoke((Object)abstractArrow, hitResult);
                    abstractArrow.f_19812_ = true;
                }
                if (entityHitResult == null || abstractArrow.m_36796_() <= 0) break;
                hitResult = null;
            }
            vec3 = abstractArrow.m_20184_();
            double e = vec3.f_82479_;
            double f = vec3.f_82480_;
            double g = vec3.f_82481_;
            if (abstractArrow.m_36792_()) {
                for (int i = 0; i < 4; ++i) {
                    abstractArrow.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, abstractArrow.m_20185_() + e * (double)i / 4.0, abstractArrow.m_20186_() + f * (double)i / 4.0, abstractArrow.m_20189_() + g * (double)i / 4.0, -e, -f + 0.2, -g);
                }
            }
            double h = abstractArrow.m_20185_() + e;
            double j = abstractArrow.m_20186_() + f;
            double k = abstractArrow.m_20189_() + g;
            double l = vec3.m_165924_();
            if (bl) {
                abstractArrow.m_146922_((float)(Mth.m_14136_((double)(-e), (double)(-g)) * 57.2957763671875));
            } else {
                abstractArrow.m_146922_((float)(Mth.m_14136_((double)e, (double)g) * 57.2957763671875));
            }
            abstractArrow.m_146926_((float)(Mth.m_14136_((double)f, (double)l) * 57.2957763671875));
            abstractArrow.m_146926_(Projectile.m_37273_((float)abstractArrow.f_19860_, (float)abstractArrow.m_146909_()));
            abstractArrow.m_146922_(Projectile.m_37273_((float)abstractArrow.f_19859_, (float)abstractArrow.m_146908_()));
            float m = 0.99f;
            if (abstractArrow.m_20069_()) {
                for (int o = 0; o < 4; ++o) {
                    abstractArrow.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, h - e * 0.25, j - f * 0.25, k - g * 0.25, e, f, g);
                }
                m = ((Float)getWaterInertia.invoke((Object)abstractArrow, new Object[0])).floatValue();
            }
            abstractArrow.m_20256_(vec3.m_82490_((double)m));
            if (!abstractArrow.m_20068_() && !bl) {
                Vec3 vec34 = abstractArrow.m_20184_();
                abstractArrow.m_20334_(vec34.f_82479_, vec34.f_82480_ - (double)0.05f, vec34.f_82481_);
            }
            abstractArrow.m_6034_(h, j, k);
        }
    }

    public static void diamondUpOnHitEntity(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack mainHandStack = player.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack offHandStack = player.m_21120_(InteractionHand.OFF_HAND);
            if ((mainHandStack.m_41720_() instanceof ShieldItem || offHandStack.m_41720_() instanceof ShieldItem) && player.m_6117_() && player.m_21120_(player.m_7655_()).m_41720_() instanceof ShieldItem) {
                player.m_36384_(true);
            }
        }
    }

    public static void hurtWaterSensitiveEntity(AbstractArrow abstractArrow, Entity entity) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6126_()) {
            livingEntity.m_6469_(abstractArrow.m_269291_().m_269104_((Entity)livingEntity, abstractArrow.m_19749_()), 5.0f);
        }
    }

    public static void burnNonFireImmuneEntity(Entity entity) {
        if (!entity.m_5825_() && entity.m_20094_() < incendiaryArrowTimeOnFireConfiguration * 20) {
            entity.m_20254_(incendiaryArrowTimeOnFireConfiguration);
        }
    }

    public static void transformIntoHeadlessArrow(AbstractArrow abstractArrow) {
        if (!abstractArrow.f_19853_.f_46443_) {
            HeadlessArrowEntity headlessArrowEntity = new HeadlessArrowEntity(abstractArrow.f_19853_, abstractArrow.m_20185_(), abstractArrow.m_20186_(), abstractArrow.m_20189_());
            headlessArrowEntity.f_36705_ = AbstractArrow.Pickup.ALLOWED;
            Entity entity = abstractArrow.m_19749_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                headlessArrowEntity = new HeadlessArrowEntity(abstractArrow.f_19853_, livingEntity);
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (player.m_150110_().f_35937_) {
                        headlessArrowEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                }
            }
            headlessArrowEntity.m_146884_(abstractArrow.m_20182_());
            headlessArrowEntity.m_146922_(abstractArrow.m_146908_());
            headlessArrowEntity.m_146926_(abstractArrow.m_146909_());
            headlessArrowEntity.m_20256_(abstractArrow.m_20184_());
            abstractArrow.m_5496_(SoundEvents.f_144074_, 1.0f, 1.0f);
            abstractArrow.f_19853_.m_7967_((Entity)headlessArrowEntity);
            headlessArrowEntity.m_8119_();
            abstractArrow.m_146870_();
        }
    }

    public static void magneticTick(AbstractArrow abstractArrow, EntityDataAccessor<Boolean> HAS_LANDED, EntityDataAccessor<Boolean> BEEN_USED) {
        if (((Boolean)abstractArrow.m_20088_().m_135370_(HAS_LANDED)).booleanValue() && abstractArrow.f_19797_ < 100 && !((Boolean)abstractArrow.m_20088_().m_135370_(BEEN_USED)).booleanValue()) {
            AABB aABB = abstractArrow.m_20191_().m_82377_(5.0, 5.0, 5.0);
            List entityList = abstractArrow.f_19853_.m_45976_(Entity.class, aABB);
            ArrowsAPI.spawnParticlesInCircle(abstractArrow.f_19853_, abstractArrow.m_20182_(), ParticleTypes.f_175827_, 5.0, 90.0);
            for (Entity entity : entityList) {
                Vec3 movementVector;
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (abstractArrow.m_19749_() != null && !livingEntity.m_7306_(abstractArrow.m_19749_())) {
                        movementVector = abstractArrow.m_20182_().m_82546_(livingEntity.m_20182_());
                        livingEntity.m_20256_(livingEntity.m_20184_().m_82490_(0.95).m_82549_(movementVector.m_82541_().m_82490_(0.25)));
                    }
                }
                if (!(entity instanceof ItemEntity)) continue;
                ItemEntity itemEntity = (ItemEntity)entity;
                movementVector = abstractArrow.m_20182_().m_82546_(itemEntity.m_20182_());
                itemEntity.m_20256_(itemEntity.m_20184_().m_82490_(0.95).m_82549_(movementVector.m_82541_().m_82490_(0.25)));
            }
        } else if (abstractArrow.f_19797_ >= 100 && !((Boolean)abstractArrow.m_20088_().m_135370_(BEEN_USED)).booleanValue()) {
            abstractArrow.m_20088_().m_135381_(BEEN_USED, (Object)true);
            abstractArrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        }
    }

    public static void spawnParticlesInCircle(Level level, Vec3 centerPosition, SimpleParticleType particleType, double radius, double spacingPower) {
        if (((Boolean)ArrowCommonConfig.enableRangeCircle.get()).booleanValue() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double spacing = Math.PI * 2 / spacingPower;
            int i = 0;
            while ((double)i < spacingPower) {
                double angle = (double)i * spacing;
                serverLevel.m_8767_((ParticleOptions)particleType, centerPosition.f_82479_ + radius * Math.cos(angle), centerPosition.f_82480_, centerPosition.f_82481_ + radius * Math.sin(angle), 0, 0.0, 0.0, 0.0, 0.0);
                ++i;
            }
        }
    }

    public static void magneticOnHitBlock(AbstractArrow abstractArrow, EntityDataAccessor<Boolean> HAS_LANDED) {
        if (!((Boolean)abstractArrow.m_20088_().m_135370_(HAS_LANDED)).booleanValue()) {
            abstractArrow.m_20088_().m_135381_(HAS_LANDED, (Object)true);
        }
    }

    public static void goldenOnHitEntity(EntityHitResult entityHitResult, AbstractArrow abstractArrow) {
        Entity entity = entityHitResult.m_82443_();
        double baseDamageAdder = -1.0;
        if (entity.f_19853_.m_46472_().equals((Object)Level.f_46429_)) {
            baseDamageAdder = 3.0;
        }
        abstractArrow.m_36781_(2.0 + baseDamageAdder);
    }

    public static void freezingOnHit(HitResult hitResult, AbstractArrow abstractArrow) {
        if (!abstractArrow.f_19853_.f_46443_) {
            Block hitBlock = null;
            boolean isHitAir = false;
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                BlockState hitState = abstractArrow.f_19853_.m_8055_(blockHitResult.m_82425_());
                hitBlock = hitState.m_60734_();
                isHitAir = hitState.m_60795_();
            }
            if (!(hitBlock instanceof LiquidBlock) && !isHitAir) {
                AABB aABB = abstractArrow.m_20191_().m_82377_(2.0, 3.0, 2.0);
                Iterator blockPosIterator = BlockPos.m_121921_((AABB)aABB).iterator();
                List livingEntityList = abstractArrow.f_19853_.m_45976_(LivingEntity.class, aABB);
                for (LivingEntity livingEntity : livingEntityList) {
                    if (!livingEntity.m_142079_()) continue;
                    livingEntity.m_146917_(550);
                }
                while (blockPosIterator.hasNext()) {
                    BlockPos blockPos = (BlockPos)blockPosIterator.next();
                    BlockHitResult blockHitResult = new BlockHitResult(Vec3.m_82512_((Vec3i)blockPos), Direction.DOWN, blockPos, false);
                    BlockPlaceContext blockPlaceContext = new BlockPlaceContext(abstractArrow.f_19853_, null, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_41979_), blockHitResult);
                    BlockState blockState = abstractArrow.f_19853_.m_8055_(blockPos);
                    FluidState fluidState = abstractArrow.f_19853_.m_6425_(blockPos);
                    Entity entity = abstractArrow.m_19749_();
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        blockPlaceContext = new BlockPlaceContext(abstractArrow.f_19853_, player, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_41979_), blockHitResult);
                    }
                    BlockState snowBlockState = (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)BlockStateProperties.f_61417_, (Comparable)Integer.valueOf((int)(Math.random() * 3.0) + 1));
                    if (!(abstractArrow.f_19853_.m_8055_(blockPos).m_60734_() instanceof LiquidBlock) && blockPlaceContext.m_7059_() && ((BlockItem)Items.f_41979_).m_40610_(blockPlaceContext, snowBlockState) && !abstractArrow.f_19853_.m_8055_(blockPos.m_7495_()).m_60734_().equals(Blocks.f_50125_) && !abstractArrow.f_19853_.m_8055_(blockPos.m_7495_()).m_60795_() && !abstractArrow.f_19853_.m_8055_(blockPos.m_7495_()).m_60713_(Blocks.f_50449_)) {
                        abstractArrow.f_19853_.m_46597_(blockPos, snowBlockState);
                    }
                    if (!ArrowsAPI.isValidForLiquidBlockReplacement(blockPos, abstractArrow.f_19853_, blockState, fluidState, Blocks.f_50449_, Blocks.f_49990_)) continue;
                    abstractArrow.f_19853_.m_46597_(blockPos, Blocks.f_50449_.m_49966_());
                    abstractArrow.m_5496_(SoundEvents.f_11986_, 1.0f, 1.2f / (abstractArrow.f_19796_.m_188501_() * 0.2f + 0.9f));
                }
                abstractArrow.m_146870_();
            }
        }
    }

    public static boolean isValidForLiquidBlockReplacement(BlockPos blockPos, Level level, BlockState blockState, FluidState fluidState, Block replacementBlock, Block replacedFluid) {
        return fluidState.equals(replacedFluid.m_49966_().m_60819_().m_61124_((Property)BlockStateProperties.f_61434_, (Comparable)Boolean.valueOf(false))) && !level.m_8055_(blockPos.m_7494_()).m_60713_(replacementBlock) && !level.m_8055_(blockPos.m_7494_()).m_60713_(replacedFluid) && (blockState.m_60713_(replacedFluid) || !fluidState.m_192917_(replacedFluid.m_49966_().m_60819_().m_76152_()));
    }

    public static void transformIntoPaddedArrow(AbstractArrow abstractArrow) {
        if (!abstractArrow.f_19853_.f_46443_) {
            PaddedArrowEntity paddedArrowEntity = new PaddedArrowEntity(abstractArrow.f_19853_, abstractArrow.m_20185_(), abstractArrow.m_20186_(), abstractArrow.m_20189_());
            paddedArrowEntity.f_36705_ = AbstractArrow.Pickup.ALLOWED;
            Entity entity = abstractArrow.m_19749_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                paddedArrowEntity = new PaddedArrowEntity(abstractArrow.f_19853_, livingEntity);
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (player.m_150110_().f_35937_) {
                        paddedArrowEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                }
            }
            paddedArrowEntity.m_146884_(abstractArrow.m_20182_());
            paddedArrowEntity.m_146922_(abstractArrow.m_146908_());
            paddedArrowEntity.m_146926_(abstractArrow.m_146909_());
            paddedArrowEntity.m_20256_(abstractArrow.m_20184_());
            abstractArrow.m_5496_(SoundEvents.f_144074_, 1.0f, 1.0f);
            abstractArrow.f_19853_.m_7967_((Entity)paddedArrowEntity);
            paddedArrowEntity.m_8119_();
            abstractArrow.m_146870_();
        }
    }

    public static void leashTarget(EntityHitResult entityHitResult, AbstractArrow abstractArrow) {
        Entity entity = entityHitResult.m_82443_();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (!(mob instanceof Villager) && abstractArrow.m_19749_() != null) {
                mob.m_21463_(abstractArrow.m_19749_(), true);
            } else {
                ArrowsAPI.dropItem(abstractArrow, new ItemStack((ItemLike)Items.f_42655_));
            }
        }
    }

    public static void feedTarget(EntityHitResult hitResult, ItemStack itemStack) {
        Entity entity = hitResult.m_82443_();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_5584_(mob.f_19853_, itemStack);
            if (mob.f_19853_.f_46443_) {
                mob.f_19853_.m_5594_(null, mob.m_20097_(), SoundEvents.f_12321_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
        if ((entity = hitResult.m_82443_()) instanceof Player) {
            Player player = (Player)entity;
            FoodProperties foodProperties = itemStack.getFoodProperties((LivingEntity)player);
            if (!player.m_150110_().f_35937_ && (player.m_36324_().m_38721_() || foodProperties != null && foodProperties.m_38747_())) {
                player.m_5584_(player.f_19853_, itemStack);
            } else if (!(player.m_36324_().m_38721_() || player.m_150110_().f_35937_ || player.m_36356_(itemStack))) {
                ArrowsAPI.dropItem(hitResult.m_82450_(), hitResult.m_82443_().f_19853_, itemStack);
            }
        }
    }

    public static void dropItem(AbstractArrow abstractArrow, ItemStack itemStack) {
        ArrowsAPI.dropItem(abstractArrow.m_20182_(), abstractArrow.f_19853_, itemStack);
    }

    public static void dropItem(Vec3 location, Level level, ItemStack itemStack) {
        if (!level.f_46443_) {
            ItemEntity itemEntity = new ItemEntity(level, location.f_82479_, location.f_82480_, location.f_82481_, itemStack);
            level.m_7967_((Entity)itemEntity);
        }
    }

    public static int getDenominatorOfLifeStealAmount() {
        if ((Integer)ArrowServerConfig.lifeStealAmount.get() == 2) {
            return 5;
        }
        if ((Integer)ArrowServerConfig.lifeStealAmount.get() == 3) {
            return 4;
        }
        if ((Integer)ArrowServerConfig.lifeStealAmount.get() == 4) {
            return 3;
        }
        return 6;
    }

    public static void lifeStealOnHitEntity(AbstractArrow abstractArrow, EntityHitResult entityHitResult) {
        Entity hitEntity = entityHitResult.m_82443_();
        Entity owner = abstractArrow.m_19749_();
        if (hitEntity instanceof LivingEntity) {
            LivingEntity livingHit = (LivingEntity)hitEntity;
            float health = livingHit.m_21223_();
            float healthToSteal = health * (1.0f / (float)ArrowsAPI.getDenominatorOfLifeStealAmount());
            if (healthToSteal > 20.0f) {
                healthToSteal = 20.0f;
            }
            if (owner != null && !livingHit.m_7306_(owner)) {
                livingHit.m_6469_(abstractArrow.m_269291_().m_269104_((Entity)livingHit, owner), healthToSteal);
                Level level = abstractArrow.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123798_, livingHit.m_20185_(), livingHit.m_20186_() + 2.0, livingHit.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (owner instanceof LivingEntity) {
                LivingEntity livingOwner = (LivingEntity)owner;
                livingOwner.m_5634_(healthToSteal);
                Level level = abstractArrow.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, livingOwner.m_20185_(), livingOwner.m_20186_() + 2.0, livingOwner.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static void gravityTick(AbstractArrow abstractArrow, EntityDataAccessor<Integer> LIFETIME) {
        if (abstractArrow.f_19797_ > (Integer)abstractArrow.m_20088_().m_135370_(LIFETIME)) {
            abstractArrow.m_20088_().m_135381_(LIFETIME, (Object)abstractArrow.f_19797_);
        } else {
            abstractArrow.f_19797_ = (Integer)abstractArrow.m_20088_().m_135370_(LIFETIME);
        }
        if ((Integer)abstractArrow.m_20088_().m_135370_(LIFETIME) < 200 && !abstractArrow.m_20068_()) {
            abstractArrow.m_20242_(true);
        } else if ((Integer)abstractArrow.m_20088_().m_135370_(LIFETIME) >= 200 && abstractArrow.m_20068_()) {
            abstractArrow.m_20242_(false);
        }
    }
}

