/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.monster.Troll;
import twilightforest.entity.projectile.TFThrowable;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFEntities;

public class ThrownBlock
extends TFThrowable {
    private BlockState state = Blocks.f_50069_.m_49966_();

    public ThrownBlock(EntityType<? extends TFThrowable> type, Level worldIn) {
        super(type, worldIn);
    }

    public ThrownBlock(Level world, LivingEntity thrower, @Nullable BlockState state) {
        super((EntityType<? extends TFThrowable>)((EntityType)TFEntities.THROWN_BLOCK.get()), world, thrower);
        if (state != null) {
            this.state = state;
        }
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.state));
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.state = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)tag.m_128469_("BlockState"));
    }

    public void m_7822_(byte id) {
        if (id == 3) {
            BlockParticleOption particle = new BlockParticleOption(ParticleTypes.f_123794_, this.state);
            for (int i = 0; i < 20; ++i) {
                this.m_9236_().m_6493_((ParticleOptions)particle, false, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19796_.m_188583_() * 0.05, this.f_19796_.m_188500_() * 0.2, this.f_19796_.m_188583_() * 0.05);
            }
        } else {
            super.m_7822_(id);
        }
    }

    protected void m_5790_(EntityHitResult result) {
        LivingEntity living;
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity && !((living = (LivingEntity)entity) instanceof Troll) && !this.m_9236_().m_5776_()) {
            living.m_6469_(TFDamageTypes.getDamageSource(this.m_9236_(), TFDamageTypes.THROWN_BLOCK, new EntityType[0]), 6.0f);
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_146852_(GameEvent.f_157794_, this.m_19749_());
            this.m_146870_();
        }
    }

    public BlockState getBlockState() {
        return this.state;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, Block.m_49956_((BlockState)this.getBlockState()));
    }

    public Component m_5677_() {
        return this.getBlockState().m_60734_().m_49954_();
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.state = Block.m_49803_((int)packet.m_131509_());
    }
}

