/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.passive;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import twilightforest.entity.passive.Bird;
import twilightforest.init.TFSounds;

public abstract class FlyingBird
extends Bird {
    private static final EntityDataAccessor<Byte> DATA_BIRDFLAGS = SynchedEntityData.m_135353_(FlyingBird.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private BlockPos targetPosition;
    private int currentFlightTime;

    public FlyingBird(EntityType<? extends Bird> entity, Level world) {
        super(entity, world);
        this.setIsBirdLanded(true);
        this.m_146762_(0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_BIRDFLAGS, (Object)0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, SEEDS, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public float getStepHeight() {
        return 1.0f;
    }

    public float m_21692_(BlockPos pos) {
        BlockState state = this.m_9236_().m_8055_(pos.m_7495_());
        if (state.m_204336_(BlockTags.f_13035_)) {
            return 200.0f;
        }
        if (state.m_204336_(BlockTags.f_13106_)) {
            return 15.0f;
        }
        if (state.m_204336_(BlockTags.f_144274_)) {
            return 9.0f;
        }
        return (float)this.m_9236_().m_46803_(pos) - 0.5f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.isBirdLanded()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.isBirdLanded()) {
            this.currentFlightTime = 0;
            boolean flag = this.m_20067_();
            if (this.isSpooked() || this.m_20069_() || !this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60819_().m_76178_() || this.m_217043_().m_188503_(200) == 0 && !this.isLandableBlock(this.m_20183_().m_7495_())) {
                this.setIsBirdLanded(false);
                if (!flag) {
                    this.m_5496_((SoundEvent)TFSounds.TINY_BIRD_TAKEOFF.get(), 0.05f, this.m_6100_());
                }
            }
        } else {
            ++this.currentFlightTime;
            if (!(this.targetPosition == null || this.m_9236_().m_46859_(this.targetPosition) && this.targetPosition.m_123342_() > this.m_9236_().m_141937_())) {
                this.targetPosition = null;
            }
            if (this.m_20069_() || !this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60819_().m_76178_()) {
                this.currentFlightTime = 0;
                this.m_20334_(this.m_20184_().m_7096_(), 0.1f, this.m_20184_().m_7094_());
            }
            if (this.targetPosition == null || this.m_217043_().m_188503_(30) == 0 || this.targetPosition.m_203195_((Position)this.m_20182_(), 2.0)) {
                int yTarget = this.currentFlightTime < 100 ? 2 : 4;
                this.targetPosition = BlockPos.m_274561_((double)(this.m_20185_() + (double)this.m_217043_().m_188503_(7) - (double)this.m_217043_().m_188503_(7)), (double)(this.m_20186_() + (double)this.m_217043_().m_188503_(6) - (double)yTarget), (double)(this.m_20189_() + (double)this.m_217043_().m_188503_(7) - (double)this.m_217043_().m_188503_(7)));
            }
            double d2 = (double)this.targetPosition.m_123341_() + 0.5 - this.m_20185_();
            double d0 = (double)this.targetPosition.m_123342_() + 0.1 - this.m_20186_();
            double d1 = (double)this.targetPosition.m_123343_() + 0.5 - this.m_20189_();
            Vec3 vec3 = this.m_20184_();
            Vec3 vec31 = vec3.m_82520_((Math.signum(d2) * 0.5 - vec3.m_7096_()) * (double)0.1f, (Math.signum(d0) * (double)0.7f - vec3.m_7098_()) * (double)0.1f, (Math.signum(d1) * 0.5 - vec3.m_7094_()) * (double)0.1f);
            this.m_20256_(vec31);
            float f = (float)(Mth.m_14136_((double)vec31.m_7094_(), (double)vec31.m_7096_()) * 57.2957763671875) - 90.0f;
            float f1 = Mth.m_14177_((float)(f - this.m_146908_()));
            this.f_20902_ = 0.5f;
            this.m_146922_(this.m_146908_() + f1);
            if (this.m_217043_().m_188503_(10) == 0 && this.isLandableBlock(this.m_20183_().m_7495_())) {
                this.setIsBirdLanded(true);
                this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
            }
        }
    }

    public boolean isLandableBlock(BlockPos pos) {
        BlockState state = this.m_9236_().m_8055_(pos);
        return !state.m_60795_() && (state.m_204336_(BlockTags.f_13035_) || state.m_60783_((BlockGetter)this.m_9236_(), pos, Direction.UP));
    }

    @Override
    public boolean isBirdLanded() {
        return ((Byte)this.m_20088_().m_135370_(DATA_BIRDFLAGS) & 1) != 0;
    }

    public void setIsBirdLanded(boolean landed) {
        byte flags = (Byte)this.m_20088_().m_135370_(DATA_BIRDFLAGS);
        this.m_20088_().m_135381_(DATA_BIRDFLAGS, (Object)((byte)(landed ? flags | 1 : flags & 0xFFFFFFFE)));
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    public boolean m_6090_() {
        return true;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    protected void m_6138_() {
    }

    public boolean m_6162_() {
        return false;
    }

    public abstract boolean isSpooked();
}

