/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.helpers;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.PartialNBTIngredient;
import net.minecraftforge.registries.ForgeRegistries;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFChestBlock;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.init.TFBlocks;

public abstract class CraftingDataHelper
extends RecipeProvider {
    public CraftingDataHelper(PackOutput output) {
        super(output);
    }

    public final PartialNBTIngredient scepter(Item scepter) {
        return PartialNBTIngredient.of((ItemLike)scepter, (CompoundTag)((CompoundTag)Util.m_137537_(() -> {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("Damage", scepter.m_41462_());
            return nbt;
        })));
    }

    public final PartialNBTIngredient potion(Potion potion) {
        return PartialNBTIngredient.of((ItemLike)Items.f_42589_, (CompoundTag)((CompoundTag)Util.m_137537_(() -> {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("Potion", ForgeRegistries.POTIONS.getKey((Object)potion).toString());
            return nbt;
        })));
    }

    protected final void charmRecipe(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, Supplier<? extends Item> item) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)result.get())).m_126211_((ItemLike)item.get(), 4).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)item.get()))).m_126140_(consumer, TwilightForestMod.prefix(name));
    }

    protected final void castleBlock(Consumer<FinishedRecipe> consumer, Supplier<? extends Block> result, ItemLike ... ingredients) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)result.get()), (int)4).m_126130_("##").m_126130_("##").m_126124_(Character.valueOf('#'), Ingredient.m_43929_((ItemLike[])ingredients)).m_126132_("has_castle_brick", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)TFBlocks.CASTLE_BRICK.get()))).m_126140_(consumer, this.locCastle(ForgeRegistries.BLOCKS.getKey((Object)result.get()).m_135815_()));
    }

    protected final void stairsBlock(Consumer<FinishedRecipe> consumer, ResourceLocation loc, Supplier<? extends Block> result, Supplier<? extends Block> criteria, ItemLike ... ingredients) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)result.get()), (int)8).m_126130_("#  ").m_126130_("## ").m_126130_("###").m_126124_(Character.valueOf('#'), Ingredient.m_43929_((ItemLike[])ingredients)).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)criteria.get()))).m_126140_(consumer, loc);
    }

    protected final void stairsRightBlock(Consumer<FinishedRecipe> consumer, ResourceLocation loc, Supplier<? extends Block> result, Supplier<? extends Block> criteria, ItemLike ... ingredients) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)result.get()), (int)8).m_126130_("###").m_126130_(" ##").m_126130_("  #").m_126124_(Character.valueOf('#'), Ingredient.m_43929_((ItemLike[])ingredients)).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)criteria.get()))).m_126140_(consumer, loc);
    }

    protected final void compressedBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, TagKey<Item> ingredient) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)result.get())).m_126130_("###").m_126130_("###").m_126130_("###").m_206416_(Character.valueOf('#'), ingredient).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_206406_(ingredient)).m_126140_(consumer, TwilightForestMod.prefix("compressed_blocks/" + name));
    }

    protected final void reverseCompressBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, TagKey<Item> ingredient) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)result.get()), (int)9).m_206419_(ingredient).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_206406_(ingredient)).m_126140_(consumer, TwilightForestMod.prefix("compressed_blocks/reversed/" + name));
    }

    protected final void helmetItem(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, TagKey<Item> material) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)result.get())).m_126130_("###").m_126130_("# #").m_206416_(Character.valueOf('#'), material).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_206406_(material)).m_126140_(consumer, this.locEquip(name));
    }

    protected final void chestplateItem(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, TagKey<Item> material) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)result.get())).m_126130_("# #").m_126130_("###").m_126130_("###").m_206416_(Character.valueOf('#'), material).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_206406_(material)).m_126140_(consumer, this.locEquip(name));
    }

    protected final void leggingsItem(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, TagKey<Item> material) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)result.get())).m_126130_("###").m_126130_("# #").m_126130_("# #").m_206416_(Character.valueOf('#'), material).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_206406_(material)).m_126140_(consumer, this.locEquip(name));
    }

    protected final void bootsItem(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, TagKey<Item> material) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)result.get())).m_126130_("# #").m_126130_("# #").m_206416_(Character.valueOf('#'), material).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_206406_(material)).m_126140_(consumer, this.locEquip(name));
    }

    protected final void pickaxeItem(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, TagKey<Item> material, TagKey<Item> handle) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)result.get())).m_126130_("###").m_126130_(" X ").m_126130_(" X ").m_206416_(Character.valueOf('#'), material).m_206416_(Character.valueOf('X'), handle).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_206406_(material)).m_126140_(consumer, this.locEquip(name));
    }

    protected final void swordItem(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, TagKey<Item> material, TagKey<Item> handle) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)result.get())).m_126130_("#").m_126130_("#").m_126130_("X").m_206416_(Character.valueOf('#'), material).m_206416_(Character.valueOf('X'), handle).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_206406_(material)).m_126140_(consumer, this.locEquip(name));
    }

    protected final void axeItem(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, TagKey<Item> material, TagKey<Item> handle) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)result.get())).m_126130_("##").m_126130_("#X").m_126130_(" X").m_206416_(Character.valueOf('#'), material).m_206416_(Character.valueOf('X'), handle).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_206406_(material)).m_126140_(consumer, this.locEquip(name));
    }

    protected final void buttonBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)result.get())).m_126209_((ItemLike)material.get()).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_126140_(consumer, this.locWood(name + "_button"));
    }

    protected final void doorBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)result.get()), (int)3).m_126130_("##").m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_126140_(consumer, this.locWood(name + "_door"));
    }

    protected final void fenceBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)result.get()), (int)3).m_126130_("#S#").m_126130_("#S#").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_126140_(consumer, this.locWood(name + "_fence"));
    }

    protected final void gateBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)result.get())).m_126130_("S#S").m_126130_("S#S").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_126140_(consumer, this.locWood(name + "_gate"));
    }

    protected final void planksBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, TagKey<Item> material) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)result.get()), (int)4).m_206419_(material).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_206406_(material)).m_126140_(consumer, this.locWood(name + "_planks"));
    }

    protected final void plateBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)result.get())).m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_126140_(consumer, this.locWood(name + "_plate"));
    }

    protected final void slabBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)result.get()), (int)6).m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_126140_(consumer, this.locWood(name + "_slab"));
    }

    protected final void bannerPattern(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> trophy, Supplier<? extends Item> result) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)result.get())).m_126184_(Ingredient.m_204132_(ItemTagGenerator.PAPER)).m_126184_(Ingredient.m_43929_((ItemLike[])new ItemLike[]{trophy.get().m_5456_()})).m_126132_("has_trophy", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)trophy.get()))).m_176498_(consumer);
    }

    protected final void trapdoorBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)result.get()), (int)2).m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_126140_(consumer, this.locWood(name + "_trapdoor"));
    }

    protected final void woodBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)result.get()), (int)3).m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_126140_(consumer, this.locWood(name + "_wood"));
    }

    protected final void strippedWoodBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)result.get()), (int)3).m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_126140_(consumer, this.locWood(name + "_stripped_wood"));
    }

    protected final void signBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)result.get()), (int)3).m_126130_("###").m_126130_("###").m_126130_(" - ").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_206416_(Character.valueOf('-'), Tags.Items.RODS_WOODEN).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_126140_(consumer, this.locWood(name + "_sign"));
    }

    protected final void hangingSignBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Item> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)result.get()), (int)6).m_126130_("| |").m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_126127_(Character.valueOf('|'), (ItemLike)Items.f_42026_).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_126140_(consumer, this.locWood(name + "_hanging_sign"));
    }

    protected final void banisterBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        this.banisterBlock(consumer, name, result, material.get());
    }

    protected final void banisterBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends Block> result, Block material) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)result.get()), (int)3).m_126130_("---").m_126130_("| |").m_126127_(Character.valueOf('-'), (ItemLike)material).m_206416_(Character.valueOf('|'), Tags.Items.RODS_WOODEN).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)material)).m_126140_(consumer, this.locWood(name + "_banister"));
    }

    protected final void chestBlock(Consumer<FinishedRecipe> consumer, String name, Supplier<? extends TFChestBlock> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)result.get()), (int)2).m_126130_("###").m_126130_("#C#").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)material.get()).m_206416_(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_125977_((ItemLike)((ItemLike)material.get()))).m_126140_(consumer, this.locWood(name + "_chest"));
    }

    protected final void fieryConversion(Consumer<FinishedRecipe> consumer, Supplier<? extends Item> result, Item armor, int vials) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)result.get())).m_126209_((ItemLike)armor).m_126186_(Ingredient.m_204132_(ItemTagGenerator.FIERY_VIAL), vials).m_126132_("has_item", (CriterionTriggerInstance)CraftingDataHelper.m_206406_(ItemTagGenerator.FIERY_VIAL)).m_126140_(consumer, this.locEquip("fiery_" + ForgeRegistries.ITEMS.getKey((Object)result.get()).m_135815_()));
    }

    protected final void buildBoats(Consumer<FinishedRecipe> consumer, Supplier<? extends Item> boat, Supplier<? extends Item> chestBoat, Supplier<? extends Block> planks) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)boat.get())).m_126130_("P P").m_126130_("PPP").m_126127_(Character.valueOf('P'), (ItemLike)planks.get()).m_126145_("boat").m_126132_("in_water", (CriterionTriggerInstance)CraftingDataHelper.m_125979_((Block)Blocks.f_49990_)).m_176498_(consumer);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)chestBoat.get())).m_126209_((ItemLike)boat.get()).m_206419_(Tags.Items.CHESTS_WOODEN).m_126145_("chest_boat").m_126132_("has_boat", (CriterionTriggerInstance)CraftingDataHelper.m_206406_((TagKey<Item>)ItemTags.f_13155_)).m_176498_(consumer);
    }

    protected final ResourceLocation locCastle(String name) {
        return TwilightForestMod.prefix("castleblock/" + name);
    }

    protected final ResourceLocation locEquip(String name) {
        return TwilightForestMod.prefix("equipment/" + name);
    }

    protected final ResourceLocation locNaga(String name) {
        return TwilightForestMod.prefix("nagastone/" + name);
    }

    protected final ResourceLocation locWood(String name) {
        return TwilightForestMod.prefix("wood/" + name);
    }

    protected static InventoryChangeTrigger.TriggerInstance m_206406_(TagKey<Item> p_206407_) {
        return CraftingDataHelper.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(p_206407_).m_45077_()});
    }
}

