/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.packets.server;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkEvent;
import wehavecookies56.bonfires.Bonfires;
import wehavecookies56.bonfires.BonfiresConfig;
import wehavecookies56.bonfires.advancements.BonfireLitTrigger;
import wehavecookies56.bonfires.blocks.AshBonePileBlock;
import wehavecookies56.bonfires.data.BonfireHandler;
import wehavecookies56.bonfires.data.DiscoveryHandler;
import wehavecookies56.bonfires.data.EstusHandler;
import wehavecookies56.bonfires.packets.Packet;
import wehavecookies56.bonfires.packets.PacketHandler;
import wehavecookies56.bonfires.packets.client.DisplayTitle;
import wehavecookies56.bonfires.packets.client.QueueBonfireScreenshot;
import wehavecookies56.bonfires.packets.client.SendBonfiresToClient;
import wehavecookies56.bonfires.packets.client.SyncBonfire;
import wehavecookies56.bonfires.packets.client.SyncDiscoveryData;
import wehavecookies56.bonfires.packets.client.SyncSaveData;
import wehavecookies56.bonfires.tiles.BonfireTileEntity;

public class LightBonfire
extends Packet<LightBonfire> {
    private String name;
    private int x;
    private int y;
    private int z;
    private boolean isPublic;
    private boolean createScreenshot;

    public LightBonfire(FriendlyByteBuf buffer) {
        super(buffer);
    }

    public LightBonfire(String name, BonfireTileEntity bonfire, boolean isPublic, boolean createScreenshot) {
        this.name = name;
        this.x = bonfire.m_58899_().m_123341_();
        this.y = bonfire.m_58899_().m_123342_();
        this.z = bonfire.m_58899_().m_123343_();
        this.isPublic = isPublic;
        this.createScreenshot = createScreenshot;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.name = buffer.m_130277_();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.isPublic = buffer.readBoolean();
        this.createScreenshot = buffer.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.name);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeBoolean(this.isPublic);
        buffer.writeBoolean(this.createScreenshot);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        BonfireTileEntity te;
        BlockPos pos = new BlockPos(this.x, this.y, this.z);
        ServerPlayer player = context.getSender();
        if (player != null && (te = (BonfireTileEntity)player.m_9236_().m_7702_(pos)) != null && !te.isLit()) {
            te.setLit(true);
            UUID id = UUID.randomUUID();
            te.createBonfire(this.name, id, player.m_20148_(), this.isPublic);
            te.setID(id);
            player.m_9236_().m_7731_(pos, (BlockState)player.m_9236_().m_8055_(pos).m_61124_((Property)AshBonePileBlock.LIT, (Comparable)Boolean.valueOf(true)), 2);
            if (!BonfiresConfig.Common.disableBonfireRespawn) {
                player.m_9158_(te.m_58904_().m_46472_(), te.m_58899_(), player.m_146908_(), false, true);
            }
            EstusHandler.getHandler((Player)player).setLastRested(te.getID());
            DiscoveryHandler.getHandler((Player)player).discover(id);
            BonfireLitTrigger.TRIGGER_BONFIRE_LIT.trigger(player);
            PacketHandler.sendToAll(new SyncBonfire(te.isBonfire(), te.getBonfireType(), te.isLit(), te.getID(), te));
            PacketHandler.sendToAll(new SyncSaveData(BonfireHandler.getHandler(player.m_9236_()).getRegistry().getBonfires()));
            if (!BonfiresConfig.Common.bonfireDiscoveryMode) {
                PacketHandler.sendToAll(new SendBonfiresToClient());
            }
            PacketHandler.sendTo(new SyncDiscoveryData(DiscoveryHandler.getHandler((Player)player)), player);
            if (this.createScreenshot) {
                PacketHandler.sendTo(new QueueBonfireScreenshot(this.name, id), player);
            }
            PacketHandler.sendTo(new DisplayTitle("bonfire.lit", this.name, 15, 20, 15), player);
            Bonfires.LOGGER.info("Bonfire'" + this.name + "' lit at: X" + this.x + " Y" + this.y + " Z" + this.z + " by " + player.m_5446_().getString());
        }
    }
}

