/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.packets.client;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import wehavecookies56.bonfires.bonfire.Bonfire;
import wehavecookies56.bonfires.client.ClientPacketHandler;
import wehavecookies56.bonfires.packets.Packet;

public class SyncSaveData
extends Packet<SyncSaveData> {
    public Map<UUID, Bonfire> bonfires;

    public SyncSaveData(FriendlyByteBuf buffer) {
        super(buffer);
    }

    public SyncSaveData(Map<UUID, Bonfire> bonfires) {
        this.bonfires = bonfires;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.bonfires = new HashMap<UUID, Bonfire>();
        while (buffer.isReadable()) {
            UUID key = buffer.m_130259_();
            String name = buffer.m_130277_();
            UUID owner = buffer.m_130259_();
            BlockPos pos = new BlockPos((int)buffer.readDouble(), (int)buffer.readDouble(), (int)buffer.readDouble());
            ResourceKey dim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(buffer.m_130277_()));
            boolean isPublic = buffer.readBoolean();
            Instant time = Instant.ofEpochSecond(buffer.readLong(), buffer.readInt());
            Bonfire bonfire = new Bonfire(name, key, owner, pos, (ResourceKey<Level>)dim, isPublic, time);
            this.bonfires.put(key, bonfire);
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        for (Map.Entry<UUID, Bonfire> pair : this.bonfires.entrySet()) {
            buffer.m_130077_(pair.getKey());
            Bonfire bonfire = pair.getValue();
            buffer.m_130070_(bonfire.getName());
            buffer.m_130077_(bonfire.getOwner());
            buffer.writeDouble((double)bonfire.getPos().m_123341_());
            buffer.writeDouble((double)bonfire.getPos().m_123342_());
            buffer.writeDouble((double)bonfire.getPos().m_123343_());
            buffer.m_130070_(bonfire.getDimension().m_135782_().toString());
            buffer.writeBoolean(bonfire.isPublic());
            buffer.writeLong(bonfire.getTimeCreated().getEpochSecond());
            buffer.writeInt(bonfire.getTimeCreated().getNano());
        }
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientPacketHandler.syncSaveData(this));
    }
}

