/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.data;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.registries.ForgeRegistries;
import wehavecookies56.bonfires.Bonfires;
import wehavecookies56.bonfires.BonfiresConfig;
import wehavecookies56.bonfires.items.EstusFlaskItem;
import wehavecookies56.bonfires.setup.ItemSetup;

public class ReinforceHandler {
    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ReinforceHandler());
    }

    public static boolean canReinforce(ItemStack stack) {
        Item i = stack.m_41720_();
        for (String s : BonfiresConfig.Common.reinforceBlacklist) {
            if (ForgeRegistries.ITEMS.containsKey(new ResourceLocation(s))) {
                Item blacklistedItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s));
                if (i != blacklistedItem) continue;
                return false;
            }
            Bonfires.LOGGER.info("Unable to find blacklisted item '" + s + "' in the registry");
        }
        return i instanceof TieredItem || i instanceof SwordItem || i instanceof EstusFlaskItem;
    }

    public static ReinforceLevel getReinforceLevel(ItemStack stack) {
        int levelFromCap = 0;
        int maxLevelFromCap = 10;
        if (ReinforceHandler.canReinforce(stack)) {
            if (stack.m_41782_()) {
                if (stack.m_41783_().m_128441_("reinforce_level")) {
                    return new ReinforceLevel(stack.m_41783_().m_128451_("reinforce_level"), stack.m_41783_().m_128451_("reinforce_max"));
                }
                stack.m_41783_().m_128405_("reinforce_level", levelFromCap);
                stack.m_41783_().m_128405_("reinforce_max", maxLevelFromCap);
                return new ReinforceLevel(levelFromCap, maxLevelFromCap);
            }
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("reinforce_level", levelFromCap);
            tag.m_128405_("reinforce_max", maxLevelFromCap);
            stack.m_41751_(tag);
            return new ReinforceLevel(levelFromCap, maxLevelFromCap);
        }
        return null;
    }

    public static void levelUp(ItemStack stack) {
        ReinforceLevel current = ReinforceHandler.getReinforceLevel(stack);
        if (current != null && current.level() < stack.m_41783_().m_128451_("reinforce_max")) {
            stack.m_41783_().m_128405_("reinforce_level", current.level() + 1);
        }
    }

    public static ItemStack getRequiredResources(ItemStack toReinforce) {
        if (ReinforceHandler.getReinforceLevel(toReinforce) != null) {
            ReinforceLevel rlevel = ReinforceHandler.getReinforceLevel(toReinforce);
            if (toReinforce.m_41720_() == ItemSetup.estus_flask.get()) {
                if (rlevel.level() < rlevel.maxLevel()) {
                    return new ItemStack((ItemLike)ItemSetup.undead_bone_shard.get());
                }
                return ItemStack.f_41583_;
            }
            if (rlevel.level() < rlevel.maxLevel()) {
                int cost = 1;
                Item material = ItemStack.f_41583_.m_41720_();
                if (rlevel.level() >= 0 && rlevel.level() <= 2) {
                    cost = 2 * (rlevel.level() + 1);
                    material = (Item)ItemSetup.titanite_shard.get();
                }
                if (rlevel.level() >= 3 && rlevel.level() <= 5) {
                    cost = 2 * (rlevel.level() + 1 - 3);
                    material = (Item)ItemSetup.large_titanite_shard.get();
                }
                if (rlevel.level() >= 6 && rlevel.level() <= 8) {
                    cost = 2 * (rlevel.level() + 1 - 6);
                    material = (Item)ItemSetup.titanite_chunk.get();
                }
                if (rlevel.level() >= 9 && rlevel.level() < 10) {
                    cost = 1;
                    material = (Item)ItemSetup.titanite_slab.get();
                }
                return new ItemStack((ItemLike)material, cost);
            }
        }
        return ItemStack.f_41583_;
    }

    public static boolean hasRequiredItems(Player player, ItemStack required) {
        int hasCount = 0;
        int countRequired = required.m_41613_();
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            if (ItemStack.m_41728_((ItemStack)required, (ItemStack)player.m_150109_().m_8020_(i))) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)player.m_150109_().m_8020_(i), (ItemStack)required)) continue;
            hasCount += player.m_150109_().m_8020_(i).m_41613_();
        }
        return hasCount >= countRequired;
    }

    public static void removeRequiredItems(Player player, ItemStack required) {
        if (ReinforceHandler.hasRequiredItems(player, required)) {
            int remaining = required.m_41613_();
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                ItemStack item = player.m_150109_().m_8020_(i);
                if (ItemStack.m_41656_((ItemStack)required, (ItemStack)item)) {
                    if (item.m_41613_() >= remaining) {
                        item.m_41774_(remaining);
                        return;
                    }
                    remaining -= item.m_41613_();
                    player.m_150109_().m_6836_(i, ItemStack.f_41583_);
                }
                if (remaining != 0) continue;
                return;
            }
        }
    }

    public static final class ReinforceLevel {
        private int level;
        private int maxLevel;

        private ReinforceLevel(int level, int maxLevel) {
            this.level = level;
            this.maxLevel = maxLevel;
        }

        public int level() {
            return this.level;
        }

        public int maxLevel() {
            return this.maxLevel;
        }
    }
}

