/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.data;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DiscoveryHandler {
    public static final Capability<IDiscoveryHandler> CAPABILITY_DISCOVERY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDiscoveryHandler>(){});

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new DiscoveryHandler());
    }

    @SubscribeEvent
    public static void register(RegisterCapabilitiesEvent event) {
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("bonfires", "discovery"), (ICapabilityProvider)new Provider());
        }
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        IDiscoveryHandler original = DiscoveryHandler.getHandler(event.getOriginal());
        IDiscoveryHandler clone = DiscoveryHandler.getHandler(event.getEntity());
        original.getDiscovered().forEach(clone::setDiscovered);
        event.getOriginal().invalidateCaps();
    }

    public static IDiscoveryHandler getHandler(Player player) {
        LazyOptional discoveryHandler = player.getCapability(CAPABILITY_DISCOVERY, null);
        return (IDiscoveryHandler)discoveryHandler.orElse(null);
    }

    public static class Provider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        IDiscoveryHandler instance = new Default();

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CAPABILITY_DISCOVERY.orEmpty(cap, LazyOptional.of(() -> this.instance));
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.instance.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.instance.deserializeNBT((Tag)nbt);
        }
    }

    public static interface IDiscoveryHandler
    extends INBTSerializable<CompoundTag> {
        public void setDiscovered(UUID var1, Instant var2);

        public void discover(UUID var1);

        public Map<UUID, Instant> getDiscovered();
    }

    public static class Default
    implements IDiscoveryHandler {
        private Map<UUID, Instant> discovered = new HashMap<UUID, Instant>();

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            this.discovered.forEach((uuid, instant) -> {
                CompoundTag time = new CompoundTag();
                time.m_128356_("epoch", instant.getEpochSecond());
                time.m_128405_("nano", instant.getNano());
                tag.m_128365_(uuid.toString(), (Tag)time);
            });
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            tag.m_128431_().forEach(uuidString -> {
                CompoundTag timeTag = tag.m_128469_(uuidString);
                Instant time = Instant.ofEpochSecond(timeTag.m_128454_("epoch"), timeTag.m_128451_("nano"));
                this.discovered.put(UUID.fromString(uuidString), time);
            });
        }

        @Override
        public void setDiscovered(UUID bonfire, Instant time) {
            this.discovered.put(bonfire, time);
        }

        @Override
        public void discover(UUID bonfire) {
            if (!this.discovered.containsKey(bonfire)) {
                this.discovered.put(bonfire, Instant.now());
            }
        }

        @Override
        public Map<UUID, Instant> getDiscovered() {
            return this.discovered;
        }
    }
}

