/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.client.gui;

import com.mojang.blaze3d.platform.Window;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import wehavecookies56.bonfires.client.gui.BonfireScreen;
import wehavecookies56.bonfires.client.gui.widgets.ReinforceItemButton;
import wehavecookies56.bonfires.client.gui.widgets.ScrollBarButton;
import wehavecookies56.bonfires.data.ReinforceHandler;
import wehavecookies56.bonfires.packets.PacketHandler;
import wehavecookies56.bonfires.packets.server.ReinforceItem;

public class ReinforceScreen
extends Screen {
    public List<ItemStack> reinforceableItems;
    public List<Integer> slots;
    public int itemSelected = -1;
    float scrollOffset = 0.0f;
    final int SCROLLBAR = 0;
    final int ITEMS = 1;
    final int CONFIRM = 2;
    ReinforceItemButton items;
    BonfireScreen parent;
    public ScrollBarButton scrollBar;
    Button confirm;
    private static ResourceLocation texture = new ResourceLocation("bonfires", "textures/gui/reinforce_menu.png");
    int texWidth = 256;
    int texHeight = 219;
    Minecraft mc;

    public ReinforceScreen(BonfireScreen parent) {
        super((Component)Component.m_237119_());
        this.parent = parent;
        this.mc = Minecraft.m_91087_();
        if (!parent.canReinforce) {
            this.mc.m_91152_(null);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.scrollBar.m_6375_(mouseX, mouseY, button);
        if (button == 0) {
            this.items.mousePressed(this.mc, mouseX, mouseY, this.scrollBar.scrollOffset);
        }
        this.confirm.m_6375_(mouseX, mouseY, button);
        if (this.confirm.m_5953_(mouseX, mouseY)) {
            this.action(2);
        }
        if (button == 1) {
            this.mc.m_91152_((Screen)this.parent);
        }
        this.updateButtons();
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.scrollBar.m_6348_(mouseX, mouseY, button);
        this.confirm.m_6348_(mouseX, mouseY, button);
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.scrollBar.m_7979_(mouseX, mouseY, button, dragX, dragY);
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        this.scrollBar.m_6050_(mouseX, mouseY, scrollDelta);
        return super.m_6050_(mouseX, mouseY, scrollDelta);
    }

    public void updateButtons() {
        Window window = this.mc.m_91268_();
        int centerX = window.m_85441_() / 2 - this.texWidth / 2;
        int centerY = window.m_85442_() / 2 - this.texHeight / 2;
        if (this.itemSelected != -1) {
            ReinforceHandler.ReinforceLevel reinforceLevel = ReinforceHandler.getReinforceLevel(this.reinforceableItems.get(this.itemSelected));
            this.confirm.f_93623_ = reinforceLevel.level() != reinforceLevel.maxLevel() ? ReinforceHandler.hasRequiredItems((Player)this.mc.f_91074_, ReinforceHandler.getRequiredResources(this.reinforceableItems.get(this.itemSelected))) : false;
        }
    }

    public void m_7856_() {
        this.getReinforceableItems();
        Window window = this.mc.m_91268_();
        int centerX = window.m_85445_() / 2 - this.texWidth / 2;
        int centerY = window.m_85446_() / 2 - this.texHeight / 2;
        this.scrollBar = new ScrollBarButton(0, window.m_85445_() / 2 + this.texWidth / 2 - 16, window.m_85446_() / 2 - this.texHeight / 2 + 41, 8, 171, 171, 36 * this.reinforceableItems.size());
        this.m_169394_((Renderable)this.scrollBar);
        this.items = new ReinforceItemButton(this, 1, window.m_85445_() / 2 - this.texWidth / 2 + 9, window.m_85446_() / 2 - this.texHeight / 2 + 41, 239, 171);
        this.m_169394_((Renderable)this.items);
        this.confirm = Button.m_253074_((Component)Component.m_237115_((String)"button.bonfires.reinforce"), button -> {}).m_252794_(centerX + 180, centerY + 14).m_253046_(60, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.confirm);
        if (this.reinforceableItems.size() > 1) {
            this.itemSelected = 0;
        } else {
            this.confirm.f_93623_ = false;
        }
        this.updateButtons();
        super.m_7856_();
    }

    public void action(int id) {
        switch (id) {
            case 2: {
                if (this.itemSelected == -1 || !ReinforceHandler.hasRequiredItems((Player)this.mc.f_91074_, ReinforceHandler.getRequiredResources(this.reinforceableItems.get(this.itemSelected)))) break;
                ItemStack reinforcedStack = this.reinforceableItems.get(this.itemSelected).m_41777_();
                ReinforceHandler.levelUp(reinforcedStack);
                reinforcedStack.m_41783_().m_128405_("Damage", 0);
                PacketHandler.sendToServer(new ReinforceItem(this.slots.get(this.itemSelected)));
                this.mc.f_91074_.m_150109_().m_6836_(this.slots.get(this.itemSelected).intValue(), reinforcedStack);
                this.getReinforceableItems();
            }
        }
        this.updateButtons();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        Window window = this.mc.m_91268_();
        int centerX = window.m_85445_() / 2 - this.texWidth / 2;
        int centerY = window.m_85446_() / 2 - this.texHeight / 2;
        guiGraphics.m_280218_(texture, centerX, centerY, 0, 0, this.texWidth, this.texHeight);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        int scrollBarHeight = this.scrollBar.getBottom() - this.scrollBar.m_252907_();
        int listHeight = 36 * this.reinforceableItems.size();
        if (scrollBarHeight >= listHeight) {
            this.scrollBar.f_93624_ = false;
            this.scrollBar.f_93623_ = false;
        } else {
            this.scrollBar.f_93624_ = true;
            this.scrollBar.f_93623_ = true;
        }
        this.items.drawButtons(guiGraphics, mouseX, mouseY, partialTicks, this.scrollBar.scrollOffset);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"text.bonfires.reinforce"), centerX + 10, centerY + 10, new Color(255, 255, 255).hashCode());
        if (this.itemSelected != -1) {
            ItemStack required = ReinforceHandler.getRequiredResources(this.reinforceableItems.get(this.itemSelected));
            int hasCount = 0;
            for (int i = 0; i < this.mc.f_91074_.m_150109_().f_35974_.size(); ++i) {
                if (!ItemStack.m_41656_((ItemStack)this.mc.f_91074_.m_150109_().m_8020_(i), (ItemStack)required)) continue;
                hasCount += this.mc.f_91074_.m_150109_().m_8020_(i).m_41613_();
            }
            ReinforceHandler.ReinforceLevel reinforceLevel = ReinforceHandler.getReinforceLevel(this.reinforceableItems.get(this.itemSelected));
            if (reinforceLevel.level() != reinforceLevel.maxLevel()) {
                guiGraphics.m_280488_(this.f_96547_, required.m_41786_().getString() + ": " + hasCount + " / " + required.m_41613_(), centerX + 10, centerY + 24, new Color(255, 255, 255).hashCode());
            } else {
                guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"text.bonfires.max_level"), centerX + 10, centerY + 24, new Color(255, 255, 255).hashCode());
            }
        }
    }

    public void getReinforceableItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < this.mc.f_91074_.m_150109_().f_35974_.size(); ++i) {
            if (!ReinforceHandler.canReinforce(this.mc.f_91074_.m_150109_().m_8020_(i))) continue;
            items.add(this.mc.f_91074_.m_150109_().m_8020_(i));
            slots.add(i);
        }
        if (ReinforceHandler.canReinforce(this.mc.f_91074_.m_21206_())) {
            items.add(this.mc.f_91074_.m_21206_());
            slots.add(40);
        }
        this.reinforceableItems = items;
        this.slots = slots;
    }

    public void m_86600_() {
        this.updateButtons();
    }

    public boolean m_7043_() {
        return false;
    }
}

