/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.client;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.text.WordUtils;
import wehavecookies56.bonfires.Bonfires;
import wehavecookies56.bonfires.BonfiresConfig;
import wehavecookies56.bonfires.LocalStrings;
import wehavecookies56.bonfires.bonfire.Bonfire;
import wehavecookies56.bonfires.client.ScreenshotUtils;
import wehavecookies56.bonfires.client.gui.BonfireScreen;
import wehavecookies56.bonfires.client.gui.CreateBonfireScreen;
import wehavecookies56.bonfires.data.BonfireHandler;
import wehavecookies56.bonfires.data.DiscoveryHandler;
import wehavecookies56.bonfires.data.EstusHandler;
import wehavecookies56.bonfires.packets.client.DisplayTitle;
import wehavecookies56.bonfires.packets.client.OpenBonfireGUI;
import wehavecookies56.bonfires.packets.client.SendBonfiresToClient;
import wehavecookies56.bonfires.packets.client.SyncBonfire;
import wehavecookies56.bonfires.packets.client.SyncSaveData;
import wehavecookies56.bonfires.tiles.BonfireTileEntity;

public class ClientPacketHandler {
    public static DistExecutor.SafeRunnable openBonfire(final OpenBonfireGUI packet) {
        return new DistExecutor.SafeRunnable(){

            public void run() {
                Minecraft.m_91087_().m_91152_((Screen)new BonfireScreen((BonfireTileEntity)Minecraft.m_91087_().f_91073_.m_7702_(packet.tileEntity), packet.ownerNames, packet.dimensions.stream().filter(dim -> !BonfiresConfig.Client.hiddenDimensions.contains(dim.m_135782_().toString())).toList(), packet.registry, packet.canReinforce));
            }
        };
    }

    public static DistExecutor.SafeRunnable setBonfiresFromServer(final SendBonfiresToClient packet) {
        return new DistExecutor.SafeRunnable(){

            public void run() {
                Screen screen;
                if (Minecraft.m_91087_().f_91080_ != null && (screen = Minecraft.m_91087_().f_91080_) instanceof BonfireScreen) {
                    BonfireScreen gui = (BonfireScreen)screen;
                    gui.updateDimensionsFromServer(packet.registry, packet.dimensions.stream().filter(dim -> !BonfiresConfig.Client.hiddenDimensions.contains(dim.m_135782_().toString())).toList(), packet.ownerNames);
                }
            }
        };
    }

    public static DistExecutor.SafeRunnable openCreateScreen(final BonfireTileEntity te) {
        return new DistExecutor.SafeRunnable(){

            public void run() {
                Minecraft.m_91087_().m_91152_((Screen)new CreateBonfireScreen(te));
            }
        };
    }

    public static DistExecutor.SafeRunnable displayTitle(final DisplayTitle packet) {
        return new DistExecutor.SafeRunnable(){

            public void run() {
                Gui gui = Minecraft.m_91087_().f_91065_;
                gui.m_168714_((Component)Component.m_237115_((String)packet.title));
                gui.m_168711_((Component)Component.m_237115_((String)packet.subtitle));
                gui.m_168684_(packet.fadein, packet.stay, packet.fadeout);
            }
        };
    }

    public static DistExecutor.SafeRunnable syncBonfire(final SyncBonfire packet) {
        return new DistExecutor.SafeRunnable(){

            public void run() {
                BonfireTileEntity te;
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                BlockPos pos = new BlockPos(packet.x, packet.y, packet.z);
                if (level.m_7702_(pos) != null && level.m_7702_(pos) instanceof BonfireTileEntity && (te = (BonfireTileEntity)level.m_7702_(pos)) != null) {
                    te.setBonfire(packet.bonfire);
                    te.setBonfireType(packet.type);
                    te.setLit(packet.lit);
                    if (packet.lit) {
                        te.setID(packet.id);
                    }
                }
            }
        };
    }

    public static DistExecutor.SafeRunnable syncSaveData(final SyncSaveData packet) {
        return new DistExecutor.SafeRunnable(){

            public void run() {
                BonfireHandler.getHandler((Level)Minecraft.m_91087_().f_91073_).getRegistry().setBonfires(packet.bonfires);
            }
        };
    }

    public static DistExecutor.SafeRunnable syncEstusData(final UUID lastRested, final int uses) {
        return new DistExecutor.SafeRunnable(){

            public void run() {
                EstusHandler.IEstusHandler handler = EstusHandler.getHandler((Player)Minecraft.m_91087_().f_91074_);
                handler.setLastRested(lastRested);
                handler.setUses(uses);
            }
        };
    }

    public static DistExecutor.SafeRunnable syncDiscoveryData(final Map<UUID, Instant> discovered) {
        return new DistExecutor.SafeRunnable(){

            public void run() {
                DiscoveryHandler.IDiscoveryHandler handler = DiscoveryHandler.getHandler((Player)Minecraft.m_91087_().f_91074_);
                discovered.forEach(handler::setDiscovered);
            }
        };
    }

    public static DistExecutor.SafeRunnable displayBonfireTravelled(final Bonfire bonfire) {
        return new DistExecutor.SafeRunnable(){

            public void run() {
                String formattedDimName;
                if (I18n.m_118936_((String)LocalStrings.getDimensionKey(bonfire.getDimension()))) {
                    String dimName = bonfire.getDimension().m_135782_().m_135815_().replaceAll("_", " ");
                    formattedDimName = WordUtils.capitalizeFully((String)dimName);
                } else {
                    formattedDimName = I18n.m_118938_((String)LocalStrings.getDimensionKey(bonfire.getDimension()), (Object[])new Object[0]);
                }
                Gui gui = Minecraft.m_91087_().f_91065_;
                gui.m_168714_((Component)Component.m_237115_((String)bonfire.getName()));
                gui.m_168711_((Component)Component.m_237115_((String)formattedDimName));
                gui.m_168684_(10, 20, 10);
            }
        };
    }

    public static DistExecutor.SafeRunnable queueBonfireScreenshot(final String name, final UUID uuid) {
        return new DistExecutor.SafeRunnable(){

            public void run() {
                ScreenshotUtils.startScreenshotTimer(name, uuid);
            }
        };
    }

    public static DistExecutor.SafeRunnable deleteScreenshot(final UUID uuid, final String name) {
        return new DistExecutor.SafeRunnable(){

            public void run() {
                if (BonfiresConfig.Client.deleteScreenshotsOnDestroyed) {
                    Path screenshotsDir = Paths.get(Minecraft.m_91087_().f_91069_.getPath(), "bonfires/");
                    String fileName = ScreenshotUtils.getFileNameString(name, uuid);
                    File screenshotFile = new File(screenshotsDir.toFile(), fileName);
                    if (screenshotFile.exists() && screenshotFile.isFile()) {
                        String path = screenshotFile.getPath();
                        if (!screenshotFile.delete()) {
                            Bonfires.LOGGER.warn("Failed to delete screenshot file " + path);
                        } else {
                            Bonfires.LOGGER.info("Deleted screenshot for destroyed bonfire " + fileName);
                        }
                    }
                }
            }
        };
    }
}

