/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.bonfire;

import com.mojang.authlib.GameProfile;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.level.Level;
import wehavecookies56.bonfires.bonfire.Bonfire;

public class BonfireRegistry {
    private Map<UUID, Bonfire> bonfires = new HashMap<UUID, Bonfire>();

    public static Map<UUID, String> getOwnerNames(MinecraftServer server) {
        HashMap<UUID, String> ownerNames = new HashMap<UUID, String>();
        server.m_6846_().m_11314_().forEach(serverPlayer -> {
            GameProfileCache gameProfileCache = server.m_129927_();
            if (gameProfileCache.m_11002_(serverPlayer.m_20148_()).isPresent()) {
                ownerNames.put(serverPlayer.m_20148_(), ((GameProfile)gameProfileCache.m_11002_(serverPlayer.m_20148_()).get()).getName());
            } else {
                ownerNames.put(serverPlayer.m_20148_(), "Unknown");
            }
        });
        return ownerNames;
    }

    public BonfireRegistry getFilteredRegistry(List<UUID> filter) {
        BonfireRegistry registry = new BonfireRegistry();
        Map<UUID, Bonfire> bonfires = this.getBonfires();
        HashMap<UUID, Bonfire> filtered = new HashMap<UUID, Bonfire>();
        bonfires.forEach((uuid, bonfire) -> {
            if (filter.contains(uuid)) {
                filtered.put((UUID)uuid, (Bonfire)bonfire);
            }
        });
        registry.setBonfires(filtered);
        return registry;
    }

    public Map<UUID, Bonfire> getBonfires() {
        return this.bonfires;
    }

    public void setBonfires(Map<UUID, Bonfire> bonfires) {
        this.bonfires = bonfires;
    }

    public boolean removeBonfire(UUID id) {
        if (this.bonfires.containsKey(id)) {
            this.bonfires.remove(id);
            return true;
        }
        return false;
    }

    public List<Bonfire> getBonfiresByOwner(UUID owner) {
        return this.getBonfires().values().stream().filter(bonfire -> bonfire.getOwner().compareTo(owner) == 0).toList();
    }

    public List<Bonfire> getBonfiresByName(String name) {
        return this.getBonfires().values().stream().filter(bonfire -> bonfire.getName().toLowerCase().contains(name.toLowerCase())).toList();
    }

    public List<Bonfire> getBonfiresInRadius(BlockPos pos, int radius, ResourceLocation dimension) {
        return this.getBonfiresByDimension(dimension).stream().filter(bonfire -> {
            int cx = pos.m_123341_();
            int cz = pos.m_123343_();
            int cy = pos.m_123342_();
            int fx = bonfire.getPos().m_123341_();
            int fz = bonfire.getPos().m_123343_();
            int fy = bonfire.getPos().m_123342_();
            int tx = cx + radius;
            int bx = cx - radius;
            int tz = cz + radius;
            int bz = cz - radius;
            int ty = cy + radius;
            int by = cy - radius;
            return fx <= tx && fx >= bx && fz <= tz && fz >= bz && fy <= ty && fy >= by;
        }).collect(Collectors.toList());
    }

    public Bonfire getBonfireAtPos(BlockPos pos, ResourceKey<Level> dim) {
        List<Bonfire> result = this.getBonfiresByDimension(dim.m_135782_()).stream().filter(bonfire -> pos.equals((Object)bonfire.getPos())).toList();
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    private List<Bonfire> getBonfiresByPublic(boolean isPublic) {
        return this.getBonfires().values().stream().filter(bonfire -> bonfire.isPublic == isPublic).collect(Collectors.toList());
    }

    private List<Bonfire> getPrivateBonfiresByOwner(UUID owner) {
        return this.getBonfires().values().stream().filter(bonfire -> bonfire.getOwner().compareTo(owner) == 0 && !bonfire.isPublic).collect(Collectors.toList());
    }

    private List<Bonfire> getBonfiresByPublicPerDimension(boolean isPublic, ResourceLocation dim) {
        return this.getBonfires().values().stream().filter(bonfire -> bonfire.getDimension().m_135782_().equals((Object)dim) && bonfire.isPublic).collect(Collectors.toList());
    }

    private List<Bonfire> getPrivateBonfiresByOwnerPerDimension(UUID owner, ResourceLocation dim) {
        return this.getBonfires().values().stream().filter(bonfire -> bonfire.getOwner().compareTo(owner) == 0 && !bonfire.isPublic && bonfire.getDimension().m_135782_().equals((Object)dim)).collect(Collectors.toList());
    }

    public List<Bonfire> getPrivateBonfiresByOwnerAndPublicPerDimension(UUID owner, ResourceLocation dim) {
        ArrayList<Bonfire> list = new ArrayList<Bonfire>();
        list.addAll(this.getBonfiresByPublicPerDimension(true, dim));
        list.addAll(this.getPrivateBonfiresByOwnerPerDimension(owner, dim));
        return list;
    }

    public static List<Bonfire> sortBonfiresByTime(List<Bonfire> bonfiresToSort) {
        ArrayList<Bonfire> sortedList = new ArrayList<Bonfire>(bonfiresToSort);
        sortedList.sort(Comparator.comparing(Bonfire::getTimeCreated).reversed());
        return sortedList;
    }

    public List<Bonfire> getPrivateBonfiresByOwnerAndPublic(UUID owner) {
        ArrayList<Bonfire> list = new ArrayList<Bonfire>();
        list.addAll(this.getBonfiresByPublic(true));
        list.addAll(this.getPrivateBonfiresByOwner(owner));
        return list;
    }

    public List<Bonfire> getBonfiresByDimension(ResourceLocation dimension) {
        return this.getBonfires().values().stream().filter(bonfire -> bonfire.getDimension().m_135782_().equals((Object)dimension)).collect(Collectors.toList());
    }

    public boolean addBonfire(Bonfire bonfire) {
        if (this.bonfires.containsKey(bonfire.getId()) || this.getBonfireAtPos(bonfire.getPos(), bonfire.getDimension()) != null) {
            return false;
        }
        this.bonfires.put(bonfire.getId(), bonfire);
        return true;
    }

    public Bonfire getBonfire(UUID id) {
        return this.bonfires.getOrDefault(id, null);
    }

    public CompoundTag writeToNBT(CompoundTag tagCompound, Map<UUID, Bonfire> bonfires) {
        for (Map.Entry<UUID, Bonfire> pair : bonfires.entrySet()) {
            CompoundTag bonfireCompound = new CompoundTag();
            bonfireCompound.m_128362_("ID", pair.getValue().getId());
            bonfireCompound.m_128359_("NAME", pair.getValue().getName());
            bonfireCompound.m_128362_("OWNER", pair.getValue().getOwner());
            bonfireCompound.m_128379_("PUBLIC", pair.getValue().isPublic());
            bonfireCompound.m_128359_("DIM", pair.getValue().getDimension().m_135782_().toString());
            bonfireCompound.m_128347_("POSX", (double)pair.getValue().getPos().m_123341_());
            bonfireCompound.m_128347_("POSY", (double)pair.getValue().getPos().m_123342_());
            bonfireCompound.m_128347_("POSZ", (double)pair.getValue().getPos().m_123343_());
            CompoundTag timeCompound = new CompoundTag();
            timeCompound.m_128356_("SECOND", pair.getValue().getTimeCreated().getEpochSecond());
            timeCompound.m_128405_("NANO", pair.getValue().getTimeCreated().getNano());
            bonfireCompound.m_128365_("TIME", (Tag)timeCompound);
            tagCompound.m_128365_(pair.getKey().toString(), (Tag)bonfireCompound);
        }
        return tagCompound;
    }

    public void readFromNBT(CompoundTag tagCompound, Map<UUID, Bonfire> bonfires) {
        for (String key : tagCompound.m_128431_()) {
            Instant time;
            CompoundTag compound = tagCompound.m_128469_(key);
            String name = compound.m_128461_("NAME");
            UUID id = compound.m_128342_("ID");
            UUID owner = compound.m_128342_("OWNER");
            BlockPos pos = new BlockPos((int)compound.m_128459_("POSX"), (int)compound.m_128459_("POSY"), (int)compound.m_128459_("POSZ"));
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compound.m_128461_("DIM")));
            boolean isPublic = compound.m_128471_("PUBLIC");
            if (compound.m_128425_("TIME", 10)) {
                CompoundTag timeCompound = compound.m_128469_("TIME");
                time = Instant.ofEpochSecond(timeCompound.m_128454_("SECOND"), timeCompound.m_128451_("NANO"));
            } else {
                time = Instant.now();
            }
            Bonfire bonfire = new Bonfire(name, id, owner, pos, (ResourceKey<Level>)dimension, isPublic, time);
            if (this.getBonfireAtPos(pos, (ResourceKey<Level>)dimension) != null) continue;
            bonfires.put(id, bonfire);
        }
    }
}

