/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.blocks;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;
import wehavecookies56.bonfires.BonfiresConfig;
import wehavecookies56.bonfires.bonfire.Bonfire;
import wehavecookies56.bonfires.bonfire.BonfireRegistry;
import wehavecookies56.bonfires.data.BonfireHandler;
import wehavecookies56.bonfires.data.DiscoveryHandler;
import wehavecookies56.bonfires.data.EstusHandler;
import wehavecookies56.bonfires.packets.PacketHandler;
import wehavecookies56.bonfires.packets.client.DeleteScreenshot;
import wehavecookies56.bonfires.packets.client.OpenBonfireGUI;
import wehavecookies56.bonfires.packets.client.OpenCreateScreen;
import wehavecookies56.bonfires.packets.client.SendBonfiresToClient;
import wehavecookies56.bonfires.packets.client.SyncBonfire;
import wehavecookies56.bonfires.packets.client.SyncDiscoveryData;
import wehavecookies56.bonfires.packets.client.SyncEstusData;
import wehavecookies56.bonfires.packets.client.SyncSaveData;
import wehavecookies56.bonfires.packets.server.LightBonfire;
import wehavecookies56.bonfires.setup.BlockSetup;
import wehavecookies56.bonfires.setup.EntitySetup;
import wehavecookies56.bonfires.setup.ItemSetup;
import wehavecookies56.bonfires.tiles.BonfireTileEntity;
import wehavecookies56.bonfires.world.BonfireTeleporter;

public class AshBonePileBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");
    public static final BooleanProperty EXPLODED = BooleanProperty.m_61465_((String)"exploded");

    public AshBonePileBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56746_).m_60955_().m_60978_(0.8f).m_60953_(AshBonePileBlock::getLightValue));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EXPLODED, (Comparable)Boolean.valueOf(false)));
    }

    public float m_7749_(BlockState p_220080_1_, BlockGetter p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EXPLODED, (Comparable)Boolean.valueOf(false));
    }

    public Optional<Vec3> getRespawnPosition(BlockState state, EntityType<?> type, LevelReader world, BlockPos pos, float orientation, @javax.annotation.Nullable LivingEntity entity) {
        return Optional.of(BonfireTeleporter.attemptToPlaceNextToBonfire(pos, (Level)world));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.m_7926_(stateBuilder);
        stateBuilder.m_61104_(new Property[]{FACING, LIT, EXPLODED});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    private void repair(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("Damage")) {
            stack.m_41783_().m_128405_("Damage", 0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof BonfireTileEntity)) return super.m_6227_(state, world, pos, player, hand, hit);
        BonfireTileEntity te = (BonfireTileEntity)blockEntity;
        if (te.isBonfire()) {
            if (!te.isLit()) {
                if (!world.f_46443_) {
                    if (BonfireHandler.getServerHandler(world.m_7654_()).getRegistry().getBonfire(te.getID()) != null) return super.m_6227_(state, world, pos, player, hand, hit);
                    if (te.hasUnlitName()) return InteractionResult.SUCCESS;
                    PacketHandler.sendTo(new OpenCreateScreen(te), (ServerPlayer)player);
                    world.m_7260_(pos, state, state, 2);
                    return InteractionResult.SUCCESS;
                }
                if (!te.hasUnlitName()) return InteractionResult.SUCCESS;
                PacketHandler.sendToServer(new LightBonfire(te.getUnlitName(), te, !te.isUnlitPrivate(), BonfiresConfig.Client.enableAutomaticScreenshotOnCreation));
                return InteractionResult.SUCCESS;
            }
            if (world.f_46443_) return InteractionResult.SUCCESS;
            if (te.hasUnlitName()) {
                te.setUnlitName("");
                return InteractionResult.SUCCESS;
            }
            if (BonfiresConfig.Common.bonfireMonsterCheckRadius > 0.0) {
                Vec3 vec3 = Vec3.m_82539_((Vec3i)new Vec3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
                double r = BonfiresConfig.Common.bonfireMonsterCheckRadius;
                List list = world.m_6443_(Monster.class, new AABB(vec3.m_7096_() - r, vec3.m_7098_() - r, vec3.m_7094_() - r, vec3.m_7096_() + r, vec3.m_7098_() + r, vec3.m_7094_() + r), p_9062_ -> p_9062_.m_6935_(player));
                if (!list.isEmpty()) {
                    player.m_213846_((Component)Component.m_237115_((String)"text.bonfires.enemy_nearby"));
                    return InteractionResult.SUCCESS;
                }
            }
            if (BonfiresConfig.Common.repairEquipment) {
                player.m_150109_().f_35974_.forEach(this::repair);
                player.m_150109_().f_35975_.forEach(this::repair);
                player.m_150109_().f_35976_.forEach(this::repair);
            }
            DiscoveryHandler.IDiscoveryHandler discoveryHandler = DiscoveryHandler.getHandler(player);
            BonfireRegistry registry = BonfireHandler.getServerHandler(world.m_7654_()).getRegistry();
            if (registry.getBonfire(te.getID()).isPublic() || registry.getBonfire(te.getID()).getOwner().equals(player.m_20148_())) {
                discoveryHandler.discover(te.getID());
            }
            if (BonfiresConfig.Common.bonfireDiscoveryMode) {
                registry = registry.getFilteredRegistry(discoveryHandler.getDiscovered().keySet().stream().toList());
            }
            if (registry.getBonfire(te.getID()) != null) {
                for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                    if (ItemStack.m_41656_((ItemStack)player.m_150109_().m_8020_(i), (ItemStack)ItemStack.f_41583_) || player.m_150109_().m_8020_(i).m_41720_() != ItemSetup.estus_flask.get() || !player.m_150109_().m_8020_(i).m_41782_()) continue;
                    player.m_150109_().m_8020_(i).m_41783_().m_128405_("estus", player.m_150109_().m_8020_(i).m_41783_().m_128451_("uses"));
                }
                PacketHandler.sendTo(new OpenBonfireGUI(te, BonfireRegistry.getOwnerNames(world.m_7654_()), registry, BonfiresConfig.Common.enableReinforcing), (ServerPlayer)player);
                player.m_5634_(player.m_21233_());
                if (!BonfiresConfig.Common.disableBonfireRespawn) {
                    ((ServerPlayer)player).m_9158_(te.m_58904_().m_46472_(), te.m_58899_(), player.m_146908_(), false, true);
                }
                EstusHandler.getHandler(player).setLastRested(te.getID());
                PacketHandler.sendTo(new SyncEstusData(EstusHandler.getHandler(player)), (ServerPlayer)player);
                PacketHandler.sendTo(new SyncDiscoveryData(DiscoveryHandler.getHandler(player)), (ServerPlayer)player);
            } else {
                te.setLit(false);
            }
            world.m_7260_(pos, state, state, 2);
            return InteractionResult.SUCCESS;
        }
        if (player.m_21120_(hand) == ItemStack.f_41583_) return super.m_6227_(state, world, pos, player, hand, hit);
        if (player.m_21120_(hand).m_41720_() == ItemSetup.coiled_sword.get()) {
            this.placeItem(world, te, pos, player, hand, BonfireTileEntity.BonfireType.BONFIRE);
        }
        world.m_7260_(pos, state, state, 2);
        return InteractionResult.PASS;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41783_();
        if (compoundtag != null && compoundtag.m_128441_("bonfire_private")) {
            pLevel.m_7731_(pPos, pState, 2);
            BonfireTileEntity te = new BonfireTileEntity(pPos, pState);
            te.setBonfire(true);
            te.setLit(false);
            te.setBonfireType(BonfireTileEntity.BonfireType.BONFIRE);
            if (compoundtag.m_128441_("bonfire_name")) {
                te.setUnlitName(compoundtag.m_128461_("bonfire_name"));
                te.setUnlitPrivate(compoundtag.m_128471_("bonfire_private"));
            }
            pLevel.m_151523_((BlockEntity)te);
        }
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
    }

    public void placeItem(Level world, BonfireTileEntity te, BlockPos pos, Player player, InteractionHand hand, BonfireTileEntity.BonfireType type) {
        if (!world.f_46443_) {
            if (!player.m_7500_()) {
                player.m_21008_(hand, ItemStack.f_41583_);
            }
            world.m_5594_(null, pos, SoundEvents.f_11669_, SoundSource.BLOCKS, 1.0f, 1.0f);
            te.setBonfire(true);
            te.setLit(false);
            te.setBonfireType(type);
            PacketHandler.sendToAll(new SyncBonfire(te.isBonfire(), type, te.isLit(), null, te));
        } else {
            world.m_5594_(player, pos, SoundEvents.f_11669_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static int getLightValue(BlockState state) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            return 8;
        }
        return 0;
    }

    public boolean m_48673_(BlockState p_279289_) {
        return true;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moving) {
        BonfireTileEntity te;
        if (newState.m_60734_() != this && !world.m_5776_() && (te = (BonfireTileEntity)world.m_7702_(pos)) != null) {
            if (te.isBonfire() && !((Boolean)state.m_61143_((Property)EXPLODED)).booleanValue()) {
                ItemEntity fragment = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)ItemSetup.coiled_sword_fragment.get()));
                world.m_7967_((Entity)fragment);
            }
            if (te.isLit()) {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                Bonfire destroyed = BonfireHandler.getServerHandler(server).getRegistry().getBonfire(te.getID());
                te.destroyBonfire(te.getID());
                BonfireHandler.getServerHandler(server).removeBonfire(te.getID());
                PacketHandler.sendToAll(new SyncSaveData(BonfireHandler.getServerHandler(server).getRegistry().getBonfires()));
                if (BonfiresConfig.Common.bonfireDiscoveryMode) {
                    server.m_6846_().m_11314_().forEach(serverPlayer -> PacketHandler.sendTo(new SendBonfiresToClient((ServerPlayer)serverPlayer), serverPlayer));
                } else {
                    PacketHandler.sendToAll(new SendBonfiresToClient());
                }
                PacketHandler.sendToAll(new DeleteScreenshot(te.getID(), destroyed.getName()));
            }
        }
        super.m_6810_(state, world, pos, newState, moving);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        if (BonfiresConfig.Common.enableUBSBonfire && !world.f_46443_) {
            ItemEntity shard = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)ItemSetup.undead_bone_shard.get()));
            world.m_7967_((Entity)shard);
            state = (BlockState)state.m_61124_((Property)EXPLODED, (Comparable)Boolean.valueOf(true));
            world.m_7731_(pos, state, 3);
        }
        super.onBlockExploded(state, world, pos, explosion);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, world, pos, context);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape base = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), (VoxelShape)Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), (BooleanOp)BooleanOp.f_82695_);
        VoxelShape sword = Block.m_49796_((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)20.0, (double)11.0);
        VoxelShape combined = Shapes.m_83113_((VoxelShape)base, (VoxelShape)sword, (BooleanOp)BooleanOp.f_82695_);
        if (world.m_7702_(pos) != null && world.m_7702_(pos) instanceof BonfireTileEntity && ((BonfireTileEntity)world.m_7702_(pos)).isBonfire()) {
            return combined;
        }
        return base;
    }

    public boolean m_49967_() {
        return true;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        BonfireTileEntity bonfire;
        if (world.m_7702_(pos) != null && (bonfire = (BonfireTileEntity)world.m_7702_(pos)).isLit()) {
            double d0 = (double)pos.m_123341_() + 0.5 + random.m_188500_() * 3.0 / 16.0;
            double d1 = (double)pos.m_123342_() + 0.2;
            double d2 = (double)pos.m_123343_() + 0.5 + random.m_188500_() * 1.0 / 16.0;
            double d3 = 0.52;
            double d4 = random.m_188500_() * 0.6 - 0.3;
            double d5 = random.m_188500_() * 0.6 - 0.3;
            ResourceLocation sound = null;
            if (!BonfiresConfig.Client.bonfireAmbientSound.isEmpty()) {
                sound = ResourceLocation.m_135820_((String)BonfiresConfig.Client.bonfireAmbientSound);
            }
            if (sound != null && random.m_188500_() < 0.1) {
                world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, SoundEvent.m_262824_((ResourceLocation)sound), SoundSource.BLOCKS, 0.5f, 1.0f, false);
            }
            if (!BonfiresConfig.Client.disableBonfireParticles) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 + d5, d1, d2 + d4, 0.0, 0.05, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 + d5, d1, d2 + d4, 0.0, 0.0, 0.0);
            }
        }
        super.m_214162_(state, world, pos, random);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BonfireTileEntity) {
            BonfireTileEntity te = (BonfireTileEntity)blockEntity;
            ItemStack stack = new ItemStack((ItemLike)BlockSetup.ash_bone_pile.get());
            if (!player.m_6047_() && te.isBonfire()) {
                stack.m_41751_(new CompoundTag());
                stack.m_41783_().m_128379_("bonfire_private", false);
            } else if (te.isLit()) {
                Bonfire bonfire = BonfireHandler.getServerHandler(ServerLifecycleHooks.getCurrentServer()).getRegistry().getBonfire(te.getID());
                if (bonfire != null) {
                    stack.m_41751_(new CompoundTag());
                    stack.m_41783_().m_128359_("bonfire_name", bonfire.getName());
                    stack.m_41783_().m_128379_("bonfire_private", !bonfire.isPublic());
                }
            } else if (te.hasUnlitName()) {
                stack.m_41751_(new CompoundTag());
                stack.m_41783_().m_128359_("bonfire_name", te.getUnlitName());
                stack.m_41783_().m_128379_("bonfire_private", te.isUnlitPrivate());
            }
            return stack;
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    @javax.annotation.Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)EntitySetup.BONFIRE.get()).m_155264_(pPos, pState);
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        CompoundTag tag;
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
        if (pStack.m_41783_() != null && (tag = pStack.m_41783_()).m_128441_("bonfire_private")) {
            MutableComponent text = Component.m_237115_((String)"tooltip.bonfires.unlit");
            if (tag.m_128441_("bonfire_name")) {
                text.m_130946_(" ");
                text.m_7220_((Component)Component.m_237115_((String)tag.m_128461_("bonfire_name")));
            }
            if (tag.m_128471_("bonfire_private")) {
                text.m_130946_(" ");
                text.m_7220_((Component)Component.m_237115_((String)"text.bonfires.private"));
            }
            pTooltip.add((Component)text);
        }
    }
}

