/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.server.ServerLifecycleHooks;
import wehavecookies56.bonfires.bonfire.Bonfire;
import wehavecookies56.bonfires.data.BonfireHandler;
import wehavecookies56.bonfires.world.BonfireTeleporter;

class TravelCommand {
    public static SuggestionProvider<CommandSourceStack> SUGGEST_BONFIRES = (p_198296_0_, p_198296_1_) -> {
        List<String> list = BonfireHandler.getServerHandler(((CommandSourceStack)p_198296_0_.getSource()).m_81372_().m_7654_()).getRegistry().getBonfires().keySet().stream().map(UUID::toString).toList();
        return SharedSuggestionProvider.m_82981_(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)p_198296_1_);
    };
    public static SuggestionProvider<CommandSourceStack> SUGGEST_PLAYERS = (context, builder) -> EntityArgument.m_91470_().listSuggestions(context, builder);

    TravelCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"travel").requires(commandSource -> commandSource.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"uuid", (ArgumentType)UuidArgument.m_113850_()).suggests(SUGGEST_BONFIRES).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).suggests(SUGGEST_PLAYERS).executes(TravelCommand::executeCommand))).executes(TravelCommand::executeCommand)));
    }

    private static int executeCommand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = new ArrayList<ServerPlayer>();
        if (context.getInput().split(" ").length == 2) {
            targets.add(((CommandSourceStack)context.getSource()).m_81375_());
        } else {
            targets = EntityArgument.m_91477_(context, (String)"targets");
        }
        UUID id = UuidArgument.m_113853_(context, (String)"uuid");
        for (ServerPlayer target : targets) {
            if (BonfireHandler.getServerHandler(ServerLifecycleHooks.getCurrentServer()).getRegistry().getBonfire(id) == null) continue;
            Bonfire bonfire = BonfireHandler.getServerHandler(ServerLifecycleHooks.getCurrentServer()).getRegistry().getBonfire(id);
            BonfireTeleporter.travelToBonfire(target, bonfire.getPos(), bonfire.getDimension());
        }
        return 1;
    }
}

