/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;
import wehavecookies56.bonfires.bonfire.Bonfire;
import wehavecookies56.bonfires.data.BonfireHandler;

public class BonfiresCommand {
    public static SuggestionProvider<CommandSourceStack> SUGGEST_DIMENSIONS = (context, builder) -> {
        List<String> list = ServerLifecycleHooks.getCurrentServer().m_129784_().stream().map(rk -> rk.m_135782_().toString()).toList();
        return SharedSuggestionProvider.m_82981_(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)builder);
    };
    public static SuggestionProvider<CommandSourceStack> SUGGEST_USERNAMES = (context, builder) -> {
        Collection list = ((CommandSourceStack)context.getSource()).m_5982_();
        return SharedSuggestionProvider.m_82981_(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"bonfires").requires(commandSource -> commandSource.m_6761_(2));
        builder.then(Commands.m_82127_((String)"all").executes(context -> BonfiresCommand.executeCommand((CommandContext<CommandSourceStack>)context, "all")));
        builder.then(Commands.m_82127_((String)"dim").then(Commands.m_82129_((String)"dimension", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_DIMENSIONS).executes(context -> BonfiresCommand.executeCommand((CommandContext<CommandSourceStack>)context, "dim"))));
        builder.then(Commands.m_82127_((String)"name").then(Commands.m_82129_((String)"bonfirename", (ArgumentType)StringArgumentType.string()).executes(context -> BonfiresCommand.executeCommand((CommandContext<CommandSourceStack>)context, "name"))));
        builder.then(Commands.m_82127_((String)"owner").then(Commands.m_82129_((String)"ownername", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_USERNAMES).executes(context -> BonfiresCommand.executeCommand((CommandContext<CommandSourceStack>)context, "owner"))));
        builder.then(Commands.m_82127_((String)"radius").then(Commands.m_82129_((String)"searchradius", (ArgumentType)IntegerArgumentType.integer()).executes(context -> BonfiresCommand.executeCommand((CommandContext<CommandSourceStack>)context, "radius"))));
        builder.then(Commands.m_82127_((String)"filters").executes(context -> BonfiresCommand.executeCommand((CommandContext<CommandSourceStack>)context, "filters")));
        dispatcher.register(builder);
    }

    private static int executeCommand(CommandContext<CommandSourceStack> context, String filter) throws CommandSyntaxException {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        switch (filter) {
            case "all": {
                ArrayList<Bonfire> query = new ArrayList<Bonfire>(BonfireHandler.getHandler((Level)((CommandSourceStack)context.getSource()).m_81372_()).getRegistry().getBonfires().values());
                if (query.isEmpty()) {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.bonfires.nomatch", (Object[])new Object[]{"all"}), false);
                    break;
                }
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.bonfires.match", (Object[])new Object[]{query.size(), "all"}), false);
                BonfiresCommand.listQueriedBonfires(query, (CommandSourceStack)context.getSource());
                break;
            }
            case "dim": {
                String input = StringArgumentType.getString(context, (String)"dimension");
                if (input.contains(":")) {
                    ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(input));
                    if (ServerLifecycleHooks.getCurrentServer().m_129784_().contains(dimensionKey)) {
                        List<Bonfire> query = BonfireHandler.getHandler((Level)((CommandSourceStack)context.getSource()).m_81372_()).getRegistry().getBonfiresByDimension(dimensionKey.m_135782_());
                        if (query.isEmpty()) {
                            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.bonfires.dim.nomatch", (Object[])new Object[]{input}), false);
                            break;
                        }
                        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.bonfires.dim.match", (Object[])new Object[]{query.size(), input}), false);
                        BonfiresCommand.listQueriedBonfires(query, (CommandSourceStack)context.getSource());
                        break;
                    }
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"command.bonfires.dim.nodim", (Object[])new Object[]{input}));
                    break;
                }
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"command.bonfires.dim.invalid", (Object[])new Object[]{input}));
                break;
            }
            case "name": {
                String input = StringArgumentType.getString(context, (String)"bonfirename");
                List<Bonfire> query = BonfireHandler.getHandler((Level)((CommandSourceStack)context.getSource()).m_81372_()).getRegistry().getBonfiresByName(input);
                if (query.isEmpty()) {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.bonfires.nomatch", (Object[])new Object[]{input}), false);
                    break;
                }
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.bonfires.match", (Object[])new Object[]{query.size(), input}), false);
                BonfiresCommand.listQueriedBonfires(query, (CommandSourceStack)context.getSource());
                break;
            }
            case "owner": {
                String input = StringArgumentType.getString(context, (String)"ownername");
                GameProfile ownerProfile = ServerLifecycleHooks.getCurrentServer().m_129927_().m_10996_(input).orElse(null);
                if (ownerProfile == null) break;
                UUID ownerID = ownerProfile.getId();
                if (ownerID != null) {
                    List<Bonfire> query = BonfireHandler.getHandler((Level)((CommandSourceStack)context.getSource()).m_81372_()).getRegistry().getBonfiresByOwner(ownerID);
                    if (query.isEmpty()) {
                        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.bonfires.nomatch", (Object[])new Object[]{input}), false);
                        break;
                    }
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.bonfires.match", (Object[])new Object[]{query.size(), input}), false);
                    BonfiresCommand.listQueriedBonfires(query, (CommandSourceStack)context.getSource());
                    break;
                }
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.bonfires.nouser", (Object[])new Object[]{input}), false);
                break;
            }
            case "radius": {
                int radius = IntegerArgumentType.getInteger(context, (String)"searchradius");
                List<Bonfire> query = BonfireHandler.getHandler((Level)((CommandSourceStack)context.getSource()).m_81372_()).getRegistry().getBonfiresInRadius(new BlockPos((int)((CommandSourceStack)context.getSource()).m_81371_().f_82479_, (int)((CommandSourceStack)context.getSource()).m_81371_().f_82480_, (int)((CommandSourceStack)context.getSource()).m_81371_().f_82481_), radius, ((CommandSourceStack)context.getSource()).m_81372_().m_46472_().m_135782_());
                if (query.isEmpty()) {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.bonfires.radius.nomatch", (Object[])new Object[]{radius}), false);
                    break;
                }
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.bonfires.radius.match", (Object[])new Object[]{query.size(), radius}), false);
                BonfiresCommand.listQueriedBonfires(query, (CommandSourceStack)context.getSource());
                break;
            }
            case "filters": {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.bonfires.all.desc", (Object[])new Object[]{"all"}), false);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.bonfires.dim.desc", (Object[])new Object[]{"dim"}), false);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.bonfires.name.desc", (Object[])new Object[]{"name"}), false);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.bonfires.owner.desc", (Object[])new Object[]{"owner"}), false);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.bonfires.radius.desc", (Object[])new Object[]{"radius"}), false);
                break;
            }
            default: {
                return 0;
            }
        }
        return 1;
    }

    private static void listQueriedBonfires(List<Bonfire> query, CommandSourceStack sender) {
        query.forEach(bonfires -> {
            GameProfile owner = ServerLifecycleHooks.getCurrentServer().m_129927_().m_11002_(bonfires.getOwner()).orElse(null);
            String name = Component.m_237115_((String)"command.bonfires.na").getString();
            if (owner != null) {
                name = owner.getName();
            }
            MutableComponent messageName = Component.m_237110_((String)"command.bonfires.name", (Object[])new Object[]{bonfires.getName()}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, bonfires.getName())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.copy.click"))));
            MutableComponent messageID = Component.m_237110_((String)"command.bonfires.id", (Object[])new Object[]{bonfires.getId()}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, bonfires.getId().toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.copy.click"))));
            String finalName = name;
            MutableComponent messageOwner = Component.m_237110_((String)"command.bonfires.owner", (Object[])new Object[]{name}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, finalName)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.copy.click"))));
            MutableComponent messagePos = Component.m_237110_((String)"command.bonfires.pos", (Object[])new Object[]{bonfires.getPos().m_123341_(), bonfires.getPos().m_123342_(), bonfires.getPos().m_123343_()}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, bonfires.getPos().m_123341_() + " " + bonfires.getPos().m_123342_() + " " + bonfires.getPos().m_123343_())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.copy.click"))));
            MutableComponent space = Component.m_237113_((String)" ");
            sender.m_288197_(() -> BonfiresCommand.lambda$listQueriedBonfires$30(messageName, (Component)space, messageID, messageOwner, messagePos), false);
        });
    }

    private static /* synthetic */ Component lambda$listQueriedBonfires$30(MutableComponent messageName, Component space, MutableComponent messageID, MutableComponent messageOwner, MutableComponent messagePos) {
        return messageName.m_7220_(space).m_7220_((Component)messageID).m_7220_(space).m_7220_((Component)messageOwner).m_7220_(space).m_7220_((Component)messagePos);
    }
}

