/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires;

import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wehavecookies56.bonfires.BonfiresCommand;
import wehavecookies56.bonfires.BonfiresConfig;
import wehavecookies56.bonfires.TravelCommand;
import wehavecookies56.bonfires.bonfire.Bonfire;
import wehavecookies56.bonfires.bonfire.BonfireRegistry;
import wehavecookies56.bonfires.data.BonfireHandler;
import wehavecookies56.bonfires.data.DiscoveryHandler;
import wehavecookies56.bonfires.data.EstusHandler;
import wehavecookies56.bonfires.data.ReinforceHandler;
import wehavecookies56.bonfires.packets.PacketHandler;
import wehavecookies56.bonfires.packets.client.SyncDiscoveryData;
import wehavecookies56.bonfires.packets.client.SyncEstusData;
import wehavecookies56.bonfires.packets.client.SyncSaveData;
import wehavecookies56.bonfires.setup.BlockSetup;
import wehavecookies56.bonfires.setup.CommonSetup;
import wehavecookies56.bonfires.setup.CreativeTabSetup;
import wehavecookies56.bonfires.setup.EntitySetup;
import wehavecookies56.bonfires.setup.ItemSetup;

@Mod(value="bonfires")
public class Bonfires {
    public static Logger LOGGER = LogManager.getLogger();
    public static final String modid = "bonfires";
    public static final UUID reinforceDamageModifier = UUID.fromString("117e876c-c9bd-4898-985a-2ecb24198350");

    public Bonfires() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BlockSetup.BLOCKS.register(modEventBus);
        ItemSetup.ITEMS.register(modEventBus);
        EntitySetup.TILE_ENTITIES.register(modEventBus);
        CreativeTabSetup.TABS.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)BonfiresConfig.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BonfiresConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)BonfiresConfig.SERVER_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)new CommonSetup());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void entityDeath(LivingDropsEvent event) {
        Random r;
        double percent;
        if (!BonfiresConfig.Common.disableAshDrops && (event.getSource().m_276093_(DamageTypes.f_268631_) || event.getEntity().m_6060_() || event.getSource().m_7639_() instanceof Player && ((Player)event.getSource().m_7639_()).m_21205_().m_41720_() == ItemSetup.coiled_sword.get()) && (percent = (r = new Random()).nextDouble() * 100.0) > 65.0) {
            event.getDrops().add(new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), new ItemStack((ItemLike)ItemSetup.ash_pile.get())));
        }
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getLevel().f_46443_ && (entity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PacketHandler.sendTo(new SyncSaveData(BonfireHandler.getServerHandler(event.getLevel().m_7654_()).getRegistry().getBonfires()), player);
            PacketHandler.sendTo(new SyncEstusData(EstusHandler.getHandler((Player)player)), player);
            PacketHandler.sendTo(new SyncDiscoveryData(DiscoveryHandler.getHandler((Player)player)), player);
            if (DiscoveryHandler.getHandler((Player)player).getDiscovered().isEmpty()) {
                BonfireRegistry registry = BonfireHandler.getServerHandler(event.getLevel().m_7654_()).getRegistry();
                DiscoveryHandler.IDiscoveryHandler discoveryHandler = DiscoveryHandler.getHandler((Player)player);
                List<Bonfire> bonfires = registry.getBonfiresByOwner(player.m_20148_());
                bonfires.forEach(bonfire -> discoveryHandler.setDiscovered(bonfire.getId(), bonfire.getTimeCreated()));
            }
        }
    }

    @SubscribeEvent
    public void changeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getEntity().m_9236_().f_46443_) {
            PacketHandler.sendTo(new SyncSaveData(BonfireHandler.getServerHandler(event.getEntity().m_20194_()).getRegistry().getBonfires()), (ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public void modifyAttributes(ItemAttributeModifierEvent event) {
        ReinforceHandler.ReinforceLevel rlevel;
        if (event.getSlotType() == EquipmentSlot.MAINHAND && event.getItemStack().m_41720_() != ItemSetup.estus_flask.get() && ReinforceHandler.canReinforce(event.getItemStack()) && (rlevel = ReinforceHandler.getReinforceLevel(event.getItemStack())) != null && rlevel.level() != 0) {
            event.addModifier(Attributes.f_22281_, new AttributeModifier(reinforceDamageModifier, "reinforce_damagebonus", BonfiresConfig.Server.reinforceDamagePerLevel * (double)rlevel.level(), AttributeModifier.Operation.ADDITION));
        }
    }

    @SubscribeEvent
    public void respawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.isEndConquered()) {
            event.getEntity().m_150109_().f_35974_.forEach(stack -> {
                if (stack.m_150930_((Item)ItemSetup.estus_flask.get()) && stack.m_41783_() != null) {
                    stack.m_41783_().m_128405_("estus", stack.m_41783_().m_128451_("uses"));
                }
            });
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        BonfiresCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        TravelCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }
}

