/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.entity.custom;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.entity.RuEntities;
import net.regions_unexplored.item.RuItems;
import org.jetbrains.annotations.NotNull;

public class RuBoat
extends Boat {
    public RuBoat(EntityType<? extends RuBoat> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
    }

    public RuBoat(Level level, double x, double y, double z) {
        this((EntityType<? extends RuBoat>)((EntityType)RuEntities.BOAT.get()), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public double m_6048_() {
        return -0.1;
    }

    @NotNull
    public Item m_38369_() {
        return switch (ModelType.byId((Integer)this.f_19804_.m_135370_(f_38285_))) {
            case ModelType.BLACKWOOD -> (Item)RuItems.BLACKWOOD_BOAT.get();
            case ModelType.CYPRESS -> (Item)RuItems.CYPRESS_BOAT.get();
            case ModelType.DEAD -> (Item)RuItems.DEAD_BOAT.get();
            case ModelType.EUCALYPTUS -> (Item)RuItems.EUCALYPTUS_BOAT.get();
            case ModelType.JOSHUA -> (Item)RuItems.JOSHUA_BOAT.get();
            case ModelType.KAPOK -> (Item)RuItems.KAPOK_BOAT.get();
            case ModelType.LARCH -> (Item)RuItems.LARCH_BOAT.get();
            case ModelType.MAGNOLIA -> (Item)RuItems.MAGNOLIA_BOAT.get();
            case ModelType.MAPLE -> (Item)RuItems.MAPLE_BOAT.get();
            case ModelType.MAUVE -> (Item)RuItems.MAUVE_BOAT.get();
            case ModelType.PALM -> (Item)RuItems.PALM_BOAT.get();
            case ModelType.PINE -> (Item)RuItems.PINE_BOAT.get();
            case ModelType.REDWOOD -> (Item)RuItems.REDWOOD_BOAT.get();
            case ModelType.SOCOTRA -> (Item)RuItems.SOCOTRA_BOAT.get();
            case ModelType.WILLOW -> (Item)RuItems.WILLOW_BOAT.get();
            default -> (Item)RuItems.BAOBAB_BOAT.get();
        };
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128359_("model", this.getModel().getName());
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128425_("model", 8)) {
            this.f_19804_.m_135381_(f_38285_, (Object)ModelType.byName(tag.m_128461_("model")).ordinal());
        }
    }

    protected void m_7840_(double distance, boolean onLand, BlockState state, BlockPos pos) {
        this.f_38281_ = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            if (onLand) {
                if (this.f_19789_ > 3.0f) {
                    if (this.f_38279_ != Boat.Status.ON_LAND) {
                        this.m_183634_();
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, this.m_269291_().m_268989_());
                    if (!this.f_19853_.f_46443_ && !this.m_213877_()) {
                        this.m_6074_();
                        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            for (int i = 0; i < 3; ++i) {
                                this.m_19998_((ItemLike)this.m_28554_().m_38434_());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.m_19998_((ItemLike)Items.f_42398_);
                            }
                        }
                    }
                }
                this.m_183634_();
            } else if (!this.canBoatInFluid(this.f_19853_.m_6425_(this.m_20183_().m_7495_())) && distance < 0.0) {
                this.f_19789_ -= (float)distance;
            }
        }
    }

    public void setModel(ModelType model) {
        this.f_19804_.m_135381_(f_38285_, (Object)model.ordinal());
    }

    public ModelType getModel() {
        return ModelType.byId((Integer)this.f_19804_.m_135370_(f_38285_));
    }

    @Deprecated
    public void m_28464_(Boat.Type type) {
        this.f_19804_.m_135381_(f_38285_, (Object)type.ordinal());
    }

    @Deprecated
    public Boat.Type m_28554_() {
        return Boat.Type.m_38430_((int)((Integer)this.f_19804_.m_135370_(f_38285_)));
    }

    public static enum ModelType {
        BAOBAB("baobab", (Block)RuBlocks.BAOBAB_PLANKS.get()),
        BLACKWOOD("blackwood", (Block)RuBlocks.BLACKWOOD_PLANKS.get()),
        MAGNOLIA("magnolia", (Block)RuBlocks.MAGNOLIA_PLANKS.get()),
        CYPRESS("cypress", (Block)RuBlocks.CYPRESS_PLANKS.get()),
        DEAD("dead", (Block)RuBlocks.DEAD_PLANKS.get()),
        EUCALYPTUS("eucalyptus", (Block)RuBlocks.EUCALYPTUS_PLANKS.get()),
        JOSHUA("joshua", (Block)RuBlocks.JOSHUA_PLANKS.get()),
        KAPOK("kapok", (Block)RuBlocks.KAPOK_PLANKS.get()),
        LARCH("larch", (Block)RuBlocks.LARCH_PLANKS.get()),
        MAPLE("maple", (Block)RuBlocks.MAPLE_PLANKS.get()),
        MAUVE("mauve", (Block)RuBlocks.MAUVE_PLANKS.get()),
        PALM("palm", (Block)RuBlocks.PALM_PLANKS.get()),
        PINE("pine", (Block)RuBlocks.PINE_PLANKS.get()),
        REDWOOD("redwood", (Block)RuBlocks.REDWOOD_PLANKS.get()),
        SOCOTRA("socotra", (Block)RuBlocks.SOCOTRA_PLANKS.get()),
        WILLOW("willow", (Block)RuBlocks.WILLOW_PLANKS.get());

        private final String name;
        private final Block planks;

        private ModelType(String name, Block planks) {
            this.name = name;
            this.planks = planks;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static ModelType byId(int id) {
            ModelType[] modelType = ModelType.values();
            if (id < 0 || id >= modelType.length) {
                return modelType[0];
            }
            return modelType[id];
        }

        public static ModelType byName(String name) {
            ModelType[] modelType = ModelType.values();
            return Arrays.stream(modelType).filter(t -> t.getName().equals(name)).findFirst().orElse(modelType[0]);
        }
    }
}

