/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdm_economy.forge;

import dev.architectury.platform.Platform;
import dev.architectury.platform.forge.EventBuses;
import java.math.BigDecimal;
import net.impactdev.impactor.api.economy.EconomyService;
import net.impactdev.impactor.api.economy.accounts.Account;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.sixik.sdm_economy.SDMEconomy;
import net.sixik.sdm_economy.adv.PlayerMoneyData;
import net.sixik.sdm_economy.api.IOtherCurrency;
import net.sixik.sdm_economy.common.cap.MoneyData;

@Mod(value="sdm_economy")
public class SDMEconomyForge {
    public SDMEconomyForge() {
        EventBuses.registerModEventBus((String)"sdm_economy", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        SDMEconomy.init();
        this.integrationWithOtherEconomy();
    }

    public void integrationWithOtherEconomy() {
        PlayerMoneyData.isImpactorLoaded = Platform.isModLoaded((String)"impactor");
        if (PlayerMoneyData.isImpactorLoaded) {
            PlayerMoneyData.OTHER_CURRENCY_MOD = new IOtherCurrency(){

                @Override
                public void addMoney(Player player, String id, long amount) {
                    EconomyService.instance().account(EconomyService.instance().currencies().primary(), player.m_20148_()).thenAccept(account -> {
                        BigDecimal balance = account.balance();
                        account.set(balance.add(new BigDecimal(amount)));
                    });
                }

                @Override
                public void setMoney(Player player, String id, long amount) {
                    EconomyService.instance().account(EconomyService.instance().currencies().primary(), player.m_20148_()).thenAccept(account -> account.set(new BigDecimal(amount)));
                }

                @Override
                public long getMoney(Player player, String id) {
                    try {
                        Account d1 = (Account)EconomyService.instance().account(EconomyService.instance().currencies().primary(), player.m_20148_()).join();
                        return d1.balance().longValue();
                    }
                    catch (Exception e) {
                        SDMEconomy.printStackTrace("", e);
                        return 0L;
                    }
                }

                @Override
                public void updateMoneyData(Player player, MoneyData data) {
                    data.currencies.clear();
                    try {
                        Account d1 = (Account)EconomyService.instance().account(EconomyService.instance().currencies().primary(), player.m_20148_()).join();
                        data.setMoney("basic_money", d1.balance().longValue());
                    }
                    catch (Exception e) {
                        SDMEconomy.printStackTrace("", e);
                    }
                }

                @Override
                public String getModID() {
                    return "impactor";
                }
            };
            return;
        }
    }
}

