/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdm_economy.common.cap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.sixik.sdm_economy.common.currency.AbstractCurrency;
import net.sixik.sdm_economy.common.currency.CurrencyRegister;

public class MoneyData {
    public boolean isOtherMod = false;
    public String otherModId = "sdm_economy";
    public long moneyBase = 0L;
    public List<AbstractCurrency> currencies = new ArrayList<AbstractCurrency>();

    public List<AbstractCurrency> getCurrencies() {
        return this.currencies;
    }

    public void copyFrom(MoneyData data) {
        this.currencies = data.currencies;
        this.moneyBase = data.moneyBase;
    }

    public void loadAllCurrencies() {
        this.currencies.removeIf(currency -> !CurrencyRegister.CURRENCIES.containsKey(currency.getID()));
        List<String> c = this.currencies.stream().map(AbstractCurrency::getID).toList();
        for (Map.Entry<String, AbstractCurrency.Constructor<?>> stringConstructorEntry : CurrencyRegister.CURRENCIES.entrySet()) {
            if (c.contains(stringConstructorEntry.getKey())) continue;
            this.currencies.add((AbstractCurrency)stringConstructorEntry.getValue().createDefault());
        }
    }

    public boolean addMoney(String id, long money) {
        for (AbstractCurrency currency : this.getCurrencies()) {
            if (!Objects.equals(currency.getID(), id)) continue;
            currency.moneys += money;
            return true;
        }
        return false;
    }

    public boolean addMoney(long money) {
        this.moneyBase += money;
        return true;
    }

    public boolean setMoney(String id, long money) {
        for (AbstractCurrency currency : this.getCurrencies()) {
            if (!Objects.equals(currency.getID(), id)) continue;
            currency.moneys = money;
            return true;
        }
        return false;
    }

    public boolean setMoney(long money) {
        this.moneyBase = money;
        return true;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag tags = new ListTag();
        for (AbstractCurrency currency : this.currencies) {
            tags.add((Object)currency.serializeNBT());
        }
        nbt.m_128365_("currencies", (Tag)tags);
        nbt.m_128359_("otherModId", this.otherModId);
        nbt.m_128379_("isOtherMod", this.isOtherMod);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("isOtherMod")) {
            this.isOtherMod = nbt.m_128471_("isOtherMod");
        }
        if (nbt.m_128441_("otherModId")) {
            this.otherModId = nbt.m_128461_("otherModId");
        }
        ListTag tags = (ListTag)nbt.m_128423_("currencies");
        this.currencies.clear();
        assert (tags != null);
        for (Tag tag : tags) {
            CompoundTag d1 = (CompoundTag)tag;
            if (!d1.m_128441_("currencyID")) continue;
            String currencyID = d1.m_128461_("currencyID");
            Object currency = CurrencyRegister.CURRENCIES.get(currencyID).createDefault();
            ((AbstractCurrency)currency).deserializeNBT(d1);
            this.currencies.add((AbstractCurrency)currency);
        }
    }
}

