/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdm_economy.api;

import java.util.List;
import java.util.Objects;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.sixik.sdm_economy.adv.PlayerMoneyData;
import net.sixik.sdm_economy.common.cap.MoneyData;
import net.sixik.sdm_economy.common.currency.AbstractCurrency;
import net.sixik.sdm_economy.common.currency.CurrencyRegister;
import net.sixik.sdm_economy.network.adv.UpdateClientDataS2C;

public class CurrencyHelper {
    public static void addMoney(Player player, String id, long amount) {
        CurrencyHelper.setMoney(player, id, CurrencyHelper.getMoney(player, id) + amount);
    }

    public static void setMoney(Player player, String id, long amount) {
        if (player.m_7578_()) {
            PlayerMoneyData.CLIENT.CLIENT_MONET.setMoney(id, amount);
        } else {
            MoneyData data = PlayerMoneyData.from((ServerPlayer)player);
            if (PlayerMoneyData.OTHER_CURRENCY_MOD != null) {
                PlayerMoneyData.OTHER_CURRENCY_MOD.setMoney(player, id, amount);
                PlayerMoneyData.OTHER_CURRENCY_MOD.updateMoneyData(player, data);
            } else {
                data.setMoney(id, amount);
            }
            new UpdateClientDataS2C(data.serializeNBT()).sendTo((ServerPlayer)player);
        }
    }

    public static long getMoney(Player player, String id) {
        if (PlayerMoneyData.OTHER_CURRENCY_MOD != null) {
            return PlayerMoneyData.OTHER_CURRENCY_MOD.getMoney(player, id);
        }
        for (AbstractCurrency currency : CurrencyHelper.getPlayerData((Player)player).currencies) {
            if (!Objects.equals(currency.getID(), id)) continue;
            return currency.moneys;
        }
        return 0L;
    }

    public static MoneyData getPlayerData(Player player) {
        if (player.m_7578_()) {
            return PlayerMoneyData.CLIENT.CLIENT_MONET;
        }
        return PlayerMoneyData.from((ServerPlayer)player);
    }

    public static boolean convertMoney(Player player, String from, String to, long count) {
        for (AbstractCurrency currency : CurrencyHelper.getPlayerData(player).getCurrencies()) {
            long d;
            if (!Objects.equals(currency.getID(), from) || !currency.conversions.containsKey(to) || currency.moneys < (d = currency.conversions.get(to).longValue()) * count) continue;
            CurrencyHelper.setMoney(player, from, currency.moneys - d * count);
            CurrencyHelper.setMoney(player, to, count);
            return true;
        }
        return false;
    }

    public static List<String> getAllCurrencyKeys() {
        return CurrencyRegister.CURRENCIES.keySet().stream().toList();
    }

    public static AbstractCurrency.Constructor<?> registerBasicCurrency(final String id, long defaultValue) {
        return CurrencyRegister.register(() -> new AbstractCurrency(defaultValue){

            @Override
            public String getID() {
                return id;
            }
        });
    }

    public static class Basic {
        public static void addMoney(Player player, long count) {
            CurrencyHelper.addMoney(player, "basic_money", count);
        }

        public static void setMoney(Player player, long count) {
            CurrencyHelper.setMoney(player, "basic_money", count);
        }

        public static long getMoney(Player player) {
            return CurrencyHelper.getMoney(player, "basic_money");
        }
    }
}

