/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdm_economy.adv;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.sixik.sdm_economy.SDMEconomy;
import net.sixik.sdm_economy.api.IOtherCurrency;
import net.sixik.sdm_economy.common.cap.MoneyData;
import net.sixik.sdm_economy.network.adv.UpdateClientDataS2C;
import org.apache.commons.io.FilenameUtils;

public class PlayerMoneyData {
    public static boolean isImpactorLoaded = false;
    public static IOtherCurrency OTHER_CURRENCY_MOD = null;
    public static String folderName = "SDMEconomy";
    public static PlayerMoneyData CLIENT = new PlayerMoneyData();
    public static PlayerMoneyData SERVER;
    public MoneyData CLIENT_MONET = new MoneyData();
    public Map<UUID, MoneyData> PLAYER_MONEY = new HashMap<UUID, MoneyData>();

    public static MoneyData from(ServerPlayer player) {
        if (PlayerMoneyData.SERVER.PLAYER_MONEY.containsKey(player.m_36316_().getId())) {
            MoneyData data = PlayerMoneyData.SERVER.PLAYER_MONEY.get(player.m_36316_().getId());
            if (data.isOtherMod) {
                if (OTHER_CURRENCY_MOD != null) {
                    data.otherModId = OTHER_CURRENCY_MOD.getModID();
                    OTHER_CURRENCY_MOD.updateMoneyData((Player)player, data);
                } else {
                    data.isOtherMod = false;
                    data.loadAllCurrencies();
                }
            }
            return data;
        }
        MoneyData data = new MoneyData();
        if (OTHER_CURRENCY_MOD != null) {
            data.isOtherMod = true;
            data.otherModId = OTHER_CURRENCY_MOD.getModID();
            OTHER_CURRENCY_MOD.updateMoneyData((Player)player, data);
        } else {
            data.loadAllCurrencies();
        }
        PlayerMoneyData.SERVER.PLAYER_MONEY.put(player.m_36316_().getId(), data);
        return PlayerMoneyData.SERVER.PLAYER_MONEY.get(player.m_36316_().getId());
    }

    public static void onPlayerLoggedIn(ServerPlayer player) {
        PlayerMoneyData.from(player);
        new UpdateClientDataS2C(SERVER.saveToNBT((Player)player)).sendTo(player);
        PlayerMoneyData.savePlayer(player.m_36316_().getId(), player.f_8924_);
    }

    public static void onPlayerLoggedOut(ServerPlayer player) {
        if (PlayerMoneyData.SERVER.PLAYER_MONEY.containsKey(player.m_36316_().getId())) {
            PlayerMoneyData.savePlayer(player.m_36316_().getId(), player.f_8924_);
        }
    }

    public static void load(MinecraftServer server) {
        if (SERVER == null) {
            SERVER = new PlayerMoneyData();
        }
        PlayerMoneyData.CLIENT.CLIENT_MONET = new MoneyData();
        PlayerMoneyData.CLIENT.PLAYER_MONEY.clear();
        PlayerMoneyData.SERVER.CLIENT_MONET = new MoneyData();
        PlayerMoneyData.SERVER.PLAYER_MONEY.clear();
        Path path = server.m_129843_(LevelResource.f_78182_).resolve(folderName);
        if (!path.toFile().exists()) {
            path.toFile().mkdir();
            return;
        }
        try {
            for (File file : path.toFile().listFiles()) {
                UUID uuid = UUID.fromString(FilenameUtils.removeExtension((String)file.getName()));
                CompoundTag nbt = NbtIo.m_128953_((File)file);
                if (nbt == null) continue;
                MoneyData moneyData = new MoneyData();
                moneyData.deserializeNBT(nbt);
                PlayerMoneyData.SERVER.PLAYER_MONEY.put(uuid, moneyData);
            }
        }
        catch (Exception e) {
            SDMEconomy.printStackTrace("", e);
        }
    }

    public static void save(MinecraftServer server) {
        if (SERVER == null) {
            return;
        }
        Path path = server.m_129843_(LevelResource.f_78182_).resolve(folderName);
        if (!path.toFile().exists()) {
            path.toFile().mkdir();
        }
        for (UUID uuid : PlayerMoneyData.SERVER.PLAYER_MONEY.keySet()) {
            PlayerMoneyData.savePlayer(uuid, path);
        }
    }

    public void replacePlayerData(UUID old, UUID newPlayer, MinecraftServer server) {
        MoneyData data = PlayerMoneyData.SERVER.PLAYER_MONEY.get(old);
        if (PlayerMoneyData.SERVER.PLAYER_MONEY.containsKey(old)) {
            PlayerMoneyData.SERVER.PLAYER_MONEY.remove(old);
            PlayerMoneyData.SERVER.PLAYER_MONEY.put(newPlayer, data);
            PlayerMoneyData.savePlayer(newPlayer, server);
        }
    }

    public void deleteOldFile(UUID uuid, MinecraftServer server) {
        Path path = server.m_129843_(LevelResource.f_78182_).resolve(folderName);
        if (!path.toFile().exists()) {
            path.toFile().mkdir();
        }
        if (PlayerMoneyData.SERVER.PLAYER_MONEY.containsKey(uuid)) {
            PlayerMoneyData.SERVER.PLAYER_MONEY.remove(uuid);
        }
        if ((path = path.resolve(uuid.toString() + ".data")).toFile().exists()) {
            path.toFile().delete();
        }
    }

    public static void savePlayer(UUID player, MinecraftServer server) {
        Path path = server.m_129843_(LevelResource.f_78182_).resolve(folderName);
        if (!path.toFile().exists()) {
            path.toFile().mkdir();
        }
        PlayerMoneyData.savePlayer(player, path);
    }

    public static void savePlayer(UUID player, Path path) {
        try {
            if (!PlayerMoneyData.SERVER.PLAYER_MONEY.containsKey(player)) {
                return;
            }
            Path f1 = path.resolve(player.toString() + ".data");
            if (!f1.toFile().exists()) {
                f1.toFile().createNewFile();
            }
            NbtIo.m_128955_((CompoundTag)PlayerMoneyData.SERVER.PLAYER_MONEY.get(player).serializeNBT(), (File)f1.toFile());
        }
        catch (Exception e) {
            SDMEconomy.printStackTrace("", e);
        }
    }

    public static void loadFromNBTClient(CompoundTag nbt) {
        PlayerMoneyData.CLIENT.CLIENT_MONET.deserializeNBT(nbt);
    }

    public void loadFromNBT(Player player, CompoundTag nbt) {
        if (!this.PLAYER_MONEY.containsKey(player.m_36316_().getId())) {
            MoneyData data = new MoneyData();
            data.deserializeNBT(nbt);
            this.PLAYER_MONEY.put(player.m_36316_().getId(), data);
        }
        this.PLAYER_MONEY.get(player.m_36316_().getId()).deserializeNBT(nbt);
    }

    public CompoundTag saveToNBT(Player player) {
        if (!this.PLAYER_MONEY.containsKey(player.m_36316_().getId())) {
            MoneyData data = new MoneyData();
            data.loadAllCurrencies();
            this.PLAYER_MONEY.put(player.m_36316_().getId(), data);
        }
        return this.PLAYER_MONEY.get(player.m_36316_().getId()).serializeNBT();
    }
}

