/*
 * Decompiled with CFR 0.152.
 */
package com.ezzenix.chatanimation.mixin;

import com.ezzenix.chatanimation.config.ModConfig;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MessageSignature;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChatComponent.class})
public class ChatComponentMixin {
    @Shadow
    private int f_93763_;
    @Unique
    private long lastMessageTime = 0L;

    @Shadow
    private int m_240691_() {
        return 0;
    }

    @Unique
    private float calculateDisplacement() {
        if (!ModConfig.getConfig().enableMessageAnimation || this.f_93763_ != 0) {
            return 0.0f;
        }
        float fadeTime = ModConfig.getConfig().fadeTimeMessage;
        int lineHeight = this.m_240691_();
        float fadeOffsetYScale = 0.8f;
        float maxDisplacement = (float)lineHeight * fadeOffsetYScale;
        long lifetime = System.currentTimeMillis() - this.lastMessageTime;
        float alpha = Math.min((float)lifetime / fadeTime, 1.0f);
        return maxDisplacement - alpha * maxDisplacement;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void onRenderStart(GuiGraphics context, int tickCount, int mouseX, int mouseY, CallbackInfo ci) {
        float displacement = this.calculateDisplacement();
        context.m_280168_().m_85836_();
        context.m_280168_().m_252880_(0.0f, displacement, 0.0f);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRenderEnd(GuiGraphics context, int tickCount, int mouseX, int mouseY, CallbackInfo ci) {
        context.m_280168_().m_85849_();
    }

    @Inject(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;Lnet/minecraft/client/GuiMessageTag;)V"}, at={@At(value="TAIL")})
    private void addMessage(Component chatComponent, MessageSignature headerSignature, GuiMessageTag tag, CallbackInfo ci) {
        this.lastMessageTime = System.currentTimeMillis();
    }
}

