/*
 * Decompiled with CFR 0.152.
 */
package com.ezzenix.chatanimation.config;

import com.ezzenix.chatanimation.config.ModConfig;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ModConfigScreen
extends Screen {
    Screen parentScreen;
    ModConfig config;

    public ModConfigScreen(Screen parentScreen) {
        super((Component)Component.m_237113_((String)"Settings"));
        this.parentScreen = parentScreen;
        this.config = ModConfig.getConfig();
    }

    public static Screen create(Screen parentScreen) {
        return new ModConfigScreen(parentScreen);
    }

    protected void m_7856_() {
        int buttonWidth = 140;
        int buttonHeight = 20;
        int x = this.f_96543_ / 2 - buttonWidth / 2;
        int y = this.f_96544_ / 2 - buttonHeight / 2 - 75;
        int spacingX = 80;
        int spacingY = 25;
        this.addToggleOption(x - spacingX, y, buttonWidth, buttonHeight, "Animate Messages", () -> this.config.enableMessageAnimation, val -> {
            this.config.enableMessageAnimation = val;
        });
        this.addSliderOption(x - spacingX, y + spacingY, buttonWidth, buttonHeight, "Duration", 10, 300, () -> this.config.fadeTimeMessage, val -> {
            this.config.fadeTimeMessage = val;
        });
        this.addToggleOption(x - spacingX, y + spacingY * 2, buttonWidth, buttonHeight, "Hide Indicator", () -> this.config.removeMessageIndicator, val -> {
            this.config.removeMessageIndicator = val;
        });
        this.addToggleOption(x + spacingX, y, buttonWidth, buttonHeight, "Animate Open", () -> this.config.enableTextFieldAnimation, val -> {
            this.config.enableTextFieldAnimation = val;
        });
        this.addSliderOption(x + spacingX, y + spacingY, buttonWidth, buttonHeight, "Duration", 10, 700, () -> this.config.fadeTimeTextField, val -> {
            this.config.fadeTimeTextField = val;
        });
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Reset").m_130940_(ChatFormatting.RED), button -> {
            this.config.reset();
            this.m_169413_();
            this.m_7856_();
        }).m_252987_(x - spacingX, y + spacingY * 5, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Done"), button -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(null);
            }
        }).m_252987_(x + spacingX, y + spacingY * 5, buttonWidth, buttonHeight).m_253136_());
    }

    private void addToggleOption(int x, int y, int width, int height, String text, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        Button widget = Button.m_253074_((Component)Component.m_237113_((String)(text + ": ")).m_7220_((Component)(getter.get() != false ? Component.m_237113_((String)"ON").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"OFF").m_130940_(ChatFormatting.RED))), button -> {
            setter.accept((Boolean)getter.get() == false);
            button.m_93666_((Component)Component.m_237113_((String)(text + ": ")).m_7220_((Component)((Boolean)getter.get() != false ? Component.m_237113_((String)"ON").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"OFF").m_130940_(ChatFormatting.RED))));
        }).m_252987_(x, y, width, height).m_253136_();
        this.m_142416_((GuiEventListener)widget);
    }

    private void addSliderOption(int x, int y, int width, int height, final String label, final int min, final int max, Supplier<Integer> getter, final Consumer<Integer> setter) {
        int current = getter.get();
        double normalized = (double)(current - min) / (double)(max - min);
        AbstractSliderButton widget = new AbstractSliderButton(x, y, width, height, (Component)Component.m_237113_((String)(label + ": " + getter.get() + "ms")), normalized){

            protected void m_5695_() {
                int valueInt = (int)(this.f_93577_ * (double)(max - min)) + min;
                this.m_93666_((Component)Component.m_237113_((String)(label + ": " + valueInt + "ms")));
            }

            protected void m_5697_() {
                int newValue = (int)(this.f_93577_ * (double)(max - min)) + min;
                setter.accept(newValue);
            }
        };
        this.m_142416_((GuiEventListener)widget);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void m_7861_() {
        this.config.save();
    }

    public void m_7379_() {
        if (this.f_96541_ == null) {
            return;
        }
        this.f_96541_.m_91152_(this.parentScreen);
    }
}

