/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.capability;

import com.eeeab.eeeabsmobs.sever.handler.HandlerCapability;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VertigoCapability {
    public static ResourceLocation ID = new ResourceLocation("eeeabsmobs", "vertigo_processor_cap");

    public static class VertigoCapabilityProvider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<IVertigoCapability> instance = LazyOptional.of(VertigoCapabilityImp::new);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return HandlerCapability.MOVING_CONTROLLER_CAPABILITY.orEmpty(cap, this.instance.cast());
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)((IVertigoCapability)this.instance.orElseThrow(NullPointerException::new)).serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((IVertigoCapability)this.instance.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)nbt);
        }
    }

    public static class VertigoCapabilityImp
    implements IVertigoCapability {
        private float yaw;
        private float pitch;
        private float yawHead;
        private boolean isVertigo;
        private float swingProgress;
        private float renderYawOffset;
        private float limbSwingAmount;
        private UUID prevAttackTargetUUID;

        @Override
        public boolean isVertigo() {
            return this.isVertigo;
        }

        public void setVertigo(boolean vertigo) {
            this.isVertigo = vertigo;
        }

        @Override
        public float getYaw() {
            return this.yaw;
        }

        public void setYaw(float yaw) {
            this.yaw = yaw;
        }

        @Override
        public float getPitch() {
            return this.pitch;
        }

        public void setPitch(float pitch) {
            this.pitch = pitch;
        }

        @Override
        public float getYawHead() {
            return this.yawHead;
        }

        public void setYawHead(float yawHead) {
            this.yawHead = yawHead;
        }

        public UUID getPrevAttackTargetUUID() {
            return this.prevAttackTargetUUID;
        }

        public void setPrevAttackTargetUUID(UUID prevAttackTargetUUID) {
            this.prevAttackTargetUUID = prevAttackTargetUUID;
        }

        @Override
        public float getCRenderYawOffset() {
            return this.renderYawOffset;
        }

        public void setRenderYawOffset(float renderYawOffset) {
            this.renderYawOffset = renderYawOffset;
        }

        @Override
        public float getCSwingProgress() {
            return this.swingProgress;
        }

        public void setSwingProgress(float swingProgress) {
            this.swingProgress = swingProgress;
        }

        @Override
        public float getCLimbSwingAmount() {
            return this.limbSwingAmount;
        }

        public void setLimbSwingAmount(float limbSwingAmount) {
            this.limbSwingAmount = limbSwingAmount;
        }

        @Override
        public void onStart(LivingEntity entity) {
            if (entity != null) {
                Mob mob;
                entity.m_7618_(EntityAnchorArgument.Anchor.FEET, new Vec3(entity.m_20182_().m_7096_() + Math.cos(Math.toRadians(entity.f_20885_ + 90.0f)), entity.m_20182_().m_7098_() - 1.0, entity.m_20182_().m_7094_() + Math.sin(Math.toRadians(entity.f_20885_ + 90.0f))));
                this.isVertigo = true;
                this.yaw = entity.m_146908_();
                this.pitch = entity.m_146909_();
                this.yawHead = entity.f_20885_;
                this.limbSwingAmount = 0.0f;
                this.renderYawOffset = entity.f_20883_;
                this.swingProgress = entity.f_20921_;
                entity.m_5810_();
                if (entity instanceof Mob && (mob = (Mob)entity).m_5448_() != null) {
                    this.setPrevAttackTargetUUID(mob.m_5448_().m_20148_());
                }
            }
        }

        @Override
        public void onEnd(LivingEntity entity) {
            if (entity != null && this.isVertigo) {
                this.isVertigo = false;
                if (entity instanceof Mob) {
                    Player target;
                    Mob mob = (Mob)entity;
                    if (this.getPrevAttackTargetUUID() != null && (target = mob.m_9236_().m_46003_(this.getPrevAttackTargetUUID())) != null) {
                        mob.m_6710_((LivingEntity)target);
                    }
                }
            }
        }

        @Override
        public void tick(LivingEntity entity) {
            if (this.isVertigo) {
                if (entity.m_9236_().m_5776_()) {
                    for (int i = 0; i < 5; ++i) {
                        Vec3 pos = new Vec3(entity.m_20185_(), entity.m_20186_() + ((double)entity.m_20206_() + 0.25), entity.m_20189_()).m_82549_(new Vec3(1.0, 0.0, 0.0).m_82524_((float)Math.toRadians(entity.m_217043_().m_188503_(360))));
                        entity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 0.0, 0.0, 0.0);
                    }
                }
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.m_21573_().m_26573_();
                }
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128350_("yaw", this.getYaw());
            compoundTag.m_128350_("pitch", this.getPitch());
            compoundTag.m_128350_("yawHead", this.getYawHead());
            compoundTag.m_128379_("isVertigo", this.isVertigo());
            if (this.getPrevAttackTargetUUID() != null) {
                compoundTag.m_128362_("prevAttackTargetUUID", this.getPrevAttackTargetUUID());
            }
            compoundTag.m_128350_("renderYawOffset", this.getCRenderYawOffset());
            compoundTag.m_128350_("swingProgress", this.getCSwingProgress());
            compoundTag.m_128350_("limbSwingAmount", this.getCLimbSwingAmount());
            return compoundTag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.setYaw(nbt.m_128457_("yaw"));
            this.setPitch(nbt.m_128457_("pitch"));
            this.setYawHead(nbt.m_128457_("yawHead"));
            this.setVertigo(nbt.m_128471_("isVertigo"));
            try {
                this.setPrevAttackTargetUUID(nbt.m_128342_("prevAttackTargetUUID"));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.setRenderYawOffset(nbt.m_128457_("renderYawOffset"));
            this.setSwingProgress(nbt.m_128457_("swingProgress"));
            this.setLimbSwingAmount(nbt.m_128457_("limbSwingAmount"));
        }
    }

    public static interface IVertigoCapability
    extends INBTSerializable<CompoundTag> {
        public boolean isVertigo();

        public float getYaw();

        public float getPitch();

        public float getYawHead();

        public float getCRenderYawOffset();

        public float getCSwingProgress();

        public float getCLimbSwingAmount();

        public void onStart(LivingEntity var1);

        public void onEnd(LivingEntity var1);

        public void tick(LivingEntity var1);
    }
}

