/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.render.layer;

import com.eeeab.eeeabsmobs.sever.entity.GlowEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LayerGlow<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    protected final ResourceLocation location;
    protected final GlowPredicate<T> predicate;
    protected final float brightness;
    protected final boolean overlayTexture;

    public LayerGlow(RenderLayerParent<T, M> renderLayerParent, ResourceLocation location) {
        this(renderLayerParent, location, 1.0f, rec$ -> ((GlowEntity)rec$).isGlow(), false);
    }

    public LayerGlow(RenderLayerParent<T, M> renderLayerParent, ResourceLocation location, float brightness) {
        this(renderLayerParent, location, brightness, rec$ -> ((GlowEntity)rec$).isGlow(), false);
    }

    public LayerGlow(RenderLayerParent<T, M> renderLayerParent, ResourceLocation location, float brightness, GlowPredicate<T> predicate) {
        this(renderLayerParent, location, brightness, predicate, false);
    }

    public LayerGlow(RenderLayerParent<T, M> renderLayerParent, ResourceLocation location, float brightness, GlowPredicate<T> predicate, boolean overlayTexture) {
        super(renderLayerParent);
        this.location = location;
        this.brightness = brightness;
        this.predicate = predicate;
        this.overlayTexture = overlayTexture;
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.predicate.glow(entity)) {
            float brightness = this.getBrightness(entity, partialTicks);
            this.renderLayer(entity, stack, bufferSource.m_6299_(this.getRenderType(entity)), packedLightIn, brightness, brightness, brightness, brightness);
        }
    }

    protected void renderLayer(T entity, PoseStack stack, VertexConsumer vertexConsumer, int packedLightIn, float r, float g, float b, float alpha) {
        int i = this.overlayTexture ? LivingEntityRenderer.m_115338_(entity, (float)0.0f) : OverlayTexture.f_118083_;
        this.m_117386_().m_7695_(stack, vertexConsumer, packedLightIn, i, r, g, b, alpha);
    }

    protected RenderType getRenderType(T entity) {
        return RenderType.m_110488_((ResourceLocation)this.location);
    }

    protected float getBrightness(T entity, float partialTicks) {
        return this.brightness;
    }

    @FunctionalInterface
    public static interface GlowPredicate<T> {
        public boolean glow(T var1);
    }
}

