/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.model.entity;

import com.eeeab.animate.client.model.EMHierarchicalModel;
import com.eeeab.eeeabsmobs.client.model.animation.AnimationCorpseWarlock;
import com.eeeab.eeeabsmobs.sever.entity.corpse.EntityCorpseWarlock;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelCorpseWarlock
extends EMHierarchicalModel<EntityCorpseWarlock> {
    private final ModelPart root;
    private final ModelPart upper;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart cloak;
    public final ModelPart head;

    public ModelCorpseWarlock(ModelPart root) {
        this.root = root.m_171324_("root");
        this.upper = this.root.m_171324_("upper");
        this.head = this.upper.m_171324_("head");
        this.rightArm = this.upper.m_171324_("rightArm");
        this.leftArm = this.upper.m_171324_("leftArm");
        this.cloak = this.upper.m_171324_("body").m_171324_("cloak");
        ModelPart lower = this.root.m_171324_("lower");
        this.rightLeg = lower.m_171324_("rightLeg");
        this.leftLeg = lower.m_171324_("leftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition upper = root.m_171599_("upper", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-14.0f, (float)0.0f));
        PartDefinition head = upper.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-11.8f, (float)0.0f));
        PartDefinition head_r1 = head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-3.7f, -4.7f, -4.3f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0872f, (float)0.7844f, (float)0.0617f));
        PartDefinition head_r2 = head.m_171599_("head_r2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -3.7f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.5f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition body = upper.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(26, 36).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 18).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 17.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cloak = body.m_171599_("cloak", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-11.5338f, (float)2.7579f));
        PartDefinition cloak_r1 = cloak.m_171599_("cloak_r1", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171488_(-6.5f, -1.0f, 0.0f, 13.0f, 20.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = upper.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(26, 18).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.4f, (float)-10.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition leftArm = upper.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(26, 18).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)5.5f, (float)-10.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition lower = root.m_171599_("lower", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition rightLeg = lower.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(44, 18).m_171480_().m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = lower.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(44, 18).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(EntityCorpseWarlock entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        ModelCorpseWarlock.lookAtAnimation(netHeadYaw, headPitch, 1.0f, this.head);
        float delta = ageInTicks - (float)entity.f_19797_;
        float frame = (float)entity.frame + delta;
        float walkSpeed = 0.7f;
        float walkDegree = 0.6f;
        this.flap(this.root, walkSpeed, walkDegree * 0.08f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.leftLeg, walkSpeed, walkDegree * 1.2f, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.rightLeg, walkSpeed, walkDegree * 1.2f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        if (entity.isNoAnimation()) {
            this.walk(this.rightArm, walkSpeed, walkDegree, true, -0.2f, -0.1f, limbSwing, limbSwingAmount);
            this.walk(this.leftArm, walkSpeed, walkDegree, false, -0.2f, 0.1f, limbSwing, limbSwingAmount);
            this.walk(this.cloak, walkSpeed * 0.5f, walkDegree * 0.5f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
            this.flap(this.rightArm, walkSpeed * 0.2f, walkDegree * 0.2f, true, 0.2f, -0.2f, limbSwing, limbSwingAmount);
            this.flap(this.leftArm, walkSpeed * 0.2f, walkDegree * 0.2f, true, 0.2f, 0.2f, limbSwing, limbSwingAmount);
        }
        float speed = 0.12f;
        float degree = 0.1f;
        if (entity.m_6084_()) {
            this.walk(this.upper, 0.1f, 0.005f, true, 0.0f, -0.005f, frame, 1.0f);
            this.walk(this.rightArm, speed, degree, true, 0.0f, 0.0f, frame, 1.0f);
            this.swing(this.rightArm, speed, degree, true, 0.0f, 0.0f, frame, 1.0f);
            this.walk(this.leftArm, speed, degree, false, 0.0f, 0.0f, frame, 1.0f);
            this.swing(this.leftArm, speed, degree, false, 0.0f, 0.0f, frame, 1.0f);
        }
        this.animate(entity.attackAnimation, AnimationCorpseWarlock.ATTACK, ageInTicks, 1.0f);
        this.animate(entity.tearSpaceAnimation, AnimationCorpseWarlock.TEAR_SPACE, ageInTicks, 1.0f);
        this.animate(entity.teleportAnimation, AnimationCorpseWarlock.TELEPORT, ageInTicks, 1.0f);
        this.animate(entity.vampireAnimation, entity.isHeal() ? AnimationCorpseWarlock.VAMPIRE_HEAL : AnimationCorpseWarlock.VAMPIRE_ATTACK, ageInTicks, 1.0f);
        this.animate(entity.robustAnimation, AnimationCorpseWarlock.ROBUST_ATTACK, ageInTicks, 1.0f);
        if (entity.getAnimation() == entity.summonAnimation || entity.getAnimation() == entity.frenzyAnimation || entity.getAnimation() == entity.babbleAnimation) {
            float animationSpeed = 1.0f;
            if (entity.getAnimation() == entity.babbleAnimation) {
                this.head.f_104203_ = -0.17453294f;
                animationSpeed = 0.5f;
            }
            this.rightArm.f_104202_ = 0.0f;
            this.rightArm.f_104200_ = -6.0f;
            this.leftArm.f_104202_ = 0.0f;
            this.leftArm.f_104200_ = 6.0f;
            this.rightArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6666f * animationSpeed)) * 0.5f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6666f * animationSpeed)) * 0.5f;
            this.rightArm.f_104205_ = 2.3561945f;
            this.leftArm.f_104205_ = -2.3561945f;
            this.rightArm.f_104204_ = 0.0f;
            this.leftArm.f_104204_ = 0.0f;
        }
    }
}

