/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.animate.client.model;

import com.eeeab.animate.client.model.EMKeyframeAnimations;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public abstract class EMHierarchicalModel<E extends Entity>
extends EntityModel<E> {
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();
    private float movementScale = 1.0f;

    public abstract ModelPart root();

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public abstract void m_6973_(E var1, float var2, float var3, float var4, float var5, float var6);

    public void resetToDefaultPose() {
        this.root().m_171331_().forEach(ModelPart::m_233569_);
    }

    public static void lookAtAnimation(float yaw, float pitch, float rotationDivisor, ModelPart ... boxes) {
        int length = boxes.length;
        float actualRotationDivisor = rotationDivisor * (float)length;
        float yawAmount = yaw / 57.295776f / actualRotationDivisor;
        float pitchAmount = pitch / 57.295776f / actualRotationDivisor;
        for (ModelPart box : boxes) {
            box.f_104204_ += yawAmount;
            box.f_104203_ += pitchAmount;
        }
    }

    protected void setStaticRotationPoint(ModelPart box, float px, float py, float pz) {
        box.f_104200_ += px;
        box.f_104201_ += py;
        box.f_104202_ += pz;
    }

    protected void setStaticRotationAngle(ModelPart box, float rx, float ry, float rz) {
        box.f_104203_ += EMHierarchicalModel.toRadians(rx);
        box.f_104204_ += EMHierarchicalModel.toRadians(ry);
        box.f_104205_ += EMHierarchicalModel.toRadians(rz);
    }

    public void bob(ModelPart box, float speed, float degree, boolean bounce, float frame, float scale) {
        float movementScale = this.getMovementScale();
        float bob = (float)(Math.sin(frame * (speed *= movementScale)) * (double)scale * (double)(degree *= movementScale) - (double)(scale * degree));
        if (bounce) {
            bob = (float)(-Math.abs(Math.sin(frame * speed) * (double)scale * (double)degree));
        }
        box.f_104201_ += bob;
    }

    public void walk(ModelPart box, float speed, float degree, boolean invert, float offset, float weight, float walk, float walkAmount) {
        box.f_104203_ += this.calculateRotation(speed, degree, invert, offset, weight, walk, walkAmount);
    }

    public void flap(ModelPart box, float speed, float degree, boolean invert, float offset, float weight, float walk, float walkAmount) {
        box.f_104205_ += this.calculateRotation(speed, degree, invert, offset, weight, walk, walkAmount);
    }

    public void swing(ModelPart box, float speed, float degree, boolean invert, float offset, float weight, float walk, float walkAmount) {
        box.f_104204_ += this.calculateRotation(speed, degree, invert, offset, weight, walk, walkAmount);
    }

    private float calculateRotation(float speed, float degree, boolean invert, float offset, float weight, float frame, float scale) {
        float movementScale = this.getMovementScale();
        float rotation = Mth.m_14089_((float)(frame * speed * movementScale + offset)) * degree * movementScale * scale + weight * scale;
        return invert ? -rotation : rotation;
    }

    public void chainSwing(ModelPart[] boxes, float speed, float degree, double rootOffset, float swing, float swingAmount) {
        float offset = this.calculateChainOffset(rootOffset, boxes);
        for (int index = 0; index < boxes.length; ++index) {
            boxes[index].f_104204_ += this.calculateChainRotation(speed, degree, swing, swingAmount, offset, index);
        }
    }

    public void chainWave(ModelPart[] boxes, float speed, float degree, double rootOffset, float swing, float swingAmount) {
        float offset = this.calculateChainOffset(rootOffset, boxes);
        for (int index = 0; index < boxes.length; ++index) {
            boxes[index].f_104203_ += this.calculateChainRotation(speed, degree, swing, swingAmount, offset, index);
        }
    }

    public void chainFlap(ModelPart[] boxes, float speed, float degree, double rootOffset, float swing, float swingAmount) {
        float offset = this.calculateChainOffset(rootOffset, boxes);
        for (int index = 0; index < boxes.length; ++index) {
            boxes[index].f_104205_ += this.calculateChainRotation(speed, degree, swing, swingAmount, offset, index);
        }
    }

    private float calculateChainOffset(double rootOffset, ModelPart ... boxes) {
        return (float)(rootOffset * Math.PI / (double)(2 * boxes.length));
    }

    private float calculateChainRotation(float speed, float degree, float swing, float swingAmount, float offset, int boxIndex) {
        return Mth.m_14089_((float)(swing * speed * this.movementScale + offset * (float)boxIndex)) * swingAmount * degree * this.movementScale;
    }

    protected static float toRadians(double degree) {
        return (float)degree * ((float)Math.PI / 180);
    }

    public float getMovementScale() {
        return this.movementScale;
    }

    public void setMovementScale(float movementScale) {
        this.movementScale = movementScale;
    }

    public Optional<ModelPart> getAnyDescendantWithName(String name) {
        return name.equals("root") ? Optional.of(this.root()) : this.root().m_171331_().filter(part -> part.m_233562_(name)).findFirst().map(part -> part.m_171324_(name));
    }

    protected void animate(AnimationState animationState, AnimationDefinition animationDefinition, float ageInTicks) {
        this.animate(animationState, animationDefinition, ageInTicks, 1.0f);
    }

    protected void animate(AnimationState animationState, AnimationDefinition animationDefinition, float ageInTicks, float speed) {
        animationState.m_216974_(ageInTicks, speed);
        animationState.m_216979_(state -> EMKeyframeAnimations.animate(this, animationDefinition, state.m_216981_(), 1.0f, ANIMATION_VECTOR_CACHE));
    }

    protected void animate(AnimationState animationState, AnimationDefinition animationDefinition, float ageInTicks, float speed, float scale) {
        animationState.m_216974_(ageInTicks, speed);
        animationState.m_216979_(state -> EMKeyframeAnimations.animate(this, animationDefinition, state.m_216981_(), scale, ANIMATION_VECTOR_CACHE));
    }

    protected void animateWalk(AnimationDefinition animationDefinition, float limbSwing, float limbSwingAmount, float maxAnimationSpeed, float animationScaleFactor) {
        long i = (long)(limbSwing * 50.0f * maxAnimationSpeed);
        float f = Math.min(limbSwingAmount * animationScaleFactor, 1.0f);
        EMKeyframeAnimations.animate(this, animationDefinition, i, f, ANIMATION_VECTOR_CACHE);
    }
}

