/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.cave_dweller.entities;

import de.cadentem.cave_dweller.config.ServerConfig;
import de.cadentem.cave_dweller.entities.goals.CaveDwellerBreakDoorGoal;
import de.cadentem.cave_dweller.entities.goals.CaveDwellerBreakInvisGoal;
import de.cadentem.cave_dweller.entities.goals.CaveDwellerChaseGoal;
import de.cadentem.cave_dweller.entities.goals.CaveDwellerFleeGoal;
import de.cadentem.cave_dweller.entities.goals.CaveDwellerStareGoal;
import de.cadentem.cave_dweller.entities.goals.CaveDwellerStrollGoal;
import de.cadentem.cave_dweller.entities.goals.CaveDwellerTargetSeesMeGoal;
import de.cadentem.cave_dweller.entities.goals.CaveDwellerTargetTooCloseGoal;
import de.cadentem.cave_dweller.entities.goals.Roll;
import de.cadentem.cave_dweller.network.CaveSound;
import de.cadentem.cave_dweller.network.NetworkHandler;
import de.cadentem.cave_dweller.registry.ModSounds;
import de.cadentem.cave_dweller.util.Utils;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CaveDwellerEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation CHASE = RawAnimation.begin().then("animation.cave_dweller.new_run", Animation.LoopType.LOOP);
    private final RawAnimation CHASE_IDLE = RawAnimation.begin().then("animation.cave_dweller.run_idle", Animation.LoopType.LOOP);
    private final RawAnimation CROUCH_RUN = RawAnimation.begin().then("animation.cave_dweller.crouch_run_new", Animation.LoopType.LOOP);
    private final RawAnimation CROUCH_IDLE = RawAnimation.begin().then("animation.cave_dweller.crouch_idle", Animation.LoopType.LOOP);
    private final RawAnimation CALM_RUN = RawAnimation.begin().then("animation.cave_dweller.calm_move", Animation.LoopType.LOOP);
    private final RawAnimation CALM_STILL = RawAnimation.begin().then("animation.cave_dweller.calm_idle", Animation.LoopType.LOOP);
    private final RawAnimation IS_SPOTTED = RawAnimation.begin().then("animation.cave_dweller.spotted", Animation.LoopType.HOLD_ON_LAST_FRAME);
    private final RawAnimation CRAWL = RawAnimation.begin().then("animation.cave_dweller.crawl", Animation.LoopType.LOOP);
    private final RawAnimation FLEE = RawAnimation.begin().then("animation.cave_dweller.flee", Animation.LoopType.LOOP);
    public static final EntityDataAccessor<Boolean> FLEEING_ACCESSOR = SynchedEntityData.m_135353_(CaveDwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> CROUCHING_ACCESSOR = SynchedEntityData.m_135353_(CaveDwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> CRAWLING_ACCESSOR = SynchedEntityData.m_135353_(CaveDwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SPOTTED_ACCESSOR = SynchedEntityData.m_135353_(CaveDwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> CLIMBING_ACCESSOR = SynchedEntityData.m_135353_(CaveDwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public Roll currentRoll = Roll.STROLL;
    public boolean isFleeing;
    public boolean hasSpawned;
    public boolean pleaseStopMoving;
    public boolean targetIsFacingMe;
    private int ticksTillRemove;
    private int chaseSoundClock;
    private boolean alreadyPlayedFleeSound;
    private boolean alreadyPlayedSpottedSound;
    private boolean startedPlayingChaseSound;
    private boolean alreadyPlayedDeathSound;

    public CaveDwellerEntity(EntityType<? extends CaveDwellerEntity> entityType, Level level) {
        super(entityType, level);
        this.m_6210_();
        this.ticksTillRemove = Utils.secondsToTicks((Integer)ServerConfig.TIME_UNTIL_LEAVE.get());
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tagData) {
        this.setAttribute(this.m_21051_(Attributes.f_22276_), (Double)ServerConfig.MAX_HEALTH.get());
        this.setAttribute(this.m_21051_(Attributes.f_22281_), (Double)ServerConfig.ATTACK_DAMAGE.get());
        this.setAttribute(this.m_21051_(Attributes.f_22283_), (Double)ServerConfig.ATTACK_SPEED.get());
        this.setAttribute(this.m_21051_(Attributes.f_22279_), (Double)ServerConfig.MOVEMENT_SPEED.get());
        this.setAttribute(this.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()), 0.4);
        return super.m_6518_(level, difficulty, reason, spawnData, tagData);
    }

    private void setAttribute(AttributeInstance attribute, double value) {
        if (attribute != null) {
            attribute.m_22100_(value);
            if (attribute.m_22099_() == Attributes.f_22276_) {
                this.m_21153_((float)value);
            } else if (attribute.m_22099_() == Attributes.f_22279_) {
                this.m_7910_((float)value);
            }
        }
    }

    public static AttributeSupplier getAttributeBuilder() {
        double maxHealth = 60.0;
        double attackDamage = 6.0;
        double attackSpeed = 0.35;
        double movementSpeed = 0.3;
        double followRange = 100.0;
        return CaveDwellerEntity.m_21552_().m_22268_(Attributes.f_22276_, maxHealth).m_22268_(Attributes.f_22281_, attackDamage).m_22268_(Attributes.f_22283_, attackSpeed).m_22268_(Attributes.f_22279_, movementSpeed).m_22268_(Attributes.f_22277_, followRange).m_22265_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLEEING_ACCESSOR, (Object)false);
        this.f_19804_.m_135372_(CROUCHING_ACCESSOR, (Object)false);
        this.f_19804_.m_135372_(CRAWLING_ACCESSOR, (Object)false);
        this.f_19804_.m_135372_(SPOTTED_ACCESSOR, (Object)false);
        this.f_19804_.m_135372_(CLIMBING_ACCESSOR, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CaveDwellerChaseGoal(this, true));
        this.f_21345_.m_25352_(1, (Goal)new CaveDwellerFleeGoal(this, 20.0f, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new CaveDwellerBreakInvisGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new CaveDwellerStareGoal(this));
        if (((Boolean)ServerConfig.CAN_BREAK_DOOR.get()).booleanValue()) {
            this.f_21345_.m_25352_(2, (Goal)new CaveDwellerBreakDoorGoal((Mob)this, difficulty -> true));
        }
        this.f_21345_.m_25352_(3, (Goal)new CaveDwellerStrollGoal(this, 0.35));
        this.f_21346_.m_25352_(1, (Goal)new CaveDwellerTargetTooCloseGoal(this, 12.0f));
        this.f_21346_.m_25352_(2, (Goal)new CaveDwellerTargetSeesMeGoal(this));
    }

    public void disappear() {
        this.playDisappearSound();
        this.m_146870_();
    }

    public boolean hasSpawned() {
        return this.hasSpawned;
    }

    protected boolean m_7341_(@NotNull Entity vehicle) {
        if (((Boolean)ServerConfig.ALLOW_RIDING.get()).booleanValue()) {
            return super.m_7341_(vehicle);
        }
        return false;
    }

    public boolean m_7998_(@NotNull Entity vehicle, boolean force) {
        if (((Boolean)ServerConfig.ALLOW_RIDING.get()).booleanValue()) {
            return super.m_7998_(vehicle, force);
        }
        return false;
    }

    public void m_8119_() {
        --this.ticksTillRemove;
        if (this.ticksTillRemove <= 0) {
            this.disappear();
        }
        if (this.f_21345_.m_148105_().isEmpty() || this.f_21346_.m_148105_().isEmpty()) {
            this.m_8099_();
            this.f_21345_.m_25373_();
            this.f_21346_.m_25373_();
        }
        if (this.m_5448_() != null) {
            this.targetIsFacingMe = this.isLookingAtMe((Entity)this.m_5448_(), false);
        }
        if (this.m_9236_() instanceof ServerLevel) {
            boolean shouldCrawl;
            boolean isAboveSolid = this.m_9236_().m_8055_(this.m_20183_().m_7494_()).m_280296_();
            boolean isTwoAboveSolid = this.m_9236_().m_8055_(this.m_20183_().m_6630_(2)).m_280296_();
            boolean isThreeAboveSolid = this.m_9236_().m_8055_(this.m_20183_().m_6630_(3)).m_280296_();
            Vec3i offset = this.getDirectionVector();
            boolean isFacingSolid = this.m_9236_().m_8055_(this.m_20183_().m_121945_(this.m_6350_())).m_280296_();
            if (isFacingSolid) {
                offset = offset.m_7918_(0, 1, 0);
            }
            boolean isOffsetFacingSolid = this.m_9236_().m_8055_(this.m_20183_().m_121955_(offset)).m_280296_();
            boolean isOffsetFacingAboveSolid = this.m_9236_().m_8055_(this.m_20183_().m_121955_(offset).m_7494_()).m_280296_();
            boolean isOffsetFacingTwoAboveSolid = this.m_9236_().m_8055_(this.m_20183_().m_121955_(offset).m_6630_(2)).m_280296_();
            boolean shouldCrouch = isTwoAboveSolid || !isOffsetFacingSolid && !isOffsetFacingAboveSolid && (isOffsetFacingTwoAboveSolid || isFacingSolid && isThreeAboveSolid);
            boolean bl = shouldCrawl = isAboveSolid || !isOffsetFacingSolid && isOffsetFacingAboveSolid || isFacingSolid && isTwoAboveSolid;
            if (this.m_5912_() || this.isFleeing) {
                this.f_19804_.m_135381_(SPOTTED_ACCESSOR, (Object)false);
            }
            this.setClimbing(this.f_19862_);
            this.f_19804_.m_135381_(CROUCHING_ACCESSOR, (Object)shouldCrouch);
            this.setCrawling(shouldCrawl);
        }
        if (((Boolean)this.f_19804_.m_135370_(SPOTTED_ACCESSOR)).booleanValue()) {
            this.playSpottedSound();
        }
        this.m_6210_();
        this.m_21573_().m_26517_(this.getSpeedModifier());
        super.m_8119_();
    }

    public double getSpeedModifier() {
        return this.isCrawling() ? 0.35 : (this.m_6047_() ? 0.6 : 0.85);
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        if (((Boolean)this.f_19804_.m_135370_(CRAWLING_ACCESSOR)).booleanValue()) {
            return new EntityDimensions(0.5f, 0.5f, true);
        }
        if (((Boolean)this.f_19804_.m_135370_(CROUCHING_ACCESSOR)).booleanValue()) {
            return new EntityDimensions(0.5f, 1.7f, true);
        }
        return super.m_6972_(pose);
    }

    private boolean isMoving() {
        Vec3 velocity = this.m_20184_();
        float avgVelocity = (float)(Math.abs(velocity.f_82479_) + Math.abs(velocity.f_82481_)) / 2.0f;
        return avgVelocity > 0.03f;
    }

    public void reRoll() {
        this.currentRoll = Roll.fromValue(new Random().nextInt(3));
    }

    public void pickRoll(@NotNull List<Roll> rolls) {
        this.currentRoll = rolls.get(new Random().nextInt(rolls.size()));
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        if (!((Boolean)ServerConfig.CAN_CLIMB.get()).booleanValue()) {
            return false;
        }
        if (this.m_5448_() != null) {
            return !this.isCrawling() && !this.m_6047_() && (Boolean)this.f_19804_.m_135370_(CLIMBING_ACCESSOR) != false;
        }
        return false;
    }

    public void setClimbing(boolean isClimbing) {
        this.f_19804_.m_135381_(CLIMBING_ACCESSOR, (Object)isClimbing);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        WallClimberNavigation navigation = new WallClimberNavigation((Mob)this, level);
        navigation.m_26529_(4.0f);
        return navigation;
    }

    private PlayState predicate(AnimationState<CaveDwellerEntity> state) {
        boolean isCurrentAboveSolid = this.m_9236_().m_8055_(this.m_20183_().m_7494_()).m_280296_();
        boolean unsure = this.isCrawling() && this.m_9236_().m_8055_(this.m_20183_()).m_280296_();
        boolean isCurrentTwoAboveSolid = this.m_9236_().m_8055_(this.m_20183_().m_6630_(2)).m_280296_();
        if (isCurrentAboveSolid || unsure) {
            return state.setAndContinue(this.CRAWL);
        }
        if (isCurrentTwoAboveSolid) {
            if (state.isMoving()) {
                return state.setAndContinue(this.CROUCH_RUN);
            }
            return state.setAndContinue(this.CROUCH_IDLE);
        }
        if (this.m_5912_()) {
            if (state.isMoving()) {
                return state.setAndContinue(this.CHASE);
            }
            return state.setAndContinue(this.CHASE_IDLE);
        }
        if (((Boolean)this.f_19804_.m_135370_(FLEEING_ACCESSOR)).booleanValue()) {
            if (state.isMoving()) {
                return state.setAndContinue(this.FLEE);
            }
            return state.setAndContinue(this.CHASE_IDLE);
        }
        if (this.pleaseStopMoving || ((Boolean)this.f_19804_.m_135370_(SPOTTED_ACCESSOR)).booleanValue() && !state.isMoving()) {
            return state.setAndContinue(this.IS_SPOTTED);
        }
        if (state.isMoving()) {
            return state.setAndContinue(this.CALM_RUN);
        }
        return state.setAndContinue(this.CALM_STILL);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 3, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        super.m_7355_(pPos, pState);
        this.playEntitySound(this.chooseStep());
    }

    private void playEntitySound(SoundEvent soundEvent) {
        this.playEntitySound(soundEvent, 1.0f, 1.0f);
    }

    private void playEntitySound(SoundEvent soundEvent, float volume, float pitch) {
        this.m_9236_().m_6269_(null, (Entity)this, soundEvent, SoundSource.HOSTILE, volume, pitch);
    }

    private void playBlockPosSound(ResourceLocation soundResource, float volume, float pitch) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int radius = 60;
            serverLevel.m_8795_(player -> player.m_20280_((Entity)this) <= (double)(radius * radius)).forEach(player -> NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new CaveSound(soundResource, player.m_20183_(), volume, pitch)));
        }
    }

    public void playChaseSound() {
        if (this.startedPlayingChaseSound || this.isMoving()) {
            if (this.chaseSoundClock <= 0) {
                Random rand = new Random();
                switch (rand.nextInt(4)) {
                    case 0: {
                        this.playEntitySound((SoundEvent)ModSounds.CHASE_1.get(), 3.0f, 1.0f);
                        break;
                    }
                    case 1: {
                        this.playEntitySound((SoundEvent)ModSounds.CHASE_2.get(), 3.0f, 1.0f);
                        break;
                    }
                    case 2: {
                        this.playEntitySound((SoundEvent)ModSounds.CHASE_3.get(), 3.0f, 1.0f);
                        break;
                    }
                    case 3: {
                        this.playEntitySound((SoundEvent)ModSounds.CHASE_4.get(), 3.0f, 1.0f);
                    }
                }
                this.startedPlayingChaseSound = true;
                this.resetChaseSoundClock();
            }
            --this.chaseSoundClock;
        }
    }

    public void playDisappearSound() {
        this.playBlockPosSound(((SoundEvent)ModSounds.DISAPPEAR.get()).m_11660_(), 3.0f, 1.0f);
    }

    public void playFleeSound() {
        if (!this.alreadyPlayedFleeSound) {
            Random rand = new Random();
            switch (rand.nextInt(2)) {
                case 0: {
                    this.playEntitySound((SoundEvent)ModSounds.FLEE_1.get(), 3.0f, 1.0f);
                    break;
                }
                case 1: {
                    this.playEntitySound((SoundEvent)ModSounds.FLEE_2.get(), 3.0f, 1.0f);
                }
            }
            this.alreadyPlayedFleeSound = true;
        }
    }

    private void playSpottedSound() {
        if (!this.alreadyPlayedSpottedSound) {
            this.playEntitySound((SoundEvent)ModSounds.SPOTTED.get(), 3.0f, 1.0f);
            this.alreadyPlayedSpottedSound = true;
        }
    }

    private void resetChaseSoundClock() {
        this.chaseSoundClock = Utils.secondsToTicks(5);
    }

    private SoundEvent chooseStep() {
        Random rand = new Random();
        return switch (rand.nextInt(4)) {
            case 1 -> (SoundEvent)ModSounds.CHASE_STEP_2.get();
            case 2 -> (SoundEvent)ModSounds.CHASE_STEP_3.get();
            case 3 -> (SoundEvent)ModSounds.CHASE_STEP_4.get();
            default -> (SoundEvent)ModSounds.CHASE_STEP_1.get();
        };
    }

    private SoundEvent chooseHurtSound() {
        Random rand = new Random();
        return switch (rand.nextInt(4)) {
            case 1 -> (SoundEvent)ModSounds.DWELLER_HURT_2.get();
            case 2 -> (SoundEvent)ModSounds.DWELLER_HURT_3.get();
            case 3 -> (SoundEvent)ModSounds.DWELLER_HURT_4.get();
            default -> (SoundEvent)ModSounds.DWELLER_HURT_1.get();
        };
    }

    protected void m_6677_(@NotNull DamageSource pSource) {
        SoundEvent soundevent = this.chooseHurtSound();
        this.playEntitySound(soundevent, 2.0f, 1.0f);
    }

    public void setCrawling(boolean shouldCrawl) {
        if (shouldCrawl) {
            this.m_20088_().m_135381_(CROUCHING_ACCESSOR, (Object)false);
        }
        this.m_20088_().m_135381_(CRAWLING_ACCESSOR, (Object)shouldCrawl);
        this.m_6210_();
    }

    public boolean isCrawling() {
        return (Boolean)this.f_19804_.m_135370_(CRAWLING_ACCESSOR);
    }

    protected void m_6153_() {
        super.m_6153_();
        if (!this.alreadyPlayedDeathSound) {
            this.playBlockPosSound(((SoundEvent)ModSounds.DWELLER_DEATH.get()).m_11660_(), 2.0f, 1.0f);
            this.alreadyPlayedDeathSound = true;
        }
    }

    public boolean isLookingAtMe(Entity target, boolean directlyLooking) {
        if (!Utils.isValidPlayer(target)) {
            return false;
        }
        if (target.m_20299_(1.0f).m_82554_(this.m_20318_(1.0f)) > (double)((Integer)ServerConfig.SPOTTING_RANGE.get()).intValue()) {
            return false;
        }
        Vec3 viewVector = target.m_20252_(1.0f).m_82541_();
        Vec3 difference = new Vec3(this.m_20185_() - target.m_20185_(), this.m_20188_() - target.m_20188_(), this.m_20189_() - target.m_20189_());
        difference = difference.m_82541_();
        double dot = viewVector.m_82526_(difference);
        if (directlyLooking && target instanceof Player) {
            Player player = (Player)target;
            return dot > 0.99 && player.m_142582_((Entity)this);
        }
        return dot > 0.3;
    }

    public boolean teleportToTarget() {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return false;
        }
        Vec3 targetPosition = new Vec3(this.m_20185_() - target.m_20185_(), this.m_20227_(0.5) - target.m_20188_(), this.m_20189_() - target.m_20189_());
        targetPosition = targetPosition.m_82541_();
        double radius = 16.0;
        double d1 = this.m_20185_() + (this.m_217043_().m_188500_() - 0.5) * (radius / 2.0) - targetPosition.f_82479_ * radius;
        double d2 = this.m_20186_() + ((double)this.m_217043_().m_188503_((int)radius) - radius / 2.0) - targetPosition.f_82480_ * radius;
        double d3 = this.m_20189_() + (this.m_217043_().m_188500_() - 0.5) * (radius / 2.0) - targetPosition.f_82481_ * radius;
        BlockPos.MutableBlockPos validPosition = new BlockPos.MutableBlockPos(d1, d2, d3);
        while (validPosition.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)validPosition).m_280555_()) {
            validPosition.m_122173_(Direction.DOWN);
        }
        this.m_6021_(validPosition.m_123341_(), validPosition.m_123342_(), validPosition.m_123343_());
        return true;
    }

    private Vec3i getDirectionVector() {
        return new Vec3i(this.m_6350_().m_122429_(), this.m_6350_().m_122430_(), this.m_6350_().m_122431_());
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return this.chooseHurtSound();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.DWELLER_DEATH.get();
    }

    protected float m_6121_() {
        return 0.4f;
    }
}

