/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.systems;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import nl.requios.effortlessbuilding.utilities.InventoryHelper;

public class ItemUsageTracker {
    public Map<Item, Integer> total = new HashMap<Item, Integer>();
    public Map<Item, Integer> inInventory = new HashMap<Item, Integer>();
    public Map<Item, Integer> placed = new HashMap<Item, Integer>();
    public Map<Item, Integer> missing = new HashMap<Item, Integer>();

    public void initialize() {
        this.total.clear();
        this.inInventory.clear();
        this.placed.clear();
        this.missing.clear();
    }

    public boolean increaseUsageCount(Item item, int count, Player player) {
        if (item == null) {
            return true;
        }
        int newValue = this.total.getOrDefault(item, 0) + count;
        this.total.put(item, newValue);
        if (player.m_7500_()) {
            return true;
        }
        int have = 0;
        if (this.inInventory.containsKey(item)) {
            have = this.inInventory.get(item);
        } else {
            have = InventoryHelper.findTotalItemsInInventory(player, item);
            this.inInventory.put(item, have);
        }
        return have >= newValue;
    }

    public void calculateMissingItems(Player player) {
        if (player.m_7500_()) {
            return;
        }
        for (Item item : this.total.keySet()) {
            int used = this.total.get(item);
            int have = this.inInventory.getOrDefault(item, 0);
            this.placed.put(item, Math.min(used, have));
            if (used <= have) continue;
            this.missing.put(item, used - have);
        }
    }

    public int getValidCount(Item item) {
        return this.total.getOrDefault(item, 0) - this.missing.getOrDefault(item, 0);
    }

    public int getMissingCount(Item item) {
        return this.missing.getOrDefault(item, 0);
    }
}

