/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.render.BuildRenderTypes;
import nl.requios.effortlessbuilding.render.ModifierRenderer;
import nl.requios.effortlessbuilding.systems.BuilderChain;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderHandler {
    private static final ChatFormatting highlightColor = ChatFormatting.DARK_AQUA;
    private static final ChatFormatting normalColor = ChatFormatting.WHITE;
    private static final Component placingText = Component.m_237113_((String)(normalColor + "Left-click to " + highlightColor + "cancel, " + normalColor + "Right-click to " + highlightColor + "place"));
    private static final Component breakingText = Component.m_237113_((String)(normalColor + "Left-click to " + highlightColor + "break, " + normalColor + "Right-click to " + highlightColor + "cancel"));

    @SubscribeEvent
    public static void onRender(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        PoseStack ms = event.getPoseStack();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)bufferBuilder);
        ms.m_85836_();
        ms.m_85837_(-cameraPos.m_7096_(), -cameraPos.m_7098_(), -cameraPos.m_7094_());
        ModifierRenderer.render(ms, buffer);
        ms.m_85849_();
    }

    @SubscribeEvent
    public static void onRenderGuiEvent(RenderGuiEvent event) {
        RenderHandler.renderSubText(event.getGuiGraphics());
        RenderHandler.drawStacks(event.getGuiGraphics());
    }

    private static void renderSubText(GuiGraphics guiGraphics) {
        BuilderChain.BuildingState state = EffortlessBuildingClient.BUILDER_CHAIN.getBuildingState();
        if (state == BuilderChain.BuildingState.IDLE) {
            return;
        }
        Component text = state == BuilderChain.BuildingState.PLACING ? placingText : breakingText;
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int screenHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        Font font = Minecraft.m_91087_().f_91062_;
        PoseStack ms = guiGraphics.m_280168_();
        ms.m_85836_();
        ms.m_85837_((double)screenWidth / 2.0, (double)(screenHeight - 54), 0.0);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int l = font.m_92852_((FormattedText)text);
        guiGraphics.m_280614_(font, text, (int)((float)(-l / 2)), -4, -1, true);
        RenderSystem.disableBlend();
        ms.m_85849_();
    }

    private static void drawStacks(GuiGraphics guiGraphics) {
        BuilderChain.BuildingState state = EffortlessBuildingClient.BUILDER_CHAIN.getBuildingState();
        if (state != BuilderChain.BuildingState.PLACING) {
            return;
        }
        Map<Item, Integer> stacks = EffortlessBuildingClient.ITEM_USAGE_TRACKER.total;
        if (Minecraft.m_91087_().f_91074_ == null || Minecraft.m_91087_().f_91074_.m_7500_() && stacks.size() <= 1) {
            return;
        }
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int screenHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        int x = screenWidth / 2 + 10;
        int y = screenHeight / 2 - 8;
        int i = 0;
        for (Map.Entry<Item, Integer> stack : stacks.entrySet()) {
            int missing;
            int total = stack.getValue();
            if (total - (missing = EffortlessBuildingClient.ITEM_USAGE_TRACKER.getMissingCount(stack.getKey())) > 0) {
                RenderHandler.drawItemStack(guiGraphics, new ItemStack((ItemLike)stack.getKey(), total - missing), x + i * 20, y, false);
                ++i;
            }
            if (missing <= 0) continue;
            RenderHandler.drawItemStack(guiGraphics, new ItemStack((ItemLike)stack.getKey(), missing), x + i * 20, y, true);
            ++i;
        }
    }

    private static void drawItemStack(GuiGraphics guiGraphics, ItemStack stack, int x, int y, boolean missing) {
        guiGraphics.m_280480_(stack, x, y);
        PoseStack ms = guiGraphics.m_280168_();
        ms.m_85836_();
        Font font = Minecraft.m_91087_().f_91062_;
        String text = String.valueOf(stack.m_41613_());
        ms.m_85837_(0.0, 0.0, 200.0);
        MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        font.m_271703_(text, (float)(x + 19 - 2 - font.m_92895_(text)), (float)(y + 6 + 3), (missing ? ChatFormatting.RED.m_126665_() : ChatFormatting.WHITE.m_126665_()).intValue(), true, ms.m_85850_().m_252922_(), (MultiBufferSource)multibuffersource$buffersource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        multibuffersource$buffersource.m_109911_();
        ms.m_85849_();
    }

    protected static VertexConsumer beginLines(MultiBufferSource.BufferSource renderTypeBuffer) {
        return renderTypeBuffer.m_6299_(BuildRenderTypes.LINES);
    }

    protected static void endLines(MultiBufferSource.BufferSource renderTypeBuffer) {
        renderTypeBuffer.m_109911_();
    }

    protected static VertexConsumer beginPlanes(MultiBufferSource.BufferSource renderTypeBuffer) {
        return renderTypeBuffer.m_6299_(BuildRenderTypes.PLANES);
    }

    protected static void endPlanes(MultiBufferSource.BufferSource renderTypeBuffer) {
        renderTypeBuffer.m_109911_();
    }
}

