/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.item;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.capability.CapabilityHandler;
import nl.requios.effortlessbuilding.capability.IPowerLevel;
import nl.requios.effortlessbuilding.create.foundation.item.TooltipHelper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PowerLevelItem
extends Item {
    public PowerLevelItem() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        IPowerLevel powerLevel = (IPowerLevel)player.getCapability(CapabilityHandler.POWER_LEVEL_CAPABILITY).orElse(null);
        if (powerLevel != null) {
            if (powerLevel.canIncreasePowerLevel()) {
                if (!world.f_46443_) {
                    powerLevel.increasePowerLevel();
                    EffortlessBuilding.log(player, "Upgraded power level to " + powerLevel.getPowerLevel());
                    stack.m_41774_(1);
                    world.m_5594_((Player)null, player.m_20183_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    CapabilityHandler.syncToClient(player);
                }
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
            }
            if (!world.f_46443_) {
                EffortlessBuilding.log(player, "Already reached maximum power level!");
                world.m_5594_((Player)null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
        }
        return super.m_7203_(world, player, hand);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag isAdvanced) {
        tooltip.addAll(TooltipHelper.cutTextComponent((Component)Component.m_237115_((String)(this.m_5524_() + ".desc")), ChatFormatting.GRAY, ChatFormatting.GRAY));
        tooltip.addAll(TooltipHelper.cutTextComponent((Component)Component.m_237115_((String)"key.effortlessbuilding.upgrade_power_level"), ChatFormatting.BLUE, ChatFormatting.BLUE));
    }
}

