/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.create.foundation.utility.ghost;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.render.VirtualRenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import nl.requios.effortlessbuilding.create.foundation.utility.ghost.GhostBlockParams;

public abstract class GhostBlockRenderer {
    private static final GhostBlockRenderer STANDARD = new DefaultGhostBlockRenderer();
    private static final GhostBlockRenderer TRANSPARENT = new TransparentGhostBlockRenderer();

    public static GhostBlockRenderer standard() {
        return STANDARD;
    }

    public static GhostBlockRenderer transparent() {
        return TRANSPARENT;
    }

    public abstract void render(PoseStack var1, SuperRenderTypeBuffer var2, GhostBlockParams var3);

    private static class DefaultGhostBlockRenderer
    extends GhostBlockRenderer {
        private DefaultGhostBlockRenderer() {
        }

        @Override
        public void render(PoseStack ms, SuperRenderTypeBuffer buffer, GhostBlockParams params) {
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            ModelBlockRenderer renderer = dispatcher.m_110937_();
            BlockState state = params.state;
            BlockPos pos = params.pos;
            BakedModel model = dispatcher.m_110910_(state);
            ms.m_85836_();
            ms.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            for (RenderType layer : model.getRenderTypes(state, RandomSource.m_216335_((long)42L), VirtualRenderHelper.VIRTUAL_DATA)) {
                VertexConsumer vb = buffer.getEarlyBuffer(layer);
                renderer.renderModel(ms.m_85850_(), vb, state, model, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, VirtualRenderHelper.VIRTUAL_DATA, layer);
            }
            ms.m_85849_();
        }
    }

    private static class TransparentGhostBlockRenderer
    extends GhostBlockRenderer {
        private TransparentGhostBlockRenderer() {
        }

        @Override
        public void render(PoseStack ms, SuperRenderTypeBuffer buffer, GhostBlockParams params) {
            Minecraft mc = Minecraft.m_91087_();
            BlockRenderDispatcher dispatcher = mc.m_91289_();
            BlockState state = params.state;
            BlockPos pos = params.pos;
            float alpha = params.alphaSupplier.get().floatValue();
            float scale = params.scaleSupplier.get().floatValue();
            Color color = params.rgbSupplier.get();
            BakedModel model = dispatcher.m_110910_(state);
            RenderType layer = RenderType.m_110466_();
            VertexConsumer vb = buffer.getEarlyBuffer(layer);
            ms.m_85836_();
            ms.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            ms.m_85837_(0.5, 0.5, 0.5);
            ms.m_85841_(scale, scale, scale);
            ms.m_85837_(-0.5, -0.5, -0.5);
            this.renderModel(ms.m_85850_(), vb, state, model, color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), alpha, LevelRenderer.m_109541_((BlockAndTintGetter)mc.f_91073_, (BlockPos)pos), OverlayTexture.f_118083_, VirtualRenderHelper.VIRTUAL_DATA, layer);
            ms.m_85849_();
        }

        public void renderModel(PoseStack.Pose pose, VertexConsumer consumer, @Nullable BlockState state, BakedModel model, float red, float green, float blue, float alpha, int packedLight, int packedOverlay, ModelData modelData, RenderType renderType) {
            RandomSource random = RandomSource.m_216327_();
            for (Direction direction : Direction.values()) {
                random.m_188584_(42L);
                TransparentGhostBlockRenderer.renderQuadList(pose, consumer, red, green, blue, alpha, model.getQuads(state, direction, random, modelData, renderType), packedLight, packedOverlay);
            }
            random.m_188584_(42L);
            TransparentGhostBlockRenderer.renderQuadList(pose, consumer, red, green, blue, alpha, model.getQuads(state, null, random, modelData, renderType), packedLight, packedOverlay);
        }

        private static void renderQuadList(PoseStack.Pose pose, VertexConsumer consumer, float red, float green, float blue, float alpha, List<BakedQuad> quads, int packedLight, int packedOverlay) {
            for (BakedQuad quad : quads) {
                float f = Mth.m_14036_((float)red, (float)0.0f, (float)1.0f);
                float f1 = Mth.m_14036_((float)green, (float)0.0f, (float)1.0f);
                float f2 = Mth.m_14036_((float)blue, (float)0.0f, (float)1.0f);
                consumer.putBulkData(pose, quad, f, f1, f2, alpha, packedLight, packedOverlay, true);
            }
        }
    }
}

