/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.create.foundation.utility;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.extensions.IForgeItemStack;

public class NBTHelper {
    public static void putMarker(CompoundTag nbt, String marker) {
        nbt.m_128379_(marker, true);
    }

    public static <T extends Enum<?>> T readEnum(CompoundTag nbt, String key, Class<T> enumClass) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        if (enumConstants == null) {
            throw new IllegalArgumentException("Non-Enum class passed to readEnum: " + enumClass.getName());
        }
        if (nbt.m_128425_(key, 8)) {
            String name = nbt.m_128461_(key);
            for (Enum t : enumConstants) {
                if (!t.name().equals(name)) continue;
                return (T)t;
            }
        }
        return (T)enumConstants[0];
    }

    public static <T extends Enum<?>> void writeEnum(CompoundTag nbt, String key, T enumConstant) {
        nbt.m_128359_(key, enumConstant.name());
    }

    public static <T> ListTag writeCompoundList(Iterable<T> list, Function<T, CompoundTag> serializer) {
        ListTag listNBT = new ListTag();
        list.forEach(t -> {
            CompoundTag apply = (CompoundTag)serializer.apply(t);
            if (apply == null) {
                return;
            }
            listNBT.add((Object)apply);
        });
        return listNBT;
    }

    public static <T> List<T> readCompoundList(ListTag listNBT, Function<CompoundTag, T> deserializer) {
        ArrayList list = new ArrayList(listNBT.size());
        listNBT.forEach(inbt -> list.add(deserializer.apply((CompoundTag)inbt)));
        return list;
    }

    public static <T> void iterateCompoundList(ListTag listNBT, Consumer<CompoundTag> consumer) {
        listNBT.forEach(inbt -> consumer.accept((CompoundTag)inbt));
    }

    public static ListTag writeItemList(Iterable<ItemStack> stacks) {
        return NBTHelper.writeCompoundList(stacks, IForgeItemStack::serializeNBT);
    }

    public static List<ItemStack> readItemList(ListTag stacks) {
        return NBTHelper.readCompoundList(stacks, ItemStack::m_41712_);
    }

    public static ListTag writeAABB(AABB bb) {
        ListTag bbtag = new ListTag();
        bbtag.add((Object)FloatTag.m_128566_((float)((float)bb.f_82288_)));
        bbtag.add((Object)FloatTag.m_128566_((float)((float)bb.f_82289_)));
        bbtag.add((Object)FloatTag.m_128566_((float)((float)bb.f_82290_)));
        bbtag.add((Object)FloatTag.m_128566_((float)((float)bb.f_82291_)));
        bbtag.add((Object)FloatTag.m_128566_((float)((float)bb.f_82292_)));
        bbtag.add((Object)FloatTag.m_128566_((float)((float)bb.f_82293_)));
        return bbtag;
    }

    public static AABB readAABB(ListTag bbtag) {
        if (bbtag == null || bbtag.isEmpty()) {
            return null;
        }
        return new AABB((double)bbtag.m_128775_(0), (double)bbtag.m_128775_(1), (double)bbtag.m_128775_(2), (double)bbtag.m_128775_(3), (double)bbtag.m_128775_(4), (double)bbtag.m_128775_(5));
    }

    public static ListTag writeVec3i(Vec3i vec) {
        ListTag tag = new ListTag();
        tag.add((Object)IntTag.m_128679_((int)vec.m_123341_()));
        tag.add((Object)IntTag.m_128679_((int)vec.m_123342_()));
        tag.add((Object)IntTag.m_128679_((int)vec.m_123343_()));
        return tag;
    }

    public static Vec3i readVec3i(ListTag tag) {
        return new Vec3i(tag.m_128763_(0), tag.m_128763_(1), tag.m_128763_(2));
    }

    @Nonnull
    public static Tag getINBT(CompoundTag nbt, String id) {
        Tag inbt = nbt.m_128423_(id);
        if (inbt != null) {
            return inbt;
        }
        return new CompoundTag();
    }
}

