/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.ftb.mods.ftblibrary.config.ImageResourceConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.block.FTBQuestsBlocks;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientConfig;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientEventHandler;
import dev.ftb.mods.ftbquests.client.GuiProviders;
import dev.ftb.mods.ftbquests.client.QuestFileCacheReloader;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.net.SetCustomImageMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.theme.ThemeLoader;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FTBQuestsClient {
    public static KeyMapping KEY_QUESTS;

    public static void init() {
        FTBQuestsClientConfig.init();
        ClientLifecycleEvent.CLIENT_SETUP.register(FTBQuestsClient::onClientSetup);
        if (Minecraft.m_91087_() != null) {
            ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new QuestFileCacheReloader());
            ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new ThemeLoader());
            KEY_QUESTS = new KeyMapping("key.ftbquests.quests", InputConstants.Type.KEYSYM, -1, "key.categories.ftbquests");
            KeyMappingRegistry.register((KeyMapping)KEY_QUESTS);
        }
        new FTBQuestsClientEventHandler().init();
    }

    private static void onClientSetup(Minecraft minecraft) {
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.BARRIER.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.STAGE_BARRIER.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110451_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.TASK_SCREEN_1.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110451_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.TASK_SCREEN_3.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110451_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.TASK_SCREEN_5.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110451_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.TASK_SCREEN_7.get()});
        RenderTypeRegistry.register((RenderType)RenderType.m_110451_(), (Block[])new Block[]{(Block)FTBQuestsBlocks.AUX_SCREEN.get()});
        GuiProviders.setTaskGuiProviders();
        GuiProviders.setRewardGuiProviders();
    }

    @Nullable
    public static BaseQuestFile getClientQuestFile() {
        return ClientQuestFile.INSTANCE;
    }

    public static Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static Level getClientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }

    public static boolean isClientDataLoaded() {
        return ClientQuestFile.exists();
    }

    public static TeamData getClientPlayerData() {
        return ClientQuestFile.INSTANCE.selfTeamData;
    }

    public static BaseQuestFile createClientQuestFile() {
        return new ClientQuestFile();
    }

    public static void openGui() {
        ClientQuestFile.openGui();
    }

    public static void openCustomIconGui(Player player, InteractionHand hand) {
        ImageResourceConfig config = new ImageResourceConfig();
        config.onClicked(null, MouseButton.LEFT, accepted -> {
            if (accepted) {
                if (config.isEmpty()) {
                    player.m_21120_(hand).m_41749_("Icon");
                } else {
                    player.m_21120_(hand).m_41700_("Icon", (Tag)StringTag.m_129297_((String)((ResourceLocation)config.getValue()).toString()));
                }
                new SetCustomImageMessage(hand, (ResourceLocation)config.getValue()).sendToServer();
            }
            Minecraft.m_91087_().m_91152_(null);
        });
    }

    public static void openScreenConfigGui(BlockPos pos) {
        BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(pos);
        if (blockEntity instanceof TaskScreenBlockEntity) {
            TaskScreenBlockEntity coreScreen = (TaskScreenBlockEntity)blockEntity;
            new EditConfigScreen(coreScreen.fillConfigGroup(ClientQuestFile.INSTANCE.getOrCreateTeamData(coreScreen.getTeamId()))).setAutoclose(true).openGui();
        }
    }

    public static float[] getTextureUV(BlockState state, Direction face) {
        if (state == null) {
            return null;
        }
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        List quads = model.m_213637_(state, face, RandomSource.m_216327_());
        if (!quads.isEmpty()) {
            TextureAtlasSprite sprite = ((BakedQuad)quads.get(0)).m_173410_();
            return new float[]{sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_()};
        }
        return new float[0];
    }

    public static void rebuildCreativeTabs() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            FTBQuests.LOGGER.debug("deferring creative tab rebuild, client player still null");
            FTBQuestsClientEventHandler.creativeTabRebuildPending = true;
        } else {
            FTBQuests.LOGGER.debug("rebuilding creative tabs now");
            CreativeModeTab.ItemDisplayParameters params = new CreativeModeTab.ItemDisplayParameters(player.f_108617_.m_247016_(), player.m_36337_(), (HolderLookup.Provider)player.m_9236_().m_9598_());
            ((CreativeModeTab)FTBQuestsItems.CREATIVE_TAB.get()).m_269498_(params);
            CreativeModeTabs.m_258007_().m_269498_(params);
        }
    }

    public static Optional<CreativeModeTab.ItemDisplayParameters> creativeTabDisplayParams() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            return Optional.of(new CreativeModeTab.ItemDisplayParameters(player.f_108617_.m_247016_(), ((Boolean)Minecraft.m_91087_().f_91066_.m_257871_().m_231551_()).booleanValue(), (HolderLookup.Provider)player.f_108545_.m_9598_()));
        }
        return Optional.empty();
    }

    public static void copyToClipboard(QuestObjectBase qo) {
        Widget.setClipboardString((String)qo.getCodeString());
    }
}

