/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer.jar;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.MappingResolverImpl;
import org.jetbrains.annotations.Nullable;
import org.sinytra.connector.transformer.jar.JarTransformer;
import org.slf4j.Logger;
import reloc.net.minecraftforge.srgutils.IMappingFile;

public class IntermediateMapping {
    private static final Map<String, IntermediateMapping> INTERMEDIATE_MAPPINGS_CACHE = new HashMap<String, IntermediateMapping>();
    private static final Map<String, Collection<String>> MAPPING_PREFIXES = Map.of("intermediary", Set.of("net/minecraft/class_", "field_", "method_", "comp_"));
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<String, String> mappings;
    private final Map<String, String> extendedMappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntermediateMapping get(String sourceNamespace) {
        IntermediateMapping existing = INTERMEDIATE_MAPPINGS_CACHE.get(sourceNamespace);
        if (existing == null) {
            Class<JarTransformer> clazz = JarTransformer.class;
            synchronized (JarTransformer.class) {
                existing = INTERMEDIATE_MAPPINGS_CACHE.get(sourceNamespace);
                if (existing != null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return existing;
                }
                LOGGER.debug(JarTransformer.TRANSFORM_MARKER, "Creating flat intermediate mapping for namespace {}", (Object)sourceNamespace);
                Collection<String> prefixes = MAPPING_PREFIXES.get(sourceNamespace);
                MappingResolverImpl resolver = FabricLoaderImpl.INSTANCE.getMappingResolver();
                HashMap<String, String> resolved = new HashMap<String, String>();
                HashMap buffer = new HashMap();
                HashMap<String, String> extendedMappings = new HashMap<String, String>();
                resolver.getCurrentMap(sourceNamespace).getClasses().stream().flatMap(cls -> Stream.concat(Stream.of(cls), Stream.concat(cls.getFields().stream(), cls.getMethods().stream())).filter(node -> prefixes.stream().anyMatch(node.getOriginal()::startsWith))).forEach(node -> {
                    String original = node.getOriginal();
                    String mapped = node.getMapped();
                    String mapping = (String)resolved.get(original);
                    if (mapping != null && !mapping.equals(mapped)) {
                        resolved.remove(original);
                        extendedMappings.put(IntermediateMapping.getMappingKey((IMappingFile.INode)buffer.remove(original)), mapping);
                        extendedMappings.put(IntermediateMapping.getMappingKey(node), mapped);
                    } else if (!extendedMappings.containsKey(IntermediateMapping.getMappingKey(node))) {
                        resolved.put(original, mapped);
                        buffer.put(original, node);
                    }
                });
                IntermediateMapping mapping = new IntermediateMapping(resolved, extendedMappings);
                INTERMEDIATE_MAPPINGS_CACHE.put(sourceNamespace, mapping);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return mapping;
            }
        }
        return existing;
    }

    private static String getMappingKey(IMappingFile.INode node) {
        if (node instanceof IMappingFile.IField) {
            IMappingFile.IField field = (IMappingFile.IField)node;
            String desc = field.getDescriptor();
            return field.getOriginal() + (String)(desc != null ? ":" + desc : "");
        }
        if (node instanceof IMappingFile.IMethod) {
            IMappingFile.IMethod method = (IMappingFile.IMethod)node;
            return method.getOriginal() + Objects.requireNonNullElse(method.getDescriptor(), "");
        }
        return node.getOriginal();
    }

    public IntermediateMapping(Map<String, String> mappings, Map<String, String> extendedMappings) {
        this.mappings = mappings;
        this.extendedMappings = extendedMappings;
    }

    @Nullable
    public String map(String name) {
        return this.mappings.get(name);
    }

    @Nullable
    public String mapField(String name, @Nullable String desc) {
        String mapped = this.mappings.get(name);
        if (mapped == null) {
            String qualifier = name + ":" + desc;
            return this.extendedMappings.get(qualifier);
        }
        return mapped;
    }

    public String mapMethodOrDefault(String name, String desc) {
        String mapped = this.mapMethod(name, desc);
        return mapped != null ? mapped : name;
    }

    @Nullable
    public String mapMethod(String name, String desc) {
        String mapped = this.mappings.get(name);
        if (mapped == null) {
            String qualifier = name + desc;
            return this.extendedMappings.get(qualifier);
        }
        return mapped;
    }
}

