/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.locator;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.Nullable;
import org.sinytra.connector.locator.ConnectorLocator;
import org.slf4j.Logger;

public final class EmbeddedDependencies {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String JIJ_ATTRIBUTE_PREFIX = "Embedded-Dependencies-";
    private static final String FABRIC_LOADER_VERSION = "Fabric-Loader-Version";
    private static final String MOD_JIJ_DEP = "Mod";
    private static final String ADAPTER_DATA_PATH = "adapter_data";
    public static final String ADAPTER_PATCH_DATA = "patch_data.json";
    public static final String ADAPTER_LVT_OFFSETS = "lvt_offsets.json";
    private static final Path SELF_PATH = (Path)LamdbaExceptionUtils.uncheck(() -> {
        URL jarLocation = ConnectorLocator.class.getProtectionDomain().getCodeSource().getLocation();
        return Path.of(jarLocation.toURI());
    });
    private static final Attributes ATTRIBUTES = EmbeddedDependencies.readManifestAttributes();
    private static final Supplier<String> JAR_CACHE_VERSION = Suppliers.memoize(() -> {
        String ver = EmbeddedDependencies.class.getPackage().getImplementationVersion();
        if (ver == null) {
            LOGGER.error("Missing Connector jar version, disabling transformer caching");
            return RandomStringUtils.randomAlphabetic((int)5);
        }
        return ver + "," + FMLEnvironment.dist.name().toLowerCase();
    });

    public static Stream<Path> locateEmbeddedJars() {
        return Stream.of(MOD_JIJ_DEP).map(LamdbaExceptionUtils.rethrowFunction(EmbeddedDependencies::getJarInJar));
    }

    public static Path getAdapterData(String path) {
        return SELF_PATH.resolve(ADAPTER_DATA_PATH).resolve(path);
    }

    @Nullable
    public static String getJarCacheVersion() {
        return JAR_CACHE_VERSION.get();
    }

    public static String getFabricLoaderVersion() {
        return ATTRIBUTES.getValue(FABRIC_LOADER_VERSION);
    }

    private static Path getJarInJar(String name) throws IOException, URISyntaxException {
        String depName = ATTRIBUTES.getValue(JIJ_ATTRIBUTE_PREFIX + name);
        if (depName == null) {
            throw new IllegalArgumentException("Required " + name + " embedded jar not found");
        }
        Path pathInModFile = SELF_PATH.resolve(depName);
        URI filePathUri = new URI("jij:" + pathInModFile.toAbsolutePath().toUri().getRawSchemeSpecificPart()).normalize();
        ImmutableMap outerFsArgs = ImmutableMap.of((Object)"packagePath", (Object)pathInModFile);
        FileSystem zipFS = FileSystems.newFileSystem(filePathUri, outerFsArgs);
        return zipFS.getPath("/", new String[0]);
    }

    private static Attributes readManifestAttributes() {
        Manifest manifest;
        Path manifestPath = SELF_PATH.resolve("META-INF/MANIFEST.MF");
        try (InputStream is = Files.newInputStream(manifestPath, new OpenOption[0]);){
            manifest = new Manifest(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return manifest.getMainAttributes();
    }

    private EmbeddedDependencies() {
    }
}

