/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic;

import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.config.ConfigHandler;
import dev.worldgen.tectonic.worldgen.ConfigDensityFunction;
import dev.worldgen.tectonic.worldgen.ErosionNoiseDensityFunction;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="tectonic")
public class TectonicForge {
    private static final List<String> enabledPacks = new ArrayList<String>();

    public TectonicForge() {
        Tectonic.init(FMLPaths.CONFIGDIR.get().resolve("tectonic.json"));
        ConfigHandler.getConfig().enablePacks(ModList.get().isLoaded("terralith"), enabledPacks::add);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::registerDensityFunctionTypes);
        modEventBus.addListener(this::registerEnabledPacks);
    }

    private void registerDensityFunctionTypes(RegisterEvent event) {
        event.register(Registries.f_256746_, helper -> helper.register("config", (Object)ConfigDensityFunction.CODEC_HOLDER.f_216232_()));
        event.register(Registries.f_256746_, helper -> helper.register("erosion_noise", (Object)ErosionNoiseDensityFunction.CODEC_HOLDER.f_216232_()));
    }

    private void registerEnabledPacks(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            for (String packName : enabledPacks) {
                this.registerDatapack(event, packName);
            }
        }
    }

    private void registerDatapack(AddPackFindersEvent event, String packName) {
        boolean increasedHeight = packName.startsWith("increased_height");
        Path resourcePath = ModList.get().getModFileById("tectonic").getFile().findResource(new String[]{"resourcepacks/" + packName.toLowerCase()});
        Pack dataPack = Pack.m_245429_((String)("tectonic/" + (increasedHeight ? "z" : "") + packName.toLowerCase()), (Component)Component.m_237115_((String)("pack_name.tectonic." + packName)), (boolean)false, string -> new PathPackResources(resourcePath.getFileName().toString(), resourcePath, false), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
        event.addRepositorySource(packConsumer -> packConsumer.accept(dataPack));
    }
}

